/*
 * Decompiled with CFR 0.152.
 */
package pscs.wifi_config;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import jssc.SerialPort;
import jssc.SerialPortException;
import pscs.func;
import pscs.publics.ComboBox_String;

public class FrmWifiConfig
extends JFrame {
    private static final long serialVersionUID = 1L;
    private InputStream inputStream;
    private OutputStream outputStream;
    ComboBox_String cmbCommPort = new ComboBox_String();
    JTextArea txtRece = new JTextArea();
    JTextField txtSend = new JTextField();
    JButton butSend = new JButton("Send");
    private SerialPort serialPort;
    Enumeration<?> SerialPortList;

    public static void main(String[] aa) {
        new FrmWifiConfig();
    }

    public FrmWifiConfig() {
        ArrayList<String> al = func.getCommPorts();
        int i = 0;
        while (i < al.size()) {
            this.cmbCommPort.addItem(al.get(i));
            ++i;
        }
        this.initUI();
        this.listener();
        if (this.cmbCommPort.getItemCount() > 0) {
            this.cmbCommPort.setSelectedIndex(this.cmbCommPort.getItemCount() - 1);
        }
    }

    private void initUI() {
        this.txtSend.setText("GETD");
        this.txtRece.setEditable(false);
        JPanel panSend = new JPanel(new BorderLayout());
        panSend.add(this.txtSend);
        panSend.add((Component)this.butSend, "East");
        this.add((Component)this.cmbCommPort, "North");
        this.add(new JScrollPane(this.txtRece));
        this.add((Component)panSend, "South");
        this.setBounds(400, 200, 600, 400);
        this.setVisible(true);
        this.txtSend.requestFocus();
    }

    private void listener() {
        this.cmbCommPort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmWifiConfig.this.close();
                FrmWifiConfig.this.serialPort = new SerialPort(FrmWifiConfig.this.cmbCommPort.getSelectedItem().toString());
                try {
                    FrmWifiConfig.this.serialPort.openPort();
                    FrmWifiConfig.this.serialPort.setParams(9600, 8, 1, 0);
                }
                catch (SerialPortException ex) {
                    System.err.println(ex);
                }
            }
        });
        this.butSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                FrmWifiConfig.this.txtRece.append("Send: " + FrmWifiConfig.this.txtSend.getText() + "\n");
                FrmWifiConfig.this.txtRece.append("Read: " + FrmWifiConfig.this.sendCOM(FrmWifiConfig.this.txtSend.getText()) + "\n");
            }
        });
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent e) {
            }

            @Override
            public void windowIconified(WindowEvent e) {
            }

            @Override
            public void windowDeiconified(WindowEvent e) {
            }

            @Override
            public void windowDeactivated(WindowEvent e) {
            }

            @Override
            public void windowClosing(WindowEvent e) {
                FrmWifiConfig.this.close();
                System.exit(0);
            }

            @Override
            public void windowClosed(WindowEvent e) {
            }

            @Override
            public void windowActivated(WindowEvent e) {
            }
        });
    }

    public String sendCOM(String cmd) {
        String readStr = "";
        try {
            Thread.sleep(50L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        byte[] sendBuf = cmd.getBytes();
        if (this.outputStream == null) {
            return "";
        }
        try {
            if (this.inputStream.available() != 0) {
                this.inputStream.read(new byte[1000]);
            }
        }
        catch (IOException iOException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        try {
            this.outputStream.write(sendBuf);
        }
        catch (IOException e) {
            this.close();
        }
        readStr = this.readCOM(cmd);
        return readStr;
    }

    private String readCOM(String cmd) {
        String strRead = "";
        long timeLast = System.currentTimeMillis();
        int timeOut = 500;
        System.out.println(111);
        try {
            while (System.currentTimeMillis() - timeLast < (long)timeOut) {
                try {
                    Thread.sleep(5L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (this.inputStream.available() == 0) continue;
                System.out.println(222);
                byte[] readBuffer = new byte[1000];
                timeLast = System.currentTimeMillis();
                String lineStr = "";
                int numBytes = this.inputStream.read(readBuffer);
                int i = 0;
                while (i < numBytes) {
                    lineStr = String.valueOf(lineStr) + (char)readBuffer[i];
                    ++i;
                }
                strRead = String.valueOf(strRead) + lineStr;
                if (cmd.indexOf("?") >= 0) {
                    strRead = strRead.replace("\n", "OK");
                }
                if (strRead.indexOf("OK") < 0) {
                    continue;
                }
                break;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        strRead = strRead.replace("\r", "");
        System.out.println(999);
        return strRead;
    }

    public void close() {
        block8: {
            try {
                if (this.outputStream != null) {
                    this.outputStream.close();
                }
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
                if (this.serialPort == null) break block8;
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                this.serialPort.closePort();
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

