/*
 * Decompiled with CFR 0.152.
 */
package pscs.wfg;

import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import pscs.App;
import pscs.MyButton;
import pscs._FrmPSCS;
import pscs.connect.Connect;
import pscs.enums.EnmSerial;
import pscs.func;
import pscs.wfg.CellEditorTxtDataType;

public class PanWaveFormGenerator
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public JPanel panWFPS = new JPanel(new BorderLayout());
    private JPanel panWFPS2 = new JPanel(new BorderLayout());
    public PanCanvas panCanvas = new PanCanvas();
    public JPanel panTopFuncABC = new JPanel();
    public JPanel panTopABCSelect = new JPanel(new BorderLayout());
    public JPanel panTopRange = new JPanel(new BorderLayout());
    public JPanel panTopTransitTime = new JPanel();
    public JPanel panTopRunCycle = new JPanel();
    public JPanel panTopRunCmbBut = new JPanel();
    public JPanel panTopRun = new JPanel(new BorderLayout());
    public JScrollPane scpanABC = null;
    private String[] fieldNameABC = new String[]{"", "A", "B", "C"};
    private String[] fieldNameTime = new String[]{"A-B", "B-A", "A-C", "C-A", "B-C", "C-B"};
    public DefaultTableModel dtmABC = new DefaultTableModel(new Object[][]{{"Voltage(V)", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"Current(A)", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}, {"Time(S)", Float.valueOf(0.0f), Float.valueOf(0.0f), Float.valueOf(0.0f)}}, this.fieldNameABC){
        private static final long serialVersionUID = 1L;

        @Override
        public Class<?> getColumnClass(int columnIndex) {
            Object obj = this.getValueAt(0, columnIndex);
            return obj == null ? String.class : obj.getClass();
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return PanWaveFormGenerator.this.fieldNameABC[column] != "";
        }
    };
    public JTable tableSetting = new JTable(this.dtmABC);
    public JTable tableTime = new JTable(new DefaultTableModel(new String[][]{{"0", "0", "0", "0", "0", "0"}}, this.fieldNameTime));
    ButtonGroup buttonGroupRange = new ButtonGroup();
    public JRadioButton rbut16 = new JRadioButton("16V/5A");
    public JRadioButton rbut27 = new JRadioButton("27V/3A");
    public JRadioButton rbut36 = new JRadioButton("36V/2.2A");
    ButtonGroup buttonGroupABC = new ButtonGroup();
    public JRadioButton rbutA = new JRadioButton("A");
    public JRadioButton rbutB = new JRadioButton("B");
    public JRadioButton rbutC = new JRadioButton("C");
    public JRadioButton rbutD = new JRadioButton("D");
    public MyButton butSetSetting = new MyButton("Apply");
    public MyButton butSetRange = new MyButton("Apply");
    public MyButton butSetABCSelect = new MyButton("Apply");
    public MyButton butSetTransitTime = new MyButton("Apply");
    public JLabel labRunCycle = new JLabel("Running Cycle:");
    public JTextField txtRunCycle = new JTextField("0", 3);
    public MyButton butRunWfg = new MyButton("Run");
    public JComboBox<String> cmbRunWfg = new JComboBox<String>(this.fieldNameTime);
    private ABC abc = new ABC();
    private Font fontB = new Font(this.getFont().getFontName(), 1, 12);
    NumberFormat df1 = NumberFormat.getInstance();
    private _FrmPSCS pscs;
    public JPanel panWFG_Top = new JPanel(new BorderLayout());
    boolean isCmbRunWfgAction = true;

    public PanWaveFormGenerator(_FrmPSCS pscs) {
        this.pscs = pscs;
        this.setName("WFG");
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(3, 3, 3, 3));
        this.df1.setMaximumFractionDigits(1);
        this.df1.setMinimumFractionDigits(0);
        DefaultTableCellRenderer rc = new DefaultTableCellRenderer();
        rc.setHorizontalAlignment(0);
        rc.setBackground(Color.GRAY);
        this.tableSetting.getColumn(this.tableSetting.getColumnName(0)).setCellRenderer(new MyCellRenderer());
        this.tableSetting.getColumn(this.tableSetting.getColumnName(1)).setCellRenderer(new MyCellRenderer());
        this.tableSetting.getColumn(this.tableSetting.getColumnName(2)).setCellRenderer(new MyCellRenderer());
        this.tableSetting.getColumn(this.tableSetting.getColumnName(3)).setCellRenderer(new MyCellRenderer());
        this.tableSetting.setShowGrid(true);
        this.tableSetting.setGridColor(pscs.app.gridLineColor);
        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
        r.setHorizontalAlignment(0);
        this.tableSetting.setDefaultRenderer(Object.class, r);
        this.tableTime.setDefaultRenderer(Object.class, r);
        this.tableSetting.setRowSelectionAllowed(false);
        this.tableTime.setRowSelectionAllowed(false);
        this.tableTime.setShowGrid(true);
        this.tableTime.setGridColor(pscs.app.gridLineColor);
        this.tableSetting.setRowHeight(19);
        this.tableTime.setRowHeight(19);
        this.tableSetting.getTableHeader().setPreferredSize(new Dimension(1, 19));
        this.tableTime.getTableHeader().setPreferredSize(new Dimension(1, 19));
        this.tableSetting.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.tableSetting.getColumnModel().getColumn(2).setPreferredWidth(40);
        this.tableSetting.getColumnModel().getColumn(3).setPreferredWidth(40);
        this.buttonGroupRange.add(this.rbut16);
        this.buttonGroupRange.add(this.rbut27);
        this.buttonGroupRange.add(this.rbut36);
        JPanel panTopRangeCenter = new JPanel(new GridLayout(1, 3));
        JPanel panTopRangeButton = new JPanel();
        panTopRangeCenter.add(this.rbut16);
        panTopRangeCenter.add(this.rbut27);
        panTopRangeCenter.add(this.rbut36);
        panTopRangeButton.add(this.butSetRange);
        this.panTopRange.add(panTopRangeCenter);
        this.panTopRange.add((Component)panTopRangeButton, "East");
        this.buttonGroupABC.add(this.rbutA);
        this.buttonGroupABC.add(this.rbutB);
        this.buttonGroupABC.add(this.rbutC);
        this.buttonGroupABC.add(this.rbutD);
        this.rbutD.setVisible(false);
        this.scpanABC = new JScrollPane(this.tableSetting);
        JScrollPane scpanTime = new JScrollPane(this.tableTime);
        this.scpanABC.setPreferredSize(new Dimension(240, 82));
        scpanTime.setPreferredSize(new Dimension(240, 44));
        this.panTopFuncABC.setBorder(BorderFactory.createCompoundBorder(new TitledBorder(""), new EmptyBorder(3, 3, 3, 3)));
        this.panTopFuncABC.add(this.scpanABC);
        this.panTopFuncABC.add(this.butSetSetting);
        JPanel panTopABCSelectCenter = new JPanel();
        JPanel panTopABCSelectButton = new JPanel();
        panTopABCSelectCenter.setBorder(new EmptyBorder(7, 0, 0, 0));
        panTopABCSelectCenter.add(this.rbutA);
        panTopABCSelectCenter.add(this.rbutB);
        panTopABCSelectCenter.add(this.rbutC);
        panTopABCSelectButton.add(this.butSetABCSelect);
        this.panTopABCSelect.add(panTopABCSelectCenter);
        this.panTopABCSelect.add((Component)panTopABCSelectButton, "East");
        this.panTopTransitTime.add(scpanTime);
        this.panTopTransitTime.add(this.butSetTransitTime);
        this.panTopRun.add((Component)this.panTopRunCycle, "North");
        this.panTopRun.add((Component)this.panTopRunCmbBut, "South");
        this.panTopRunCycle.add(this.labRunCycle);
        this.panTopRunCycle.add(this.txtRunCycle);
        this.panTopRunCmbBut.add(this.cmbRunWfg);
        this.panTopRunCmbBut.add(this.butRunWfg);
        this.panWFG_Top.setLayout(new BoxLayout(this.panWFG_Top, 0));
        JPanel panWFG_TopL1 = new JPanel(null);
        JPanel panWFG_TopL2 = new JPanel(null);
        panWFG_TopL1.setLayout(new BoxLayout(panWFG_TopL1, 1));
        panWFG_TopL2.setLayout(new BoxLayout(panWFG_TopL2, 1));
        this.panWFG_Top.add(panWFG_TopL1);
        this.panWFG_Top.add(panWFG_TopL2);
        this.panWFG_Top.add(new JPanel());
        panWFG_TopL1.add(this.panTopFuncABC);
        panWFG_TopL1.add(this.panTopTransitTime);
        panWFG_TopL2.add(this.panTopRange);
        panWFG_TopL2.add(this.panTopABCSelect);
        panWFG_TopL2.add(this.panTopRun);
        this.panWFPS2.setBorder(new EmptyBorder(5, 6, 6, 6));
        this.panWFPS.add(this.panWFPS2);
        this.panWFPS2.add(this.panCanvas);
        this.panCanvas.repaint();
        this.add((Component)this.panWFG_Top, "North");
        this.add(this.panWFPS);
        this.Listeners();
    }

    public void setRunWFG_Enabled() {
        if (!_FrmPSCS.getIt().getConnCurr().isRunningTableWFG && !_FrmPSCS.getIt().getConnCurr().isTableEtpValidData) {
            boolean isErr = false;
            int column = 1;
            while (column < this.tableSetting.getColumnCount()) {
                int row = 0;
                while (row < this.tableSetting.getRowCount() - 1) {
                    float f = func.getFloat(this.tableSetting.getValueAt(row, column));
                    if (row == 0) {
                        if (f < this.pscs.getConnCurr().ps.getMin().getVolt() || f > this.pscs.getConnCurr().ps.getUwl().getVolt()) {
                            isErr = true;
                        }
                    } else if (row < this.tableSetting.getRowCount() - 1 && (f < this.pscs.getConnCurr().ps.getMin().getCurr() || f > this.pscs.getConnCurr().ps.getUwl().getCurr())) {
                        isErr = true;
                    }
                    ++row;
                }
                ++column;
            }
            if (isErr && this.butRunWfg.isEnabled()) {
                this.butSetSetting.setEnabled(false);
                this.butRunWfg.setEnabled(false);
            } else if (!isErr && !this.butRunWfg.isEnabled()) {
                this.butSetSetting.setEnabled(true);
                this.butRunWfg.setEnabled(true);
            }
        }
    }

    public void setCpts() {
        Connect conn = this.pscs.getConnCurr();
        if (conn.getConnInfo().getSerial() == EnmSerial.SSP9 || conn.getConnInfo().getSerial() == EnmSerial.KPS || conn.getConnInfo().getSerial() == EnmSerial.NEP || conn.getConnInfo().getModel().startsWith("SDP2")) {
            int col;
            this.fieldNameABC = new String[]{" ", "1", "2", "3", "4", "5", "6", "7", "8", "9", "10"};
            this.panTopTransitTime.setVisible(false);
            if (conn.getConnInfo().getSerial() == EnmSerial.KPS || conn.getConnInfo().getSerial() == EnmSerial.NEP || conn.getConnInfo().getModel().startsWith("SDP2")) {
                this.panTopRange.setVisible(false);
            }
            this.isCmbRunWfgAction = false;
            this.cmbRunWfg.removeAllItems();
            int idx = 2;
            while (idx <= 10) {
                this.cmbRunWfg.addItem(String.valueOf(idx) + " Point");
                ++idx;
            }
            this.isCmbRunWfgAction = true;
            if (this.tableSetting.getColumnCount() < 11) {
                col = this.tableSetting.getColumnCount();
                while (col <= 10) {
                    this.dtmABC.addColumn(this.fieldNameABC[col]);
                    ++col;
                }
            }
            if (conn.ps.getDataWfgSetting() != null) {
                try {
                    col = 1;
                    while (col <= 10) {
                        this.tableSetting.getModel().setValueAt(conn.ps.getDataWfgSetting()[0][col], 0, col);
                        this.tableSetting.getModel().setValueAt(conn.ps.getDataWfgSetting()[1][col], 1, col);
                        this.tableSetting.getModel().setValueAt(conn.ps.getDataWfgSetting()[2][col], 2, col);
                        ++col;
                    }
                }
                catch (IndexOutOfBoundsException col2) {
                    // empty catch block
                }
            }
            int col3 = 1;
            while (col3 < this.tableSetting.getColumnCount()) {
                this.tableSetting.getColumnModel().getColumn(col3).setCellRenderer(new MyCellRenderer());
                ++col3;
            }
            int column = 1;
            while (column < this.tableSetting.getColumnCount()) {
                this.tableSetting.getColumnModel().getColumn(column).setHeaderValue(this.fieldNameABC[column]);
                ++column;
            }
            this.panTopABCSelect.setVisible(false);
            this.scpanABC.setPreferredSize(new Dimension(460, 82));
            this.panWFG_Top.setPreferredSize(new Dimension(200, 150));
            this.panTopFuncABC.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.pscs.lang.getString("Lang_Setting"), 1, 2, App.getIt().font));
        } else {
            this.fieldNameABC = new String[]{" ", "A", "B", "C"};
            this.panTopTransitTime.setVisible(true);
            this.cmbRunWfg.removeAllItems();
            this.cmbRunWfg.removeAllItems();
            int idx = 0;
            while (idx < this.fieldNameTime.length) {
                this.cmbRunWfg.addItem(this.fieldNameTime[idx]);
                ++idx;
            }
            this.dtmABC.setColumnCount(4);
            int col = 0;
            while (col < this.tableSetting.getColumnCount()) {
                this.tableSetting.getColumnModel().getColumn(col).setCellRenderer(new MyCellRenderer());
                ++col;
            }
            int column = 0;
            while (column < this.tableSetting.getColumnCount()) {
                this.tableSetting.getColumnModel().getColumn(column).setHeaderValue(this.fieldNameABC[column]);
                ++column;
            }
            this.panTopABCSelect.setVisible(true);
            this.scpanABC.setPreferredSize(new Dimension(240, 82));
            this.panWFG_Top.setPreferredSize(new Dimension(200, 200));
            this.panTopFuncABC.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), this.pscs.lang.getString("Lang_Setting_Func_ABC"), 1, 2, App.getIt().font));
            if (this.tableSetting.getRowCount() == 2) {
                this.dtmABC.insertRow(1, new String[]{String.valueOf(this.pscs.lang.getString("Lang_Current")) + "(A)", "0", "0", "0"});
                this.scpanABC.setPreferredSize(new Dimension(240, 82));
            }
        }
        this.tableSetting.getColumnModel().getColumn(0).setMinWidth(80);
    }

    void Listeners() {
        this.butSetSetting.addActionListener(this);
        this.butSetRange.addActionListener(this);
        this.butSetABCSelect.addActionListener(this);
        this.butSetTransitTime.addActionListener(this);
        this.butRunWfg.addActionListener(this);
        this.cmbRunWfg.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                if (PanWaveFormGenerator.this.isCmbRunWfgAction) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.setRunWfgSelectedIndex(PanWaveFormGenerator.this.cmbRunWfg.getSelectedIndex());
                    PanWaveFormGenerator.this.panCanvas.repaint();
                }
            }
        });
        this.txtRunCycle.addFocusListener(new FocusListener(){

            @Override
            public void focusLost(FocusEvent e) {
                if (func.getInt(PanWaveFormGenerator.this.txtRunCycle.getText()) > 999) {
                    PanWaveFormGenerator.this.txtRunCycle.setText("999");
                }
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.setRunCycle(func.getInt(PanWaveFormGenerator.this.txtRunCycle.getText()));
            }

            @Override
            public void focusGained(FocusEvent e) {
            }
        });
        this.tableSetting.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Component editorComp = PanWaveFormGenerator.this.tableSetting.getEditorComponent();
                if (editorComp == null) {
                    PanWaveFormGenerator.this.tableSetting.editCellAt(PanWaveFormGenerator.this.tableSetting.getSelectedRow(), PanWaveFormGenerator.this.tableSetting.getSelectedColumn());
                }
                editorComp = PanWaveFormGenerator.this.tableSetting.getEditorComponent();
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                Component editorComp = PanWaveFormGenerator.this.tableSetting.getEditorComponent();
                if (editorComp != null) {
                    if (editorComp instanceof JTextField && arg0.getKeyChar() != '\n') {
                        ((JTextField)editorComp).setText(null);
                    }
                    editorComp.requestFocus();
                }
            }
        });
        this.tableSetting.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                int row = arg0.getLastRow();
                int column = arg0.getColumn();
                if (column <= 0) {
                    return;
                }
                if (row == PanWaveFormGenerator.this.tableSetting.getRowCount() - 1) {
                    int intVal = 0;
                    try {
                        String strVal = PanWaveFormGenerator.this.tableSetting.getValueAt(row, column).toString();
                        intVal = func.getInt(PanWaveFormGenerator.this.tableSetting.getValueAt(row, column));
                        if (PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.KPS || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.NEP) {
                            if (intVal > 1200) {
                                intVal = 1200;
                            }
                        } else if (intVal > 600) {
                            intVal = 600;
                        }
                        if (!("" + intVal).equals(strVal)) {
                            PanWaveFormGenerator.this.tableSetting.setValueAt(intVal, row, column);
                        }
                    }
                    catch (NullPointerException e) {
                        PanWaveFormGenerator.this.tableSetting.setValueAt(0, row, column);
                    }
                    catch (NumberFormatException e) {
                        PanWaveFormGenerator.this.tableSetting.setValueAt(0, row, column);
                    }
                } else if (row == 0) {
                    try {
                        float c;
                        float v = func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(row, column));
                        v = func.getAndCheckVolt(((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getModel(), v);
                        if (v > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt()) {
                            v = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt();
                        }
                        if (PanWaveFormGenerator.this.tableSetting.getRowCount() == 3 && v * (c = func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(row + 1, column))) > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower()) {
                            String msg = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.lang.getString("Lang_Power_greater_than_%w_the_setting_is_invalid");
                            msg = msg.replace("%", "" + (int)((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower());
                            JOptionPane.showMessageDialog(new Frame(), msg, App.getIt().name, 0);
                            v = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower() / c;
                        }
                        String strV = func.getDecimalFormat(((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getVoltFormatSetting()).format(v);
                        if (PanWaveFormGenerator.this.tableSetting.getValueAt(row, column) != null && !strV.equals(PanWaveFormGenerator.this.tableSetting.getValueAt(row, column).toString())) {
                            PanWaveFormGenerator.this.tableSetting.setValueAt(strV, row, column);
                        }
                    }
                    catch (NumberFormatException e) {
                        PanWaveFormGenerator.this.tableSetting.setValueAt(0, row, column);
                    }
                } else if (row == 1 && PanWaveFormGenerator.this.tableSetting.getRowCount() == 3) {
                    try {
                        String strC;
                        float v;
                        float c = func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(row, column));
                        if (c > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getCurr()) {
                            c = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getCurr();
                        }
                        if (c * (v = func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(row - 1, column))) > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower()) {
                            String msg = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.lang.getString("Lang_Power_greater_than_%w_the_setting_is_invalid");
                            msg = msg.replace("%", "" + (int)((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower());
                            JOptionPane.showMessageDialog(new Frame(), msg, App.getIt().name, 0);
                            c = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower() / v;
                        }
                        if (!(strC = func.getDecimalFormat(((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getCurrFormatSetting()).format(c)).equals(PanWaveFormGenerator.this.tableSetting.getValueAt(row, column).toString())) {
                            PanWaveFormGenerator.this.tableSetting.setValueAt(strC, row, column);
                        }
                    }
                    catch (NullPointerException e) {
                        PanWaveFormGenerator.this.tableSetting.setValueAt(0, row, column);
                    }
                    catch (NumberFormatException e) {
                        PanWaveFormGenerator.this.tableSetting.setValueAt(0, row, column);
                    }
                }
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().isChangeFuncABC = true;
                PanWaveFormGenerator.this.panCanvas.repaint();
                PanWaveFormGenerator.this.setRunWFG_Enabled();
            }
        });
        this.tableTime.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent arg0) {
                int row = arg0.getLastRow();
                int column = arg0.getColumn();
                int val = 0;
                try {
                    val = func.getInt(PanWaveFormGenerator.this.tableTime.getValueAt(row, column).toString());
                    if (val > 20) {
                        PanWaveFormGenerator.this.tableTime.setValueAt(20, row, column);
                    }
                }
                catch (Exception e) {
                    PanWaveFormGenerator.this.tableTime.setValueAt(0, row, column);
                }
                PanWaveFormGenerator.this.panCanvas.repaint();
            }
        });
        this.tableTime.getColumnModel().addColumnModelListener(new TableColumnModelListener(){

            @Override
            public void columnAdded(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnMarginChanged(ChangeEvent arg0) {
            }

            @Override
            public void columnMoved(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnRemoved(TableColumnModelEvent arg0) {
            }

            @Override
            public void columnSelectionChanged(ListSelectionEvent arg0) {
                PanWaveFormGenerator.this.tableTime.getColumn(PanWaveFormGenerator.this.tableTime.getColumnName(PanWaveFormGenerator.this.tableTime.getSelectedColumn())).setCellEditor(new CellEditorTxtDataType(PanWaveFormGenerator.this.tableTime));
            }
        });
        this.tableTime.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
                Component editorComp = PanWaveFormGenerator.this.tableTime.getEditorComponent();
                if (editorComp == null) {
                    PanWaveFormGenerator.this.tableTime.editCellAt(PanWaveFormGenerator.this.tableTime.getSelectedRow(), PanWaveFormGenerator.this.tableTime.getSelectedColumn());
                }
                editorComp = PanWaveFormGenerator.this.tableTime.getEditorComponent();
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
                Component editorComp = PanWaveFormGenerator.this.tableTime.getEditorComponent();
                if (editorComp != null) {
                    if (editorComp instanceof JTextField && arg0.getKeyChar() != '\n') {
                        ((JTextField)editorComp).setText(null);
                    }
                    editorComp.requestFocus();
                }
            }
        });
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.butSetSetting) {
            this.pscs.getConnCurr().isSaveFuncABC = true;
            Object[][] arr = new Object[3][11];
            arr[0][0] = String.valueOf(this.pscs.lang.getString("Lang_Voltage")) + "(V)";
            arr[1][0] = String.valueOf(this.pscs.lang.getString("Lang_Current")) + "(A)";
            arr[2][0] = String.valueOf(this.pscs.lang.getString("Lang_Time")) + "(S)";
            int column = 1;
            while (column < 11) {
                arr[0][column] = Float.valueOf(func.getFloat(this.tableSetting.getValueAt(0, column)));
                arr[1][column] = Float.valueOf(func.getFloat(this.tableSetting.getValueAt(1, column)));
                arr[2][column] = func.getInt(this.tableSetting.getValueAt(2, column));
                System.out.println(arr[0][column] + "\t" + arr[1][column] + "\t" + arr[2][column]);
                ++column;
            }
            this.pscs.getConnCurr().ps.setDataWfgSetting(arr);
        } else if (e.getSource() == this.butSetRange) {
            this.pscs.getConnCurr().isSetRangeChannel = true;
        } else if (e.getSource() == this.butSetABCSelect) {
            this.pscs.getConnCurr().isSetABC_Select = true;
        } else if (e.getSource() == this.butSetTransitTime) {
            this.pscs.getConnCurr().isSaveTransitTime = true;
        } else if (e.getSource() == this.butRunWfg) {
            this.pscs.getConnCurr().isRunWFG = true;
            this.pscs.getConnCurr().ps.setRunCycle(func.getInt(this.txtRunCycle.getText()));
            this.pscs.getConnCurr().ps.setRunWfgSelectedIndex(this.cmbRunWfg.getSelectedIndex());
        }
    }

    class ABC {
        public boolean MouseInBoxSide = false;
        int[] ABC_Defer = new int[3];
        int[] A_B_Defer = new int[6];
        float[][] ABC_Set = new float[4][2];
        String ABC_Select = "";
        float[][] Point5_XY = new float[5][2];
        float[][] Point_XY = new float[11][2];
        String[] Point5Name = new String[5];
        String[] PointName = new String[]{"A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "A"};
        public int validPoint = 5;
        int xTotal;
        int Len1;
        int Len12;
        int Len21;
        int Len2;
        String StrPointStart = "";
        String StrPointEnd = "";
        float ValueStart;
        float ValueEnd;
        float ValueBoxMax;
        boolean isClickDown;
        int Click_Index;
        int Circle_R = 6;
        int presetX = 0;
        float presetY = 0.0f;

        ABC() {
        }

        void refreABC() {
            boolean BL1 = false;
            boolean BL2 = false;
            this.StrPointStart = PanWaveFormGenerator.this.cmbRunWfg.getSelectedItem().toString().trim().substring(0, 1);
            this.StrPointEnd = PanWaveFormGenerator.this.cmbRunWfg.getSelectedItem().toString().substring(PanWaveFormGenerator.this.cmbRunWfg.getSelectedItem().toString().length() - 1);
            this.ValueBoxMax = this.ValueStart > this.ValueEnd ? this.ValueStart : this.ValueEnd;
            if (((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt() > this.ValueBoxMax) {
                this.ValueBoxMax = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt();
            }
            this.ValueStart = this.StrPointStart.equals("A") ? this.ABC_Set[0][0] : (this.StrPointStart.equals("B") ? this.ABC_Set[1][0] : this.ABC_Set[2][0]);
            this.ValueEnd = this.StrPointEnd.equals("A") ? this.ABC_Set[0][0] : (this.StrPointEnd.equals("B") ? this.ABC_Set[1][0] : this.ABC_Set[2][0]);
            int i = 1;
            while (i <= 3) {
                if (this.StrPointStart.equals(PanWaveFormGenerator.this.fieldNameABC[i])) {
                    this.Len1 = (int)func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, i).toString());
                } else if (this.StrPointEnd.equals(PanWaveFormGenerator.this.fieldNameABC[i])) {
                    this.Len2 = (int)func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, i).toString());
                }
                ++i;
            }
            i = 0;
            while (i < PanWaveFormGenerator.this.cmbRunWfg.getItemCount()) {
                if (this.StrPointEnd.equals(PanWaveFormGenerator.this.cmbRunWfg.getItemAt(i).trim().subSequence(0, 1)) && this.StrPointStart.equals(PanWaveFormGenerator.this.cmbRunWfg.getItemAt(i).substring(PanWaveFormGenerator.this.cmbRunWfg.getItemAt(i).length() - 1))) {
                    String strRunABC = PanWaveFormGenerator.this.cmbRunWfg.getItemAt(PanWaveFormGenerator.this.cmbRunWfg.getSelectedIndex()).trim();
                    int j = 0;
                    while (j < 6) {
                        if (PanWaveFormGenerator.this.fieldNameTime[j].equals(strRunABC)) {
                            this.Len12 = func.getInt(PanWaveFormGenerator.this.tableTime.getValueAt(0, j).toString());
                            BL1 = true;
                            break;
                        }
                        ++j;
                    }
                    if (BL1) break;
                }
                ++i;
            }
            i = 0;
            while (i < PanWaveFormGenerator.this.cmbRunWfg.getItemCount()) {
                if (this.StrPointEnd.equals(PanWaveFormGenerator.this.cmbRunWfg.getItemAt(i).trim().subSequence(0, 1)) && this.StrPointStart.equals(PanWaveFormGenerator.this.cmbRunWfg.getItemAt(i).substring(PanWaveFormGenerator.this.cmbRunWfg.getItemAt(i).length() - 1))) {
                    int j = 0;
                    while (j < 6) {
                        if (PanWaveFormGenerator.this.fieldNameTime[j].equals(PanWaveFormGenerator.this.cmbRunWfg.getItemAt(i).trim())) {
                            this.Len21 = func.getInt(PanWaveFormGenerator.this.tableTime.getValueAt(0, j).toString());
                            BL2 = true;
                            break;
                        }
                        ++j;
                    }
                    if (BL2) break;
                }
                ++i;
            }
            if (PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.SSP9 || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.KPS || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.NEP) {
                String val = PanWaveFormGenerator.this.cmbRunWfg.getSelectedItem().toString().substring(0, 2).trim();
                this.validPoint = func.getInt(val);
                int i2 = 1;
                while (i2 <= this.validPoint) {
                    this.PointName[i2 - 1] = String.valueOf(i2);
                    ++i2;
                }
                this.PointName[this.validPoint] = this.PointName[0];
                PanWaveFormGenerator.this.tableSetting.repaint();
            } else {
                this.validPoint = 5;
                if (this.Len12 > this.Len2) {
                    this.Len12 = this.Len2;
                }
                if (this.Len21 > this.Len1) {
                    this.Len21 = this.Len1;
                }
                this.xTotal = this.Len1 + this.Len2;
            }
            if (PanWaveFormGenerator.this.pscs.getSerialCurr() != EnmSerial.KPS) {
                i = 0;
                while (i < 6) {
                    if (i < 3) {
                        this.ABC_Set[i][0] = func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(0, i + 1).toString());
                        if (this.StrPointStart.equals(PanWaveFormGenerator.this.fieldNameABC[i + 1])) {
                            this.ValueStart = this.ABC_Set[i][0];
                        } else if (this.StrPointEnd.equals(PanWaveFormGenerator.this.fieldNameABC[i + 1])) {
                            this.ValueEnd = this.ABC_Set[i][0];
                        }
                    }
                    this.A_B_Defer[i] = func.getInt(PanWaveFormGenerator.this.tableTime.getValueAt(0, i).toString());
                    ++i;
                }
            }
            if (PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.SSP9 || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.KPS || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.NEP) {
                int s = 0;
                int column = 1;
                while (column <= this.validPoint) {
                    this.Point_XY[column - 1][0] = s;
                    this.Point_XY[column - 1][1] = func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(0, column));
                    s += func.getInt(PanWaveFormGenerator.this.tableSetting.getValueAt(PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, column));
                    ++column;
                }
                this.Point_XY[this.validPoint][0] = s;
                this.Point_XY[this.validPoint][1] = this.Point_XY[0][1];
                this.xTotal = s;
            } else {
                this.Point5_XY[0][0] = 0.0f;
                this.Point5_XY[1][0] = this.Len12;
                this.Point5_XY[2][0] = this.Len2;
                this.Point5_XY[3][0] = this.Len2 + this.Len21;
                this.Point5_XY[4][0] = this.xTotal;
            }
            this.Point5_XY[0][1] = this.ValueStart;
            this.Point5_XY[1][1] = this.ValueEnd;
            this.Point5_XY[2][1] = this.ValueEnd;
            this.Point5_XY[3][1] = this.ValueStart;
            this.Point5_XY[4][1] = this.ValueStart;
            this.Point5Name[0] = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart;
            this.Point5Name[1] = String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart) + "-" + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointEnd;
            this.Point5Name[2] = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointEnd;
            this.Point5Name[3] = String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointEnd) + "-" + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart;
            this.Point5Name[4] = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart;
        }
    }

    class BOX {
        private int pageWidth;
        private int pageHeight;
        private int x1;
        private int y1;
        private int x2;
        private int y2;
        private int boxWidth;
        private int boxHeight;

        public BOX(int pageWidth, int pageHeight, boolean isPage) {
            this.pageWidth = pageWidth;
            this.pageHeight = pageHeight;
            if (isPage) {
                this.x1 = 80;
                this.x2 = pageWidth - 70;
                this.y1 = 250;
                this.y2 = pageHeight - 60;
            } else {
                this.x1 = 60;
                this.x2 = pageWidth - 60;
                this.y1 = 40;
                this.y2 = pageHeight - 40;
            }
            this.boxWidth = this.x2 - this.x1;
            this.boxHeight = this.y2 - this.y1;
        }

        public int getPageWidth() {
            return this.pageWidth;
        }

        public void setPageWidth(int pageWidth) {
            this.pageWidth = pageWidth;
        }

        public int getPageHeight() {
            return this.pageHeight;
        }

        public void setPageHeight(int pageHeight) {
            this.pageHeight = pageHeight;
        }

        public int getWidth() {
            return this.boxWidth;
        }

        public void setWidth(int width) {
            this.boxWidth = width;
        }

        public int getHeight() {
            return this.boxHeight;
        }

        public void setHeight(int height) {
            this.boxHeight = height;
        }

        public int getX1() {
            return this.x1;
        }

        public void setX1(int x1) {
            this.x1 = x1;
        }

        public int getY1() {
            return this.y1;
        }

        public void setY1(int y1) {
            this.y1 = y1;
        }

        public int getY2() {
            return this.y2;
        }

        public void setY2(int y2) {
            this.y2 = y2;
        }

        public int getX2() {
            return this.x2;
        }

        public void setX2(int x2) {
            this.x2 = x2;
        }
    }

    class MyCellRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        MyCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (table.getColumnName(column).equals("") || column > ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint) {
                this.setBackground(row % 2 == 1 ? new Color(229, 229, 229) : new Color(242, 242, 242));
            } else {
                this.setBackground(row % 2 == 1 ? new Color(242, 242, 242) : Color.WHITE);
            }
            float f = func.getFloat(value);
            if (column == 0) {
                this.setHorizontalAlignment(0);
            } else {
                if (row < table.getRowCount() - 1) {
                    value = row == 0 ? func.getDecimalFormat(((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getVoltFormatSetting()).format(f) : func.getDecimalFormat(((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getCurrFormatSetting()).format(f);
                }
                this.setHorizontalAlignment(4);
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.isClickDown) {
                    if (row == 0) {
                        this.setForeground(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index < ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint && column == ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index + 1 || ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint && column == 1 ? Color.RED : Color.BLACK);
                    } else if (row == PanWaveFormGenerator.this.tableSetting.getRowCount() - 1) {
                        this.setForeground(column == ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index ? Color.RED : Color.BLACK);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                } else {
                    boolean isRed = false;
                    if (row == 0) {
                        isRed = f < ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMin().getVolt() || f > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt();
                        this.setForeground(isRed ? Color.RED : Color.BLACK);
                    } else if (row < PanWaveFormGenerator.this.tableSetting.getRowCount() - 1) {
                        isRed = f < ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMin().getCurr() || f > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getCurr();
                        this.setForeground(isRed ? Color.RED : Color.BLACK);
                    } else {
                        this.setForeground(Color.BLACK);
                    }
                }
            }
            this.setBorder(hasFocus ? BorderFactory.createLineBorder(Color.GRAY) : new EmptyBorder(0, 2, 0, 2));
            return this;
        }
    }

    public class PanCanvas
    extends JPanel {
        private static final long serialVersionUID = 1L;
        private BOX box;
        private int mouseX;
        private int mouseY;

        public PanCanvas() {
            this.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseDragged(MouseEvent arg0) {
                }

                @Override
                public void mouseMoved(MouseEvent arg0) {
                    PanCanvas.this.mouseX = arg0.getX();
                    PanCanvas.this.mouseY = arg0.getY();
                    PanCanvas.this.repaint();
                }
            });
            this.addMouseListener(new MouseListener(){

                @Override
                public void mouseClicked(MouseEvent arg0) {
                    try {
                        ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    try {
                        ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableTime.getCellEditor().stopCellEditing();
                    }
                    catch (NullPointerException nullPointerException) {
                        // empty catch block
                    }
                    if (!((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.butSetABCSelect.isEnabled()) {
                        return;
                    }
                    if (arg0.getModifiers() == 16) {
                        if (((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.isClickDown) {
                            if (PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.SSP9 || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.KPS || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.NEP) {
                                ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.setValueAt(App.getIt().numberFormat.format(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetY), 0, ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index == ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.validPoint ? 1 : ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index + 1);
                                if (((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index > 0) {
                                    ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.setValueAt(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetX - (int)((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index - 1][0], ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index);
                                }
                            } else {
                                String pointNmae = ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index].substring(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index].length() - 1);
                                int i = 1;
                                while (i <= ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.validPoint) {
                                    if (pointNmae.equals(((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getColumnName(i))) {
                                        ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.setValueAt(App.getIt().numberFormat.format(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetY), 0, i);
                                        if (PanCanvas.this.mouseX > PanCanvas.this.box.x2 || ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index].length() != 1) break;
                                        if (((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index <= 2) {
                                            if (((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index == 0) {
                                                ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.setValueAt(func.getInt(((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getValueAt(((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, i).toString()) + ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetX, ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, i);
                                                break;
                                            }
                                            ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.setValueAt(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetX, ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, i);
                                            break;
                                        }
                                        ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.setValueAt(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetX - (int)((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point5_XY[2][0], ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableSetting.getRowCount() - 1, i);
                                        break;
                                    }
                                    ++i;
                                }
                                if (((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index].length() > 1) {
                                    i = 0;
                                    while (i < ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableTime.getColumnCount()) {
                                        if (((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index].equals(((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableTime.getColumnName(i))) {
                                            if (((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Click_Index <= 2) {
                                                ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableTime.setValueAt(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetX, 0, i);
                                                break;
                                            }
                                            ((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this.tableTime.setValueAt(((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.presetX - (int)((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.Point5_XY[2][0], 0, i);
                                            break;
                                        }
                                        ++i;
                                    }
                                }
                            }
                        }
                        ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.isClickDown = !((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.isClickDown;
                    } else if (arg0.getModifiers() == 4) {
                        ((PanWaveFormGenerator)((PanCanvas)PanCanvas.this).PanWaveFormGenerator.this).abc.isClickDown = false;
                    }
                    PanCanvas.this.repaint();
                }

                @Override
                public void mouseEntered(MouseEvent arg0) {
                }

                @Override
                public void mouseExited(MouseEvent arg0) {
                }

                @Override
                public void mousePressed(MouseEvent arg0) {
                }

                @Override
                public void mouseReleased(MouseEvent arg0) {
                }
            });
        }

        @Override
        public void paint(Graphics g) {
            g.setColor(Color.white);
            g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
            g.setColor(new Color(150, 150, 150));
            g.drawLine(0, 0, 0, this.getHeight() - 1);
            g.drawLine(0, 0, this.getWidth() - 1, 0);
            g.setColor(new Color(200, 200, 200));
            g.fillRect(1, 1, this.getWidth() - 2, this.getHeight() - 2);
            PanWaveFormGenerator.this.abc.refreABC();
            if (PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.SSP9 || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.KPS || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.NEP) {
                this.printSSP9_KPS(g, this.getWidth(), this.getHeight(), false);
            } else {
                this.print(g, this.getWidth(), this.getHeight(), false);
            }
        }

        int cx(int x) {
            int a = 0;
            if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal > 0) {
                a = Math.round((float)this.box.boxWidth * (float)x / (float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal);
            }
            return a + this.box.x1;
        }

        int cx(float x) {
            int a = 0;
            if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal > 0) {
                a = Math.round((float)this.box.boxWidth * x / (float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal);
            }
            return a + this.box.x1;
        }

        int cy(int y) {
            int a = 0;
            if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax > 0.0f) {
                a = Math.round((float)this.box.boxHeight * (float)y / ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax);
            }
            return this.box.y2 - a;
        }

        int cy(float y) {
            int a = 0;
            if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax > 0.0f) {
                a = Math.round((float)this.box.boxHeight * y / ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax);
            }
            return this.box.y2 - a;
        }

        int xc(int x) {
            return Math.round((float)(x - this.box.x1) * (float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal / (float)this.box.boxWidth);
        }

        float yc(int y) {
            float f = -((float)(y - this.box.y2)) * ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax / (float)this.box.boxHeight;
            f = (float)Math.round(f * 10.0f) / 10.0f;
            return f;
        }

        void MouseMove(Graphics g) {
            float[] a = new float[5];
            int x1 = 0;
            int y1 = 0;
            int r = 6;
            if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.isClickDown) {
                float c;
                if (this.mouseX > this.box.x2 + 10 && (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 2 || ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 4)) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Graphics2D g2 = (Graphics2D)g;
                    BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.0f, 2.0f}, 1.0f);
                    g2.setStroke(stroke);
                    g.setColor(Color.RED);
                    g.setColor(new Color(210, 100, 100));
                    int col = 1;
                    while (col < PanWaveFormGenerator.this.tableSetting.getColumnCount()) {
                        if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index].equals(PanWaveFormGenerator.this.tableSetting.getColumnName(col))) {
                            int row = PanWaveFormGenerator.this.tableSetting.getRowCount() - 1;
                            int s = func.getInt(PanWaveFormGenerator.this.tableSetting.getValueAt(row, col).toString());
                            if (s >= 1200) break;
                            PanWaveFormGenerator.this.tableSetting.setValueAt(s + 1, row, col);
                            break;
                        }
                        ++col;
                    }
                    g.drawLine(this.box.x2 + 10, 0, this.box.x2 + 10, this.getHeight());
                    g2.setStroke(new BasicStroke(1.0f));
                }
                g.setColor(new Color(210, 100, 100));
                g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][0]) - r / 2, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][1]) - r / 2, r, r);
                g.setColor(Color.RED);
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = this.xc(this.mouseX);
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 0) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = 0;
                } else if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 1 || ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 3) {
                    if (this.mouseX >= this.box.x2) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = Math.round(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index + 1][0]);
                    } else if ((float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX < ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = Math.round(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]);
                    } else if ((float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX > ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index + 1][0]) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = Math.round(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index + 1][0]);
                    }
                    if ((float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX - ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0] > 20.0f) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = (int)(20.0f + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]);
                    }
                } else if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 2 || ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 4) {
                    if (this.mouseX >= this.box.x2) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = Math.round(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][0]);
                    } else if ((float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX < ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = Math.round(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]);
                    }
                }
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY = this.yc(this.mouseY);
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY < 0.0f) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY = 0.0f;
                }
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt()) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt();
                }
                String point = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart;
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 1 || ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 2) {
                    point = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointEnd;
                }
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY * (c = func.getFloat(PanWaveFormGenerator.this.tableSetting.getValueAt(1, PanWaveFormGenerator.this.tableSetting.getColumn(point).getModelIndex()).toString())) > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower()) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getMaxPower() / c;
                }
                String str = "";
                str = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 0 ? String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index]) + " (0s, " + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY + "v)" : (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index].length() > 1 ? String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index]) + " (" + (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX - (int)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]) + "s, " + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY + "v)" : String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5Name[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index]) + " (" + (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX - (int)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 2][0]) + "s, " + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY + "v)");
                x1 = this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX);
                y1 = this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY);
                g.drawOval(x1 - r / 2, y1 - r / 2, r, r);
                g.drawString(str, x1 - g.getFontMetrics().stringWidth(str) / 2, y1 - 8);
            } else {
                g.setColor(Color.RED);
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index = 0;
                int i = 0;
                while (i <= 4) {
                    a[i] = Math.abs(this.mouseX - this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[i][0])) + Math.abs(this.mouseY - this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[i][1]));
                    if (a[i] <= a[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index]) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index = i;
                    }
                    ++i;
                }
                g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][0]) - r / 2, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][1]) - r / 2, r, r);
            }
        }

        void MouseMoveSSP9_KPS(Graphics g) {
            float[] a = new float[11];
            int x1 = 0;
            int y1 = 0;
            int r = 6;
            if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.isClickDown) {
                if (this.mouseX > this.box.x2 + 10 && ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index > 0) {
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    Graphics2D g2 = (Graphics2D)g;
                    BasicStroke stroke = new BasicStroke(1.0f, 1, 1, 1.0f, new float[]{1.0f, 2.0f}, 1.0f);
                    g2.setStroke(stroke);
                    g.setColor(Color.RED);
                    g.setColor(new Color(210, 100, 100));
                    int row = PanWaveFormGenerator.this.tableSetting.getRowCount() - 1;
                    int s = func.getInt(PanWaveFormGenerator.this.tableSetting.getValueAt(row, ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index).toString());
                    if (PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.KPS || PanWaveFormGenerator.this.pscs.getSerialCurr() == EnmSerial.NEP) {
                        if (s < 1200) {
                            PanWaveFormGenerator.this.tableSetting.setValueAt(s + 1, row, ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index);
                        }
                    } else if (s < 600) {
                        PanWaveFormGenerator.this.tableSetting.setValueAt(s + 1, row, ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index);
                    }
                    g.drawLine(this.box.x2 + 10, 0, this.box.x2 + 10, this.getHeight());
                    g2.setStroke(new BasicStroke(1.0f));
                }
                g.setColor(new Color(210, 100, 100));
                g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][0]) - r / 2, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][1]) - r / 2, r, r);
                g.setColor(Color.RED);
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = this.xc(this.mouseX);
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 0) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = 0;
                } else if ((float)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX < ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = Math.round(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]);
                } else if (this.mouseX >= this.box.x2) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX = Math.round(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint][0]);
                }
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY = this.yc(this.mouseY);
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY < 0.0f) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY = 0.0f;
                }
                if (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY > ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt()) {
                    ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY = ((PanWaveFormGenerator)PanWaveFormGenerator.this).pscs.getConnCurr().ps.getUwl().getVolt();
                }
                String str = "";
                str = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index == 0 ? String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.PointName[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index]) + " (0s, " + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY + "v)" : String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.PointName[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index]) + " (" + (((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX - (int)((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index - 1][0]) + "s, " + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY + "v)";
                x1 = this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetX);
                y1 = this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.presetY);
                g.drawOval(x1 - r / 2, y1 - r / 2, r, r);
                g.drawString(str, x1 - g.getFontMetrics().stringWidth(str) / 2, y1 - 8);
            } else {
                g.setColor(Color.RED);
                ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index = 0;
                int i = 0;
                while (i <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint) {
                    a[i] = Math.abs(this.mouseX - this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i][0])) + Math.abs(this.mouseY - this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i][1]));
                    if (a[i] <= a[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index]) {
                        ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index = i;
                    }
                    ++i;
                }
                g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][0]) - r / 2, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Click_Index][1]) - r / 2, r, r);
            }
        }

        public void print(Graphics g, int width, int height, boolean isPage) {
            Graphics2D g2 = (Graphics2D)g;
            this.box = new BOX(width, height, isPage);
            g.setColor(Color.GRAY);
            int i = 0;
            while (i <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal) {
                g.drawLine(this.cx(i), this.cy(0), this.cx(i), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax));
                ++i;
            }
            i = 0;
            while ((float)i <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax) {
                g.drawLine(this.cx(0), this.cy(i), this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal), this.cy(i));
                ++i;
            }
            g.drawRect(this.box.x1, this.box.y1, this.box.boxWidth, this.box.boxHeight);
            g.drawLine(this.box.x1, this.box.y2, this.box.x1, this.box.y1 - 20);
            g.drawLine(this.box.x1, this.box.y1 - 20, this.box.x1 + 3, this.box.y1 - 10);
            g.drawLine(this.box.x1 + 3, this.box.y1 - 10, this.box.x1, this.box.y1 - 10);
            g.drawLine(this.box.x1, this.box.y2, this.box.x2 + 20, this.box.y2);
            g.drawLine(this.box.x2 + 20, this.box.y2, this.box.x2 + 10, this.box.y2 - 3);
            g.drawLine(this.box.x2 + 10, this.box.y2 - 3, this.box.x2 + 10, this.box.y2);
            i = 0;
            while (i <= 4) {
                g.drawString(String.valueOf(PanWaveFormGenerator.this.df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[i][0])) + "S", this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[i][0]) - Math.round(g.getFontMetrics().stringWidth(String.valueOf(PanWaveFormGenerator.this.df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[i][0])) + "S") / 2), this.cy(0) + 18);
                ++i;
            }
            DecimalFormat df1 = new DecimalFormat("0.0");
            g.drawString(String.valueOf(df1.format(0L)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(0L)) + "V") - 10, this.box.y2 + 5);
            g.drawString(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueStart)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueStart)) + "V") - 10, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueStart) + 5);
            g.drawString(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueEnd)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueEnd)) + "V") - 10, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueEnd) + 5);
            g.drawString(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax)) + "V") - 10, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax) + 5);
            g.setColor(Color.BLACK);
            g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[0][0]) - 3, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[0][1]) - 3, 6, 6);
            g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][0]) - 3, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][1]) - 3, 6, 6);
            g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][0]) - 3, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][1]) - 3, 6, 6);
            g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][0]) - 3, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][1]) - 3, 6, 6);
            g.setColor(Color.GRAY);
            g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[4][0]) - 3, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[4][1]) - 3, 6, 6);
            g2.setStroke(new BasicStroke(2.0f));
            g.setColor(Color.BLACK);
            g.drawLine(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[0][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[0][1]), this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][1]));
            g.drawLine(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][1]), this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][1]));
            g.drawLine(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][1]), this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][1]));
            g.drawLine(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][1]), this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[4][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[4][1]));
            g.setFont(PanWaveFormGenerator.this.fontB);
            g.setColor(Color.BLACK);
            g.drawString(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart, this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[0][0]) - g.getFontMetrics().stringWidth("A") - 1, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[0][1]) - 5);
            g.drawString(String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart) + "-" + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointEnd, this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][0]) - g.getFontMetrics().stringWidth("A-A") / 2 + 13, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[1][1]) + 15);
            g.drawString(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointEnd, this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][0]) - g.getFontMetrics().stringWidth("A") - 1, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[2][1]) - 5);
            g.drawString(String.valueOf(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointEnd) + "-" + ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart, this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][0]) - g.getFontMetrics().stringWidth("A-A") / 2 + 13, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[3][1]) + 15);
            g.setColor(Color.GRAY);
            g.drawString(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.StrPointStart, this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[4][0]) + 2, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point5_XY[4][1]) - 5);
            g2.setStroke(new BasicStroke(1.0f));
            if (!isPage) {
                this.MouseMove(g);
            }
        }

        public void printSSP9_KPS(Graphics g, int width, int height, boolean isPage) {
            Graphics2D g2 = (Graphics2D)g;
            this.box = new BOX(width, height, isPage);
            g.setColor(Color.GRAY);
            int i = 0;
            while (i <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal) {
                g.drawLine(this.cx(i), this.cy(0), this.cx(i), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax));
                ++i;
            }
            i = 0;
            while ((float)i <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax) {
                g.drawLine(this.cx(0), this.cy(i), this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.xTotal), this.cy(i));
                ++i;
            }
            g.drawRect(this.box.x1, this.box.y1, this.box.boxWidth, this.box.boxHeight);
            g.drawLine(this.box.x1, this.box.y2, this.box.x1, this.box.y1 - 20);
            g.drawLine(this.box.x1, this.box.y1 - 20, this.box.x1 + 3, this.box.y1 - 10);
            g.drawLine(this.box.x1 + 3, this.box.y1 - 10, this.box.x1, this.box.y1 - 10);
            g.drawLine(this.box.x1, this.box.y2, this.box.x2 + 20, this.box.y2);
            g.drawLine(this.box.x2 + 20, this.box.y2, this.box.x2 + 10, this.box.y2 - 3);
            g.drawLine(this.box.x2 + 10, this.box.y2 - 3, this.box.x2 + 10, this.box.y2);
            i = 0;
            while (i <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint) {
                g.drawString(String.valueOf(PanWaveFormGenerator.this.df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i][0])) + "S", this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i][0]) - Math.round(g.getFontMetrics().stringWidth(String.valueOf(PanWaveFormGenerator.this.df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i][0])) + "S") / 2), this.cy(0) + 18);
                ++i;
            }
            DecimalFormat df1 = new DecimalFormat("0.0");
            g.drawString(String.valueOf(df1.format(0L)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(0L)) + "V") - 10, this.box.y2 + 5);
            g.drawString(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueStart)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueStart)) + "V") - 10, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueStart) + 5);
            g.drawString(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueEnd)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueEnd)) + "V") - 10, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueEnd) + 5);
            g.drawString(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax)) + "V", this.cx(0) - g.getFontMetrics().stringWidth(String.valueOf(df1.format(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax)) + "V") - 10, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.ValueBoxMax) + 5);
            int pointValid = func.getInt(PanWaveFormGenerator.this.cmbRunWfg.getSelectedItem().toString().substring(0, 2).trim()) - 1;
            int i2 = 0;
            while (i2 <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint) {
                g.setColor(i2 <= pointValid ? Color.BLACK : Color.GRAY);
                g.drawOval(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][0]) - 3, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][1]) - 3, 6, 6);
                ++i2;
            }
            g2.setStroke(new BasicStroke(2.0f));
            i2 = 0;
            while (i2 < ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint) {
                g.setColor(i2 <= pointValid ? Color.BLACK : Color.GRAY);
                g.drawLine(this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][1]), this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2 + 1][0]), this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2 + 1][1]));
                ++i2;
            }
            g.setFont(PanWaveFormGenerator.this.fontB);
            i2 = 0;
            while (i2 <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint) {
                String pn = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.PointName[i2];
                if (i2 <= ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.validPoint - 1) {
                    g.setColor(Color.BLACK);
                    int y = this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][1]) - 5;
                    if (i2 > 0) {
                        y = ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][1] < ((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2 - 1][1] ? this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][1]) + 15 : this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][1]) - 5;
                    }
                    g.drawString(pn, this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][0]) - g.getFontMetrics().stringWidth(pn) - 2, y);
                } else {
                    g.setColor(Color.GRAY);
                    g.drawString(pn, this.cx(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][0]) + 4, this.cy(((PanWaveFormGenerator)PanWaveFormGenerator.this).abc.Point_XY[i2][1]) - 5);
                }
                ++i2;
            }
            g2.setStroke(new BasicStroke(1.0f));
            if (!isPage) {
                this.MouseMoveSSP9_KPS(g);
            }
        }
    }
}

