/*
 * Decompiled with CFR 0.152.
 */
package pscs.test;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;

public class WakeOnLan {
    public static final int PORT = 9;

    public static void main(String[] args) {
        String ipStr = "192.168.0.255";
        String macStr = "B8:AC:6F:49:F8:8B";
        try {
            byte[] macBytes = WakeOnLan.getMacBytes(macStr);
            byte[] bytes = new byte[6 + 16 * macBytes.length];
            int i = 0;
            while (i < 6) {
                bytes[i] = -1;
                ++i;
            }
            i = 0;
            while (i < bytes.length) {
                System.out.print(" " + Integer.toHexString(bytes[i]));
                ++i;
            }
            System.out.println("\nbytes.length: " + bytes.length);
            i = 6;
            while (i < bytes.length) {
                System.arraycopy(macBytes, 0, bytes, i, macBytes.length);
                i += macBytes.length;
            }
            InetAddress address = InetAddress.getByName(ipStr);
            DatagramPacket packet = new DatagramPacket(bytes, bytes.length, address, 9);
            DatagramSocket socket = new DatagramSocket();
            socket.send(packet);
            socket.close();
            System.out.println("Wake-on-LAN packet sent.");
        }
        catch (Exception e) {
            System.out.println("Failed to send Wake-on-LAN packet: + e");
            System.exit(1);
        }
    }

    private static byte[] getMacBytes(String macStr) throws IllegalArgumentException {
        byte[] bytes = new byte[6];
        String[] hex = macStr.split("(\\:|\\-)");
        if (hex.length != 6) {
            throw new IllegalArgumentException("Invalid MAC address.");
        }
        try {
            int i = 0;
            while (i < 6) {
                bytes[i] = (byte)Integer.parseInt(hex[i], 16);
                ++i;
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid hex digit in MAC address.");
        }
        return bytes;
    }
}

