/*
 * Decompiled with CFR 0.152.
 */
package pscs.test;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.geom.RoundRectangle2D;
import javax.swing.JButton;
import javax.swing.JFrame;

public class RButton
extends JButton {
    private static final long serialVersionUID = 39082560987930759L;
    public static final Color BUTTON_FOREGROUND_COLOR = Color.WHITE;
    private boolean hover;

    public static void main(String[] aa) {
        JFrame f = new JFrame();
        f.setLayout(new FlowLayout());
        f.add(new JButton("JButton"));
        f.add(new RButton("RButton"));
        f.setBounds(200, 200, 400, 300);
        f.setVisible(true);
    }

    public RButton(String txt) {
        this();
        this.setText(txt);
    }

    public RButton() {
        this.setFont(new Font("system", 0, 12));
        this.setBorderPainted(false);
        this.setForeground(Color.BLACK);
        this.setFocusPainted(false);
        this.setContentAreaFilled(false);
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
                RButton.this.setForeground(Color.BLACK);
                RButton.this.hover = true;
                RButton.this.repaint();
            }

            @Override
            public void mousePressed(MouseEvent e) {
                RButton.this.setForeground(Color.WHITE);
                RButton.this.hover = true;
                RButton.this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                RButton.this.setForeground(Color.BLACK);
                RButton.this.hover = false;
                RButton.this.repaint();
            }

            @Override
            public void mouseEntered(MouseEvent e) {
                RButton.this.setForeground(Color.BLACK);
                RButton.this.hover = true;
                RButton.this.repaint();
            }

            @Override
            public void mouseClicked(MouseEvent e) {
            }
        });
    }

    @Override
    protected void paintComponent(Graphics g) {
        GradientPaint p2;
        GradientPaint p1;
        Graphics2D g2d = (Graphics2D)g.create();
        int h = this.getHeight();
        int w = this.getWidth();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        if (this.getModel().isPressed()) {
            p1 = new GradientPaint(0.0f, 0.0f, new Color(0, 0, 0), 0.0f, h - 1, new Color(100, 100, 100));
            p2 = new GradientPaint(0.0f, 1.0f, new Color(0, 0, 0, 50), 0.0f, h - 3, new Color(255, 255, 255, 100));
        } else {
            p1 = new GradientPaint(0.0f, 0.0f, new Color(100, 100, 100), 0.0f, h - 1, new Color(0, 0, 0));
            p2 = new GradientPaint(0.0f, 1.0f, new Color(255, 255, 255, 100), 0.0f, h - 3, new Color(0, 0, 0, 50));
        }
        g2d.setComposite(AlphaComposite.getInstance(3, this.hover ? 1.0f : 0.5f));
        RoundRectangle2D.Float r2d = new RoundRectangle2D.Float(0.0f, 0.0f, w - 1, h - 1, 20.0f, 20.0f);
        Shape clip = g2d.getClip();
        g2d.clip(r2d);
        g2d.setPaint(new GradientPaint(0.0f, 0.0f, new Color(200, 200, 200), 0.0f, h, new Color(100, 100, 100), true));
        g2d.fillRect(0, 0, w, h);
        g2d.setClip(clip);
        g2d.setPaint(p1);
        g2d.drawRoundRect(0, 0, w - 1, h - 1, 20, 20);
        g2d.setPaint(p2);
        g2d.drawRoundRect(1, 1, w - 3, h - 3, 18, 18);
        g2d.dispose();
        super.paintComponent(g);
    }
}

