/*
 * Decompiled with CFR 0.152.
 */
package pscs.powerSupply;

import java.util.Iterator;
import java.util.Vector;
import pscs.ModeEvent;
import pscs.ModeEventListener;
import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.enums.EnmSerial;
import pscs.func;

public class PowerSupply {
    private EnmSerial serial;
    private String model = "";
    private PairVC min = new PairVC();
    private PairVC max = new PairVC();
    private PairVC uwl = new PairVC();
    private PairVC setting = new PairVC();
    private PairVCS display = null;
    private float maxPower = 10000.0f;
    private int VoltFormatDisplay = 10;
    private int CurrFormatDisplay = 100;
    private int VoltFormatSetting = 10;
    private int CurrFormatSetting = 10;
    private int RunCycle = 0;
    private int RunWfgSelectedIndex = 0;
    private int RunWfgSelectedValue = 0;
    private int ABCSelected = 0;
    private int MemoryIndex = 0;
    private int Channel = 0;
    private boolean output = true;
    private boolean isSetOutput = false;
    private int machines = 1;
    private boolean isCalibration = false;
    private boolean factoryMode = false;
    private boolean isUpdateFirmwareMode = false;
    private Vector<ModeEventListener> list = new Vector();
    private Object[][] dataIPM;
    private Object[][] dataITP;
    private Object[][] dataETP;
    private Object[][] dataWfgSetting;

    public void addMyEventListener(ModeEventListener me) {
        this.list.add(me);
    }

    public void deleteMyEventListener(ModeEventListener me) {
        this.list.remove(me);
    }

    public void setMemoryIdx(int idx) {
        try {
            int r = 0;
            while (r < this.dataIPM.length) {
                this.dataIPM[r][0] = r == idx - 1;
                ++r;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public boolean isFactoryMode() {
        return this.factoryMode;
    }

    public void setFactoryMode(boolean bl) {
        boolean change = bl ^ this.factoryMode;
        this.factoryMode = bl;
        if (change) {
            this.notifyMyEvent(new ModeEvent(this, this.factoryMode));
        }
    }

    public void notifyMyEvent(ModeEvent me) {
        Iterator<ModeEventListener> it = this.list.iterator();
        while (it.hasNext()) {
            it.next().handleEvent(me);
        }
    }

    public boolean isUpdateFirmwareMode() {
        return this.isUpdateFirmwareMode;
    }

    public void setUpdateFirmwareMode(boolean isUpdateFirmwareMode) {
        this.isUpdateFirmwareMode = isUpdateFirmwareMode;
    }

    public int getABCSelected() {
        return this.ABCSelected;
    }

    public void setABCSelected(int aBCSelected) {
        this.ABCSelected = aBCSelected;
    }

    public EnmSerial getSerial() {
        return this.serial;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        if (model == null) {
            model = "";
        }
        this.model = model;
        String m = model.replace("-", "").toUpperCase();
        if (m.startsWith("HCS2")) {
            this.serial = EnmSerial.HCS2;
        } else if (m.startsWith("HCS3")) {
            this.serial = EnmSerial.HCS3;
        } else if (m.startsWith("KPS")) {
            this.serial = EnmSerial.KPS;
        } else if (m.startsWith("NEP")) {
            this.serial = EnmSerial.NEP;
        } else if (m.startsWith("NTP")) {
            this.serial = EnmSerial.NTP;
        } else if (m.startsWith("SDP2210O") || m.startsWith("SDP2405O") || m.startsWith("SDP2603O")) {
            this.serial = EnmSerial.SDP2old;
        } else if (m.startsWith("DPS2")) {
            this.serial = EnmSerial.SDP2new;
        } else if (m.startsWith("SDP3")) {
            this.serial = EnmSerial.SDP3;
        } else if (m.startsWith("SSP80")) {
            this.serial = EnmSerial.SSP8080;
        } else if (m.startsWith("SSP8")) {
            this.serial = EnmSerial.SSP8XXX;
        } else if (m.startsWith("SSP9")) {
            this.serial = EnmSerial.SSP9;
        }
        float minVolt = 0.0f;
        float minCurr = 0.0f;
        if (model.startsWith("HCS")) {
            minVolt = 1.0f;
        } else if (model.startsWith("KPS") || model.startsWith("NTP")) {
            minVolt = 0.8f;
        } else if (model.startsWith("NEP")) {
            minVolt = 0.1f;
            minCurr = 0.01f;
        } else if (model.startsWith("SDP")) {
            minVolt = 1.0f;
            minCurr = 0.01f;
        } else if (this.serial == EnmSerial.SSP9) {
            minVolt = 1.0f;
            minCurr = 0.25f;
        }
        this.min = new PairVC(minVolt, minCurr);
    }

    public PairVC getMax() {
        return this.max;
    }

    public void setMax(PairVC max) {
        func.getDecimalFormat(this.getVoltFormatSetting());
        this.max = max;
    }

    public PairVC getSetting() {
        return this.setting;
    }

    public void setSetting(PairVC vc) {
        if (vc == null) {
            return;
        }
        this.setting = vc;
        if (this.setting.getVolt() > this.uwl.getVolt()) {
            this.setting.setVolt(this.uwl.getVolt());
        }
        if (this.setting.getCurr() > this.uwl.getCurr()) {
            this.setting.setCurr(this.uwl.getCurr());
        }
        if (this.model != null && this.model.replace("-", "").toUpperCase().startsWith("SDP2")) {
            _FrmPSCS pscs = _FrmPSCS.getIt();
            try {
                if (pscs.getConnCurr().ps == this) {
                    pscs.refreshIPM_selectValue();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public PairVC getUwl() {
        return this.uwl;
    }

    public void setUwl(PairVC uwl) {
        this.uwl = uwl;
    }

    public float getMaxPower() {
        return this.maxPower;
    }

    public void setMaxPower(float constPower) {
        this.maxPower = constPower;
    }

    public boolean getOutput() {
        return this.output;
    }

    public void setOutput(boolean output) {
        this.output = output;
    }

    public int getCurrFormatDisplay() {
        return this.CurrFormatDisplay;
    }

    public void setCurrFormatDisplay(int currFormatDisplay) {
        this.CurrFormatDisplay = currFormatDisplay;
    }

    public int getVoltFormatDisplay() {
        return this.VoltFormatDisplay;
    }

    public void setVoltFormatDisplay(int voltFormatDisplay) {
        this.VoltFormatDisplay = voltFormatDisplay;
    }

    public int getVoltFormatSetting() {
        return this.VoltFormatSetting;
    }

    public String getVoltFormatSetting(float volt) {
        return null;
    }

    public void setVoltFormatSetting(int voltFormatSetting) {
        this.VoltFormatSetting = voltFormatSetting;
    }

    public int getCurrFormatSetting() {
        return this.CurrFormatSetting;
    }

    public void setCurrFormatSetting(int currFormatSetting) {
        this.CurrFormatSetting = currFormatSetting;
    }

    public int getChannel() {
        return this.Channel;
    }

    public void setChannel(int channel) {
        this.Channel = channel;
    }

    public PairVC getMin() {
        return this.min;
    }

    public void setMin(PairVC min) {
        this.min = min;
    }

    public String getStrFormat(float f) {
        return func.getDecimalFormat(this.getVoltFormatSetting()).format(f);
    }

    public int getMachines() {
        return this.machines;
    }

    public void setMachines(int machines) {
        this.machines = machines;
    }

    public boolean isCalibration() {
        return this.isCalibration;
    }

    public void setCalibration(boolean isCalibration) {
        this.isCalibration = isCalibration;
    }

    public boolean isSetOutput() {
        return this.isSetOutput;
    }

    public void setSetOutput(boolean isSetOutput) {
        this.isSetOutput = isSetOutput;
    }

    public Object[][] getDataIPM() {
        return this.dataIPM;
    }

    public void setDataIPM(Object[][] arr) {
        this.dataIPM = arr;
    }

    public Object[][] getDataITP() {
        return this.dataITP;
    }

    public void setDataITP(Object[][] dataITP) {
        this.dataITP = dataITP;
    }

    public Object[][] getDataETP() {
        return this.dataETP;
    }

    public void setDataETP(Object[][] dataETP) {
        this.dataETP = dataETP;
    }

    public PairVCS getDisplay() {
        return this.display;
    }

    public void setDisplay(PairVCS display) {
        this.display = display;
    }

    public Object[][] getDataWfgSetting() {
        return this.dataWfgSetting;
    }

    public void setDataWfgSetting(Object[][] dataWfgSetting) {
        this.dataWfgSetting = dataWfgSetting;
    }

    public int getMemoryIndex() {
        return this.MemoryIndex;
    }

    public void setMemoryIndex(int memoryIndex) {
        this.MemoryIndex = memoryIndex;
    }

    public int getRunCycle() {
        return this.RunCycle;
    }

    public void setRunCycle(int runCycle) {
        this.RunCycle = runCycle;
    }

    public int getRunWfgSelectedIndex() {
        return this.RunWfgSelectedIndex;
    }

    public void setRunWfgSelectedIndex(int runWfgSelectedIndex) {
        if (runWfgSelectedIndex < 0) {
            return;
        }
        this.RunWfgSelectedIndex = runWfgSelectedIndex;
        if (this.RunWfgSelectedValue != this.RunWfgSelectedIndex + 2) {
            this.RunWfgSelectedValue = this.RunWfgSelectedIndex + 2;
        }
    }

    public int getRunWfgSelectedValue() {
        return this.RunWfgSelectedValue;
    }

    public void setRunWfgSelectedValue(int runWfgSelectedValue) {
        this.RunWfgSelectedValue = runWfgSelectedValue;
        if (this.RunWfgSelectedIndex != this.RunWfgSelectedValue - 2) {
            this.RunWfgSelectedIndex = this.RunWfgSelectedValue - 2;
        }
    }
}

