/*
 * Decompiled with CFR 0.152.
 */
package pscs.multiple;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import pscs._FrmPSCS;
import pscs.connect.Connect;
import pscs.func;
import pscs.multiple.PanCard;

public class PanMultiple
extends JPanel {
    private static final long serialVersionUID = 1L;
    public JPanel panCards = new JPanel(new FlowLayout(0));
    JScrollPane panScroll = new JScrollPane(this.panCards);
    private int indexFocus = 0;

    public PanMultiple() {
        this.setLayout(new BorderLayout());
        this.panScroll.setHorizontalScrollBarPolicy(31);
        this.panScroll.setVerticalScrollBarPolicy(20);
        this.add(this.panScroll);
        this.setFocusable(true);
        this.listener();
        this.refreshCardAndScroll();
    }

    private void listener() {
        this.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent e) {
            }

            @Override
            public void componentResized(ComponentEvent e) {
                PanMultiple.this.refreshCardAndScroll();
            }

            @Override
            public void componentMoved(ComponentEvent e) {
            }

            @Override
            public void componentHidden(ComponentEvent e) {
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PanMultiple.this.requestFocus();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                PanMultiple.this.requestFocus();
            }
        });
        this.panCards.addComponentListener(new ComponentListener(){

            @Override
            public void componentShown(ComponentEvent arg0) {
            }

            @Override
            public void componentResized(ComponentEvent arg0) {
            }

            @Override
            public void componentMoved(ComponentEvent arg0) {
            }

            @Override
            public void componentHidden(ComponentEvent arg0) {
            }
        });
    }

    public void refreshCptsCards() {
        this.panCards.removeAll();
        int i = 0;
        while (i < _FrmPSCS.getIt().cmbConn.getItemCount()) {
            PanCard card = new PanCard((Connect)_FrmPSCS.getIt().cmbConn.getItemAt(i));
            card.refreshLabInfo();
            this.panCards.add(card);
            ++i;
        }
        this.refreshCardAndScroll();
    }

    public void refreshCardAndScroll() {
        int cardCols = (this.panScroll.getWidth() - 10) / 300;
        if (cardCols == 0) {
            this.panCards.setPreferredSize(new Dimension(this.panScroll.getWidth() - 20, 100));
            return;
        }
        int cardRows = this.getConnCount() / cardCols;
        if (this.getConnCount() % cardCols > 0) {
            ++cardRows;
        }
        int panCardsHeight = cardRows * 182 - 5;
        this.panCards.setPreferredSize(new Dimension(this.panScroll.getWidth() - 20, this.getConnCount() == 0 ? 100 : panCardsHeight));
        this.panCards.repaint();
        this.panCards.revalidate();
        this.panScroll.repaint();
        this.panScroll.revalidate();
    }

    public void refreshCptsLabInfo() {
        int i = 0;
        while (i < this.getConnCount()) {
            ((PanCard)this.panCards.getComponent(i)).refreshLabInfo();
            ++i;
        }
    }

    public void refreshCptsLabInfo(Connect conn) {
        int i = 0;
        while (i < this.getConnCount()) {
            if (((PanCard)this.panCards.getComponent(i)).getConn() == conn) {
                ((PanCard)this.panCards.getComponent(i)).refreshLabInfo();
                break;
            }
            ++i;
        }
    }

    public int getIndexFocus() {
        return this.indexFocus;
    }

    public void setIndexFocus(int idx) {
        this.indexFocus = idx;
        if (this.indexFocus >= 0 && this.indexFocus < this.getConnCount()) {
            _FrmPSCS.getIt().lmEdit.setEnabled(true);
            _FrmPSCS.getIt().lmDel.setEnabled(true);
            _FrmPSCS.getIt().setTitle(this.getConnOfIndexFocus());
            _FrmPSCS.getIt().setCptsUwL_Statusbar(this.getConnOfIndexFocus());
            try {
                this.panCards.getComponent(this.indexFocus).requestFocus();
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
        } else {
            _FrmPSCS.getIt().lmEdit.setEnabled(false);
            _FrmPSCS.getIt().lmDel.setEnabled(false);
            _FrmPSCS.getIt().setTitle(func.getTitle(null));
            _FrmPSCS.getIt().setCptsUwL_Statusbar(null);
        }
    }

    public Connect getConnOfIndexFocus() {
        if (this.indexFocus >= 0 && this.indexFocus < this.getConnCount()) {
            return ((PanCard)this.panCards.getComponent(this.indexFocus)).getConn();
        }
        return null;
    }

    public int getConnCount() {
        return this.panCards.getComponentCount();
    }

    @Override
    public void requestFocus() {
        try {
            if (this.indexFocus >= 0 && this.indexFocus < this.getConnCount()) {
                this.panCards.getComponent(this.indexFocus).requestFocus();
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }
}

