/*
 * Decompiled with CFR 0.152.
 */
package pscs.multiple;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import pscs._FrmPSCS;
import pscs.connect.Connect;
import pscs.enums.EnmSerial;
import pscs.func;
import pscs.multiple.MyLineBorder;

public class PanCard
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JLabel labRating = new JLabel(" ");
    private JLabel labConnName = new JLabel(" ");
    private JLabel labConnDesc = new JLabel(" ");
    private JLabel labUwL = new JLabel();
    private Connect conn;

    public PanCard(Connect conn) {
        this.conn = conn;
        this.setLayout(new BorderLayout());
        JPanel panUp = new JPanel(new BorderLayout());
        JPanel panDn = new JPanel(new BorderLayout());
        panUp.setOpaque(false);
        panDn.setOpaque(false);
        panUp.add((Component)this.labRating, "West");
        panUp.add(this.labConnName);
        panDn.add(this.labConnDesc);
        panDn.add((Component)this.labUwL, "East");
        this.add((Component)panUp, "North");
        this.add(conn.lcd);
        this.add((Component)panDn, "South");
        this.setBorder(BorderFactory.createTitledBorder(""));
        this.setFocusable(true);
        this.listener();
    }

    private void listener() {
        this.labConnName.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PanCard.this.requestFocus();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    _FrmPSCS.getIt()._showWindowsMultiple(false);
                }
            }
        });
        this.labConnDesc.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PanCard.this.requestFocus();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    _FrmPSCS.getIt()._showWindowsMultiple(false);
                }
            }
        });
        this.conn.lcd.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PanCard.this.requestFocus();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    _FrmPSCS.getIt()._showWindowsMultiple(false);
                }
            }
        });
        this.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
                PanCard.this.requestFocus();
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 2) {
                    _FrmPSCS.getIt()._showWindowsMultiple(false);
                }
            }
        });
        this.addFocusListener(new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                PanCard.this.setBorder(new MyLineBorder());
                int i = 0;
                while (i < _FrmPSCS.getIt().panMultiple.panCards.getComponentCount()) {
                    if (((PanCard)_FrmPSCS.getIt().panMultiple.panCards.getComponent(i)).getConn() == PanCard.this.conn) {
                        _FrmPSCS.getIt().panMultiple.setIndexFocus(i);
                        break;
                    }
                    ++i;
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
                PanCard.this.setBorder(BorderFactory.createTitledBorder(""));
            }
        });
    }

    public void refreshLabInfo() {
        boolean isNTP;
        this.labRating.setText(this.conn == null ? "" : func.getTitle(this.conn.ps.getModel()));
        this.labConnName.setText(this.conn.getConnInfo().getName());
        this.labConnName.setHorizontalAlignment(4);
        this.labConnDesc.setText(this.conn.getConnInfo().getDescription());
        this.labUwL.setText(this.conn.ps == null || this.conn.ps.getUwl() == null ? "  UVL:0V  UCL:0A" : this.conn.ps.getUwl().toDesc());
        boolean isSDP2 = this.conn.getConnInfo().getSerial() != null && this.conn.getConnInfo().getModel().startsWith("SDP2");
        boolean bl = isNTP = this.conn.getConnInfo().getSerial() != null && this.conn.getConnInfo().getSerial() == EnmSerial.NTP;
        if (isSDP2 || isNTP) {
            this.labUwL.setText(this.conn.ps == null || this.conn.ps.getUwl() == null ? "  UVL:0V  UCL:0A" : this.conn.ps.getUwl().toDescV());
        } else {
            this.labUwL.setText(this.conn.ps == null || this.conn.ps.getUwl() == null ? "  UVL:0V  UCL:0A" : this.conn.ps.getUwl().toDesc());
        }
    }

    public Connect getConn() {
        return this.conn;
    }

    public void setConn(Connect conn) {
        this.conn = conn;
    }

    public void refreshUwl() {
        this.labUwL.setText(this.conn.ps == null || this.conn.ps.getUwl() == null ? "  UVL:0V  UCL:0A" : this.conn.ps.getUwl().toDesc());
    }
}

