/*
 * Decompiled with CFR 0.152.
 */
package pscs.multiple;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import pscs._FrmPSCS;
import pscs.bean.BeanConnectInfo;
import pscs.connect.Connect;
import pscs.connect.editConnectName.PanConnectTableEdit;
import pscs.enums.EnmBeanConnectType;
import pscs.func;
import pscs.publics.ComboBox_String;
import pscs.rw;

public class DlogConnectEdit
extends JDialog
implements ActionListener,
DocumentListener {
    private static final long serialVersionUID = 1L;
    _FrmPSCS pscs = _FrmPSCS.getIt();
    JComboBox<EnmBeanConnectType> cmbConnectType;
    ComboBox_String cmbCommPort;
    JTextField txtName;
    JTextField txtDesc;
    JTextField txtRemoteIP;
    JTextField txtRemotePort;
    JTextField txtRS485;
    JButton butSave;
    JButton butCancel;
    Connect conn;
    BeanConnectInfo oldCi;
    PanConnectTableEdit panConnectTableEdit;

    public DlogConnectEdit(Connect conn) {
        EnmBeanConnectType[] enmBeanConnectTypeArray = new EnmBeanConnectType[4];
        enmBeanConnectTypeArray[1] = EnmBeanConnectType.USB;
        enmBeanConnectTypeArray[2] = EnmBeanConnectType.Ethernet;
        enmBeanConnectTypeArray[3] = EnmBeanConnectType.RS485;
        this.cmbConnectType = new JComboBox<EnmBeanConnectType>(enmBeanConnectTypeArray);
        this.cmbCommPort = new ComboBox_String(func.getCommPorts());
        this.butSave = new JButton(this.pscs.lang.getString("Lang_Save"));
        this.butCancel = new JButton(this.pscs.lang.getString("Lang_Cancel"));
        this.conn = null;
        this.oldCi = null;
        this.panConnectTableEdit = null;
        this.conn = conn;
        this.oldCi = conn == null ? null : conn.getConnInfo();
        this.initUI();
        this.listener();
    }

    public DlogConnectEdit(Connect conn, PanConnectTableEdit panConnectTableEdit) {
        EnmBeanConnectType[] enmBeanConnectTypeArray = new EnmBeanConnectType[4];
        enmBeanConnectTypeArray[1] = EnmBeanConnectType.USB;
        enmBeanConnectTypeArray[2] = EnmBeanConnectType.Ethernet;
        enmBeanConnectTypeArray[3] = EnmBeanConnectType.RS485;
        this.cmbConnectType = new JComboBox<EnmBeanConnectType>(enmBeanConnectTypeArray);
        this.cmbCommPort = new ComboBox_String(func.getCommPorts());
        this.butSave = new JButton(this.pscs.lang.getString("Lang_Save"));
        this.butCancel = new JButton(this.pscs.lang.getString("Lang_Cancel"));
        this.conn = null;
        this.oldCi = null;
        this.panConnectTableEdit = null;
        this.panConnectTableEdit = panConnectTableEdit;
        this.conn = conn;
        this.oldCi = conn == null ? null : conn.getConnInfo();
        this.initUI();
        this.listener();
    }

    private void initUI() {
        this.setTitle(this.conn == null ? this.pscs.lang.getString("Lang_Connect_Add") : this.pscs.lang.getString("Lang_Connect_Edit"));
        this.setLayout(new BorderLayout());
        JPanel panCenter = new JPanel();
        JPanel panConn = new JPanel(new GridLayout(7, 2));
        if (this.conn == null) {
            this.cmbConnectType.setSelectedIndex(0);
            this.cmbCommPort.setSelectedIndex(0);
        } else {
            this.cmbConnectType.setSelectedItem((Object)this.conn.getConnInfo().getBeanConnectType());
            this.cmbCommPort.setSelectedItem(this.conn.getConnInfo().getCommPort());
        }
        this.txtName = new JTextField(this.conn == null ? "" : this.conn.getConnInfo().getName());
        this.txtDesc = new JTextField(this.conn == null ? "" : (this.conn.getConnInfo().getDescription() == null || this.conn.getConnInfo().getDescription().equals("null") ? "" : this.conn.getConnInfo().getDescription()));
        this.txtRemoteIP = new JTextField(this.conn == null ? "" : (this.conn.getConnInfo().getRemoteIp() == null || this.conn.getConnInfo().getRemoteIp().equals("null") ? "" : this.conn.getConnInfo().getRemoteIp()));
        this.txtRemotePort = new JTextField(this.conn == null ? "" : (this.conn.getConnInfo().getRemotePort() == 0 ? "" : this.conn.getConnInfo().getRemotePort().toString()));
        this.txtRS485 = new JTextField(this.conn == null ? "" : (this.conn.getConnInfo().getRs485id() == 0 ? "" : String.valueOf(this.conn.getConnInfo().getRs485id())));
        panConn.add(new JLabel(String.valueOf(this.pscs.lang.getString("Lang_Connect_Name")) + ": "));
        panConn.add(this.txtName);
        panConn.add(new JLabel(String.valueOf(this.pscs.lang.getString("Lang_Description")) + ": "));
        panConn.add(this.txtDesc);
        panConn.add(new JLabel(String.valueOf(this.pscs.lang.getString("Lang_Connect_Type")) + ": "));
        panConn.add(this.cmbConnectType);
        panConn.add(new JLabel(String.valueOf(this.pscs.lang.getString("Lang_Connect_Remote_IP")) + ": "));
        panConn.add(this.txtRemoteIP);
        panConn.add(new JLabel(String.valueOf(this.pscs.lang.getString("Lang_Connect_Remote_Port")) + ": "));
        panConn.add(this.txtRemotePort);
        panConn.add(new JLabel(String.valueOf(this.pscs.lang.getString("Lang_Connect_COMM_Port")) + ": "));
        panConn.add(this.cmbCommPort);
        panConn.add(new JLabel(String.valueOf(this.pscs.lang.getString("Lang_Connect_RS485ID")) + ": "));
        panConn.add(this.txtRS485);
        JPanel panBut = new JPanel();
        panBut.add(this.butSave);
        panBut.add(this.butCancel);
        panCenter.add(panConn);
        this.add(panCenter);
        this.add((Component)panBut, "South");
        this.setBounds(100, 100, 400, 300);
        this.setLocationRelativeTo(this.getOwner());
        this.setAlwaysOnTop(true);
        this.setVisible(true);
        this.setCptsEnabled();
    }

    private void listener() {
        this.txtName.getDocument().addDocumentListener(this);
        this.txtRemoteIP.getDocument().addDocumentListener(this);
        this.txtRemotePort.getDocument().addDocumentListener(this);
        this.txtRS485.getDocument().addDocumentListener(this);
        this.cmbConnectType.addActionListener(this);
        this.cmbCommPort.addActionListener(this);
        this.butSave.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.addWindowFocusListener(new WindowFocusListener(){

            @Override
            public void windowLostFocus(WindowEvent e) {
                if (DlogConnectEdit.this.isVisible()) {
                    DlogConnectEdit.this.requestFocus();
                }
            }

            @Override
            public void windowGainedFocus(WindowEvent e) {
            }
        });
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
        this.pscs.setEnabled(!bl);
        if (this.pscs.isVisible()) {
            this.pscs.requestFocus();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.cmbConnectType) {
            this.setCptsEnabled();
        } else if (e.getSource() == this.cmbCommPort) {
            this.setCptsEnabled();
        } else if (e.getSource() == this.butSave) {
            BeanConnectInfo ci = new BeanConnectInfo();
            ci.setName(this.txtName.getText().trim());
            ci.setDescription(this.txtDesc.getText().trim());
            ci.setBeanConnectType((EnmBeanConnectType)((Object)this.cmbConnectType.getSelectedItem()));
            ci.setRemoteIp(this.txtRemoteIP.getText());
            ci.setRemotePort(func.getInt(this.txtRemotePort.getText()));
            ci.setCommPort((String)this.cmbCommPort.getSelectedItem());
            ci.setRs485id(func.getInt(this.txtRS485.getText()));
            String connName = this.getSameConnInfoName(ci);
            if (connName != null) {
                JOptionPane.showMessageDialog(this, String.valueOf(this.pscs.lang.getString("Lang_Interface_already_used_for")) + " \"" + connName + "\"", this.pscs.lang.getString("Lang_Operation_failed"), 0);
                return;
            }
            if (this.conn == null) {
                this.conn = new Connect(ci, true);
                this.pscs.cmbConn.addItem(this.conn);
                if (_FrmPSCS.bootSingleWindows.booleanValue()) {
                    this.panConnectTableEdit.addNewRow(this.conn);
                } else {
                    this.pscs.panMultiple.refreshCptsCards();
                    this.pscs.panMultiple.setIndexFocus(this.pscs.panMultiple.panCards.getComponentCount() - 1);
                }
            } else {
                this.conn.close();
                boolean isNewConn = this.conn.getConnInfo().setConnectNew(ci);
                if (this.conn.getConnInfo().getBeanConnectType() == EnmBeanConnectType.USB) {
                    this.conn.reSetCommPort();
                }
                if (isNewConn) {
                    this.conn.setConnectOK(false);
                }
                if (_FrmPSCS.bootSingleWindows.booleanValue()) {
                    this.panConnectTableEdit.refreshCurrRow(this.conn);
                } else {
                    this.pscs.panMultiple.refreshCptsLabInfo(this.conn);
                }
            }
            this.pscs.setListCommRs485Channel_RemoveConnect(this.conn);
            this.pscs.setListCommRs485Channel_Updata(this.conn);
            this.pscs.setEnabled(true);
            this.setVisible(false);
            if (!_FrmPSCS.bootSingleWindows.booleanValue()) {
                this.pscs.panMultiple.requestFocus();
            }
            rw.saveCmbConnToTxt();
            this.conn.reStart();
        } else if (e.getSource() == this.butCancel) {
            this.pscs.setEnabled(true);
            this.setVisible(false);
            if (!_FrmPSCS.bootSingleWindows.booleanValue()) {
                this.pscs.panMultiple.requestFocus();
            }
        }
    }

    private String getSameConnInfoName(BeanConnectInfo ci) {
        int i = 0;
        while (i < this.pscs.cmbConn.getItemCount()) {
            BeanConnectInfo idxi = ((Connect)this.pscs.cmbConn.getItemAt(i)).getConnInfo();
            if (ci.getName().equals(idxi.getName())) {
                System.out.println(1111);
                if (ci.getName().equals(idxi.getName())) {
                    System.out.println(2222);
                    if (this.oldCi == null || this.oldCi != null && this.oldCi.hashCode() != idxi.hashCode()) {
                        return idxi.getName();
                    }
                }
            }
            if (ci.getBeanConnectType() == EnmBeanConnectType.Ethernet && idxi.getBeanConnectType() == EnmBeanConnectType.Ethernet ? ci.getRemoteIp().equals(idxi.getRemoteIp()) && ci.getRemotePort().equals(idxi.getRemotePort()) && (this.oldCi == null || this.oldCi != null && this.oldCi.hashCode() != idxi.hashCode()) : (ci.getBeanConnectType() == EnmBeanConnectType.USB && idxi.getBeanConnectType() == EnmBeanConnectType.USB ? ci.getCommPort().equals(idxi.getCommPort()) && (this.oldCi == null || this.oldCi != null && this.oldCi.hashCode() != idxi.hashCode()) : (ci.getBeanConnectType() == EnmBeanConnectType.RS485 && idxi.getBeanConnectType() == EnmBeanConnectType.RS485 ? ci.getCommPort().equals(idxi.getCommPort()) && ci.getRs485id() == idxi.getRs485id() && (this.oldCi == null || this.oldCi != null && this.oldCi.hashCode() != idxi.hashCode()) : (ci.getBeanConnectType() == EnmBeanConnectType.USB && idxi.getBeanConnectType() == EnmBeanConnectType.RS485 || ci.getBeanConnectType() == EnmBeanConnectType.RS485 && idxi.getBeanConnectType() == EnmBeanConnectType.USB) && ci.getCommPort().equals(idxi.getCommPort()) && (this.oldCi == null || this.oldCi != null && this.oldCi.hashCode() != idxi.hashCode())))) {
                return idxi.getName();
            }
            ++i;
        }
        return null;
    }

    private void setCptsEnabled() {
        if (this.cmbConnectType.getSelectedItem() == null) {
            this.txtRemoteIP.setEnabled(false);
            this.txtRemotePort.setEnabled(false);
            this.cmbCommPort.setEnabled(false);
            this.txtRS485.setEnabled(false);
        } else if (this.cmbConnectType.getSelectedItem() == EnmBeanConnectType.USB) {
            this.txtRemoteIP.setEnabled(false);
            this.txtRemotePort.setEnabled(false);
            this.cmbCommPort.setEnabled(true);
            this.txtRS485.setEnabled(false);
        } else if (this.cmbConnectType.getSelectedItem() == EnmBeanConnectType.Ethernet) {
            this.txtRemoteIP.setEnabled(true);
            this.txtRemotePort.setEnabled(true);
            this.cmbCommPort.setEnabled(false);
            this.txtRS485.setEnabled(false);
        } else if (this.cmbConnectType.getSelectedItem() == EnmBeanConnectType.RS485) {
            this.txtRemoteIP.setEnabled(false);
            this.txtRemotePort.setEnabled(false);
            this.cmbCommPort.setEnabled(true);
            this.txtRS485.setEnabled(true);
        }
        if (this.txtName.getText().trim().length() == 0 || this.cmbConnectType.getSelectedIndex() <= 0) {
            this.butSave.setEnabled(false);
        }
        if (this.cmbConnectType.getSelectedItem() == EnmBeanConnectType.USB) {
            this.butSave.setEnabled(this.cmbCommPort.getSelectedIndex() > 0);
        } else if (this.cmbConnectType.getSelectedItem() == EnmBeanConnectType.Ethernet) {
            this.butSave.setEnabled(this.txtRemoteIP.getText().trim().length() > 0 && func.getInt(this.txtRemotePort.getText()) > 0);
        } else if (this.cmbConnectType.getSelectedItem() == EnmBeanConnectType.RS485) {
            this.butSave.setEnabled(this.cmbCommPort.getSelectedIndex() > 0 && func.getInt(this.txtRS485.getText()) > 0);
        }
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.setCptsEnabled();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.setCptsEnabled();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.setCptsEnabled();
    }
}

