/*
 * Decompiled with CFR 0.152.
 */
package pscs.ethernet;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import pscs.MyButton;
import pscs.ethernet.BeanTerminal;
import pscs.func;
import pscs.publics.ComboBox_String;

public class FrmEthernetSetting
extends JFrame {
    private static final long serialVersionUID = 1L;
    private ComboBox_String cmbEthernet = null;
    private JTextField txtID = new JTextField(9);
    private JTextField txtDescription = new JTextField(9);
    private JTextField txtRemoteIP = new JTextField(9);
    private JTextField txtRemotePort = new JTextField(9);
    private MyButton butDelete = new MyButton("Delete");
    private MyButton butUpdate = new MyButton("Update");
    private MyButton butCreate = new MyButton("Create");
    private JTable table = new JTable(new DefaultTableModel(new Object[][]{{1, "ITD-Test", "192.168.1.178", 4001}, {2}}, new String[]{"ID", "Description", "Remote IP", "Remote Port"})){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    private BeanTerminal benTerminal = null;

    public FrmEthernetSetting(ComboBox_String cmbEthernet) {
        this.cmbEthernet = cmbEthernet;
        this.initUI();
    }

    void initUI() {
        JPanel panEdit = new JPanel();
        JPanel panID = new JPanel(new FlowLayout(3, 3, 0));
        JPanel panDescription = new JPanel(new FlowLayout(3, 3, 0));
        JPanel panRemoteIP = new JPanel(new FlowLayout(3, 3, 0));
        JPanel panRemoteOprt = new JPanel(new FlowLayout(3, 3, 0));
        JPanel panRemoteButs = new JPanel(new FlowLayout(3, 10, 20));
        JLabel labID = new JLabel("ID:");
        JLabel labDescription = new JLabel("Description:");
        JLabel labRemoteIP = new JLabel("Remote IP:");
        JLabel labRemotePort = new JLabel("Remote Port:");
        Dimension dim = new Dimension(80, 20);
        super.setTitle("Ethernet setting");
        this.setBounds(100, 100, 580, 240);
        this.setLocationRelativeTo(this.getOwner());
        panEdit.setPreferredSize(new Dimension(200, 200));
        this.table.setAutoResizeMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setSelectionMode(0);
        this.table.getColumn(this.table.getColumnName(0)).setPreferredWidth(50);
        this.table.getColumn(this.table.getColumnName(1)).setPreferredWidth(100);
        this.table.getColumn(this.table.getColumnName(2)).setPreferredWidth(100);
        this.table.getColumn(this.table.getColumnName(3)).setPreferredWidth(90);
        labID.setHorizontalAlignment(4);
        labDescription.setHorizontalAlignment(4);
        labRemoteIP.setHorizontalAlignment(4);
        labRemotePort.setHorizontalAlignment(4);
        labID.setPreferredSize(dim);
        labDescription.setPreferredSize(dim);
        labRemoteIP.setPreferredSize(dim);
        labRemotePort.setPreferredSize(dim);
        this.txtID.setEditable(false);
        this.butDelete.setEnabled(false);
        this.butUpdate.setEnabled(false);
        this.butCreate.setEnabled(false);
        panID.add(labID);
        panID.add(this.txtID);
        panDescription.add(labDescription);
        panDescription.add(this.txtDescription);
        panRemoteIP.add(labRemoteIP);
        panRemoteIP.add(this.txtRemoteIP);
        panRemoteOprt.add(labRemotePort);
        panRemoteOprt.add(this.txtRemotePort);
        panRemoteButs.add(this.butDelete);
        panRemoteButs.add(this.butUpdate);
        panRemoteButs.add(this.butCreate);
        panEdit.add(panID);
        panEdit.add(panDescription);
        panEdit.add(panRemoteIP);
        panEdit.add(panRemoteOprt);
        panEdit.add(panRemoteButs);
        this.add(new JScrollPane(this.table));
        this.add((Component)panEdit, "East");
        this.listener();
    }

    void listener() {
        this.addWindowListener(new WindowListener(){

            @Override
            public void windowOpened(WindowEvent arg0) {
            }

            @Override
            public void windowIconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeiconified(WindowEvent arg0) {
            }

            @Override
            public void windowDeactivated(WindowEvent arg0) {
            }

            @Override
            public void windowClosing(WindowEvent arg0) {
                FrmEthernetSetting.this.cmbEthernet.removeAllItems();
            }

            @Override
            public void windowClosed(WindowEvent arg0) {
            }

            @Override
            public void windowActivated(WindowEvent arg0) {
            }
        });
        this.table.getColumn(this.table.getColumnName(0)).setCellRenderer(new MyCelRenderer());
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                BeanTerminal bt = FrmEthernetSetting.this.tableRowToObject();
                FrmEthernetSetting.this.ObjectToText(bt);
                FrmEthernetSetting.this.benTerminal = bt;
                FrmEthernetSetting.this.refreshButtonEnable();
            }
        });
        this.txtDescription.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FrmEthernetSetting.this.refreshButtonEnable();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.txtRemoteIP.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FrmEthernetSetting.this.refreshButtonEnable();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
        this.txtRemotePort.addKeyListener(new KeyListener(){

            @Override
            public void keyTyped(KeyEvent e) {
            }

            @Override
            public void keyReleased(KeyEvent e) {
                FrmEthernetSetting.this.refreshButtonEnable();
            }

            @Override
            public void keyPressed(KeyEvent e) {
            }
        });
    }

    private void ObjectToText(BeanTerminal bt) {
        this.txtID.setText("" + bt.getId());
        this.txtDescription.setText(bt.getDescription());
        this.txtRemoteIP.setText(bt.getRemoteIP());
        this.txtRemotePort.setText("" + bt.getRemotePort());
    }

    private BeanTerminal tableRowToObject() {
        int row = this.table.getSelectedRow();
        int id = func.getInt(this.table.getValueAt(row, 0).toString());
        String desc = this.table.getValueAt(row, 1).toString();
        String ip = this.table.getValueAt(row, 2).toString();
        int port = func.getInt(this.table.getValueAt(row, 3).toString());
        return new BeanTerminal(id, desc, ip, port);
    }

    private BeanTerminal TextToObject() {
        int id = func.getInt(this.txtID.getText().trim());
        String desc = this.txtDescription.getText().trim();
        String ip = this.txtRemoteIP.getText().trim();
        int port = func.getInt(this.txtRemotePort.getText().trim());
        return new BeanTerminal(id, desc, ip, port);
    }

    private void refreshButtonEnable() {
        boolean blID = this.txtID.getText() != null && this.txtID.getText().trim().length() > 0;
        boolean blDesc = this.txtDescription.getText() != null && this.txtDescription.getText().trim().length() > 0;
        boolean blIP = this.txtRemoteIP.getText() != null && this.txtRemoteIP.getText().trim().length() > 0;
        boolean blPort = this.txtRemotePort.getText() != null && this.txtRemotePort.getText().trim().length() > 0;
        boolean all = blDesc && blIP && blPort;
        BeanTerminal bt = this.TextToObject();
        this.butDelete.setEnabled(blID);
        this.butCreate.setEnabled(all && (this.benTerminal == null || this.benTerminal.getDescription() != bt.getDescription()));
        this.butUpdate.setEnabled(blID && all && this.benTerminal != null && (this.benTerminal.getDescription() != bt.getDescription() || this.benTerminal.getRemoteIP() != bt.getRemoteIP() || this.benTerminal.getRemotePort() != bt.getRemotePort()));
    }

    class MyCelRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        MyCelRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setBackground(table.getTableHeader().getBackground());
            this.setHorizontalAlignment(0);
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

