/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketException;

public class UdpServerSocket {
    private byte[] buffer = new byte[1024];
    private DatagramSocket ds = null;
    private DatagramPacket packet = null;
    private InetSocketAddress socketAddress = null;
    private String orgIp;

    public UdpServerSocket(String serverIP, int serverPort) throws Exception {
        this.socketAddress = new InetSocketAddress(serverIP, serverPort);
        this.ds = new DatagramSocket(this.socketAddress);
        new Thread(new Runner()).start();
    }

    public final String getOrgIp() {
        return this.orgIp;
    }

    public final void setSoTimeout(int timeout) throws Exception {
        this.ds.setSoTimeout(timeout);
    }

    public final int getSoTimeout() throws Exception {
        return this.ds.getSoTimeout();
    }

    public final void bind(String host, int port) throws SocketException {
        this.socketAddress = new InetSocketAddress(host, port);
        this.ds = new DatagramSocket(this.socketAddress);
    }

    public final String receive() throws IOException {
        this.packet = new DatagramPacket(this.buffer, this.buffer.length);
        this.ds.receive(this.packet);
        this.orgIp = this.packet.getAddress().getHostAddress();
        String info = new String(this.packet.getData(), 0, this.packet.getLength());
        return info;
    }

    public final void response(String info) throws IOException {
        DatagramPacket dp = new DatagramPacket(this.buffer, this.buffer.length, this.packet.getAddress(), this.packet.getPort());
        dp.setData(info.getBytes());
        this.ds.send(dp);
    }

    public final void setLength(int bufsize) {
        this.packet.setLength(bufsize);
    }

    public final InetAddress getResponseAddress() {
        return this.packet.getAddress();
    }

    public final int getResponsePort() {
        return this.packet.getPort();
    }

    public final void close() {
        try {
            this.ds.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        @Override
        public void run() {
            while (true) {
                try {
                    while (true) {
                        UdpServerSocket.this.receive();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    continue;
                }
                break;
            }
        }
    }
}

