/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import pscs.connect.udp.UdpServerSocket;

public class UdpClientSocket {
    private byte[] buffer = new byte[1024];
    private DatagramSocket ds = new DatagramSocket();

    public final void setSoTimeout(int timeout) throws Exception {
        this.ds.setSoTimeout(timeout);
    }

    public final int getSoTimeout() throws Exception {
        return this.ds.getSoTimeout();
    }

    public final DatagramSocket getSocket() {
        return this.ds;
    }

    public final DatagramPacket send(String host, int port, byte[] bytes) throws IOException {
        DatagramPacket dp = new DatagramPacket(bytes, bytes.length, InetAddress.getByName(host), port);
        this.ds.send(dp);
        return dp;
    }

    public final String receive() throws Exception {
        DatagramPacket dp = new DatagramPacket(this.buffer, this.buffer.length);
        this.ds.receive(dp);
        String info = new String(dp.getData(), 0, dp.getLength());
        return info;
    }

    public final void close() {
        try {
            this.ds.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void main(String[] args) throws Exception {
        String serverIP = "192.168.1.19";
        String remoteIP = "192.168.1.178";
        int serverPort = 8888;
        int remotePort = 4001;
        new UdpServerSocket(serverIP, serverPort);
        UdpClientSocket client = new UdpClientSocket();
        String cmd = "GETD\r";
        client.send(remoteIP, remotePort, cmd.getBytes());
    }
}

