/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect.tcp;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.ServerSocket;
import java.net.Socket;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import pscs.func;

public class FrmTcpClient {
    boolean isServer = false;
    int localhostPost;
    int remotePost;
    String remoteIP = "58.254.200.34";
    JTextField txtRemoteIP;
    JTextField txtRemotePort;
    JTextField txtSend = new JTextField("GALL!");
    JTextArea txtArea;

    public static void main(String[] args) {
        new FrmTcpClient();
    }

    FrmTcpClient() {
        if (this.isServer) {
            this.localhostPost = 5000;
            this.remotePost = 8000;
        } else {
            this.localhostPost = 5000;
            this.remotePost = 8000;
        }
        this.initUI();
        if (this.isServer) {
            new Thread(new Runner()).start();
        }
    }

    void initUI() {
        JFrame frm = new JFrame(this.isServer ? "TCP/IP-Server" : "TCP/IP-Client");
        JButton butSend = new JButton("Send");
        JPanel panNorth = new JPanel();
        JPanel panRemote = new JPanel();
        JPanel panSend = new JPanel();
        this.txtRemoteIP = new JTextField(this.remoteIP);
        this.txtRemotePort = new JTextField("" + this.remotePost);
        this.txtArea = new JTextArea();
        frm.setSize(600, 400);
        frm.setLocationRelativeTo(null);
        this.txtRemoteIP.setPreferredSize(new Dimension(100, 22));
        this.txtRemotePort.setPreferredSize(new Dimension(50, 22));
        panRemote.setBorder(BorderFactory.createTitledBorder("Remote"));
        panSend.setBorder(BorderFactory.createTitledBorder("Send"));
        this.txtSend.setPreferredSize(new Dimension(200, 22));
        this.txtArea.setEditable(false);
        panRemote.add(new JLabel("IP:"));
        panRemote.add(this.txtRemoteIP);
        panRemote.add(new JLabel("  Port:"));
        panRemote.add(this.txtRemotePort);
        panSend.add(panRemote);
        panSend.add(this.txtSend);
        panSend.add(butSend);
        panNorth.add(panRemote);
        panNorth.add(panSend);
        frm.add((Component)panNorth, "North");
        frm.add(new JScrollPane(this.txtArea));
        frm.setVisible(true);
        frm.setDefaultCloseOperation(3);
        this.txtSend.addKeyListener(new KeyListener(){

            @Override
            public void keyPressed(KeyEvent arg0) {
            }

            @Override
            public void keyReleased(KeyEvent arg0) {
                if (arg0.getKeyCode() == 10) {
                    FrmTcpClient.this.sendImpl();
                }
            }

            @Override
            public void keyTyped(KeyEvent arg0) {
            }
        });
        butSend.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                FrmTcpClient.this.sendImpl();
            }
        });
    }

    private void sendImpl() {
        Socket socket = null;
        PrintWriter out = null;
        BufferedReader bufReader = null;
        try {
            this.txtArea.setText(String.valueOf(this.txtArea.getText()) + "[send:] " + this.txtSend.getText() + "\r\n");
            socket = new Socket(this.txtRemoteIP.getText(), func.getInt(this.txtRemotePort.getText()));
            socket.setSoTimeout(500);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            bufReader = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
            out.println(this.txtSend.getText());
            String strRead = bufReader.readLine();
            if (strRead != null) {
                this.txtArea.setText(String.valueOf(this.txtArea.getText()) + "[read:] " + strRead + "\r\n");
            }
            socket.close();
            this.txtSend.requestFocus();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    class Runner
    implements Runnable {
        Runner() {
        }

        @Override
        public void run() {
            ServerSocket ss = null;
            Socket socket = null;
            while (true) {
                try {
                    try {
                        ss = new ServerSocket(FrmTcpClient.this.localhostPost);
                        socket = ss.accept();
                        BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
                        PrintWriter out = new PrintWriter((Writer)new BufferedWriter(new OutputStreamWriter(socket.getOutputStream())), true);
                        String str = in.readLine();
                        if (str == null) continue;
                        FrmTcpClient.this.txtArea.setText(String.valueOf(FrmTcpClient.this.txtArea.getText()) + "[read:] " + str + "\r\n");
                        out.println(str);
                        FrmTcpClient.this.txtArea.setText(String.valueOf(FrmTcpClient.this.txtArea.getText()) + "[send:] " + str + "\r\n");
                    }
                    catch (IOException iOException) {
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                            if (ss == null) continue;
                            ss.close();
                        }
                        catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                    continue;
                }
                finally {
                    try {
                        if (socket != null) {
                            socket.close();
                        }
                        if (ss == null) continue;
                        ss.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    continue;
                }
                break;
            }
        }
    }
}

