/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect.editConnectName;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import pscs.App;
import pscs._FrmPSCS;
import pscs.bean.BeanConnectInfo;
import pscs.connect.Connect;
import pscs.func;
import pscs.multiple.DlogConnectEdit;
import pscs.rw;

public class PanConnectTableEdit
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    DefaultTableModel dtm = new DefaultTableModel(new Object[0][], new String[]{"Name", "Description", "Connection", "Remote IP", "Remote Port", "COMM Port", "RS485 ID"}){
        private static final long serialVersionUID = 1L;

        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }
    };
    public JTable table = new JTable(this.dtm);
    JButton butAdd = new JButton("Add");
    JButton butEdit = new JButton("Edit");
    JButton butDelete = new JButton("Delete");
    JButton butExitEdit = new JButton("Exit Edit");
    String currConnName = null;
    PanConnectTableEdit me = this;
    public JComboBox<String> cmbCellEditor_Model = new JComboBox();
    private _FrmPSCS pscs;

    public PanConnectTableEdit(_FrmPSCS pscs) {
        this.pscs = pscs;
        this.initUI();
        this.listener();
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createEtchedBorder());
        this.setPreferredSize(new Dimension(180, 180));
        this.table.setSelectionBackground(new Color(255, 170, 100));
        this.table.setGridColor(this.pscs.app.gridLineColor);
        this.table.setShowGrid(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.getColumn(this.table.getColumnName(0)).setPreferredWidth(110);
        this.table.getColumn(this.table.getColumnName(1)).setPreferredWidth(75);
        this.table.getColumn(this.table.getColumnName(2)).setPreferredWidth(105);
        this.table.getColumn(this.table.getColumnName(3)).setPreferredWidth(95);
        this.table.getColumn(this.table.getColumnName(4)).setPreferredWidth(80);
        this.table.getColumn(this.table.getColumnName(5)).setPreferredWidth(75);
        this.table.getColumn(this.table.getColumnName(6)).setPreferredWidth(70);
        this.table.setRowHeight(20);
        int i = 0;
        while (i < this.table.getColumnCount()) {
            this.table.getColumn(this.table.getColumnName(i)).setCellRenderer(new ColumnRenderer());
            ++i;
        }
        this.table.setAutoResizeMode(0);
        JPanel panButs = new JPanel();
        panButs.add(this.butAdd);
        panButs.add(this.butEdit);
        panButs.add(this.butDelete);
        panButs.add(new JLabel("               "));
        panButs.add(this.butExitEdit);
        this.add(new JScrollPane(this.table));
        this.add((Component)panButs, "South");
    }

    protected void listener() {
        this.butAdd.addActionListener(this);
        this.butEdit.addActionListener(this);
        this.butDelete.addActionListener(this);
        this.butExitEdit.addActionListener(this);
        this.table.addMouseListener(new MouseListener(){

            @Override
            public void mouseReleased(MouseEvent e) {
            }

            @Override
            public void mousePressed(MouseEvent e) {
            }

            @Override
            public void mouseExited(MouseEvent e) {
            }

            @Override
            public void mouseEntered(MouseEvent e) {
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                Object val;
                if (PanConnectTableEdit.this.table.getSelectedRow() >= 0 && PanConnectTableEdit.this.table.getSelectedRow() < PanConnectTableEdit.this.table.getRowCount() && (val = PanConnectTableEdit.this.table.getValueAt(PanConnectTableEdit.this.table.getSelectedRow(), 0)) != null) {
                    PanConnectTableEdit.this.currConnName = PanConnectTableEdit.this.table.getValueAt(PanConnectTableEdit.this.table.getSelectedRow(), 0).toString();
                }
                if (e.getClickCount() == 2) {
                    PanConnectTableEdit.this.editRowConnect();
                }
            }
        });
    }

    public void addNewRow(Connect conn) {
        this.dtm.addRow(new Object[]{conn.getConnInfo().getName(), conn.getConnInfo().getDescription(), conn.getConnInfo().getBeanConnectType(), conn.getConnInfo().getRemoteIp(), conn.getConnInfo().getRemotePort() == 0 ? null : conn.getConnInfo().getRemotePort(), conn.getConnInfo().getCommPort(), conn.getConnInfo().getRs485id() == 0 ? null : Integer.valueOf(conn.getConnInfo().getRs485id())});
        this.currConnName = conn.getConnInfo().getName();
        this.selectRow();
    }

    private void editRowConnect() {
        if (this.currConnName != null && this.currConnName.length() > 0) {
            int i = 0;
            while (i < this.pscs.cmbConn.getItemCount()) {
                Connect idxConn = (Connect)this.pscs.cmbConn.getItemAt(i);
                if (idxConn.getConnInfo().getName().equals(this.currConnName)) {
                    new DlogConnectEdit(idxConn, this.me);
                    rw.saveCmbConnToTxt();
                    break;
                }
                ++i;
            }
        }
    }

    public void refreshCurrRow(Connect conn) {
        int r = 0;
        while (r < this.table.getRowCount()) {
            if (this.table.getValueAt(r, 0).toString().contentEquals(this.currConnName)) {
                this.table.setValueAt(conn.getConnInfo().getName(), r, 0);
                this.table.setValueAt(conn.getConnInfo().getDescription(), r, 1);
                this.table.setValueAt((Object)conn.getConnInfo().getBeanConnectType(), r, 2);
                this.table.setValueAt(conn.getConnInfo().getRemoteIp(), r, 3);
                this.table.setValueAt(conn.getConnInfo().getRemotePort() == 0 ? null : conn.getConnInfo().getRemotePort(), r, 4);
                this.table.setValueAt(conn.getConnInfo().getCommPort(), r, 5);
                this.table.setValueAt(conn.getConnInfo().getRs485id() == 0 ? null : Integer.valueOf(conn.getConnInfo().getRs485id()), r, 6);
                this.currConnName = this.table.getValueAt(r, 0) == null ? null : this.table.getValueAt(r, 0).toString();
                break;
            }
            ++r;
        }
    }

    public void refreshLanguage() {
        this.butAdd.setText(this.pscs.lang.getString("Lang_Connect_Add"));
        this.butEdit.setText(this.pscs.lang.getString("Lang_Connect_Edit"));
        this.butDelete.setText(this.pscs.lang.getString("Lang_Connect_Delete"));
        this.butExitEdit.setText(this.pscs.lang.getString("Lang_Connect_Exit_Edit"));
        this.table.getColumnModel().getColumn(0).setHeaderValue(this.pscs.lang.getString("Lang_Connect_Name"));
        this.table.getColumnModel().getColumn(1).setHeaderValue(this.pscs.lang.getString("Lang_Description"));
        this.table.getColumnModel().getColumn(2).setHeaderValue(this.pscs.lang.getString("Lang_Connect_Type"));
        this.table.getColumnModel().getColumn(3).setHeaderValue(this.pscs.lang.getString("Lang_Connect_Remote_IP"));
        this.table.getColumnModel().getColumn(4).setHeaderValue(this.pscs.lang.getString("Lang_Connect_Remote_Port"));
        this.table.getColumnModel().getColumn(5).setHeaderValue(this.pscs.lang.getString("Lang_Connect_COMM_Port"));
        this.table.getColumnModel().getColumn(6).setHeaderValue(this.pscs.lang.getString("Lang_Connect_RS485ID"));
    }

    public void refreshTableConnect() {
        int i;
        this.pscs.cmbConn.autoLoad = true;
        this.dtm.setRowCount(0);
        this.pscs.cmbConn.autoLoad = false;
        boolean finded = false;
        if (this.currConnName != null) {
            i = 0;
            while (i < this.pscs.cmbConn.getItemCount()) {
                Connect conn = (Connect)this.pscs.cmbConn.getItemAt(i);
                if (conn != null && this.currConnName.equals(conn.getConnectName())) {
                    this.pscs.cmbConn.setSelectedIndex(i);
                    finded = true;
                    break;
                }
                ++i;
            }
        }
        if (!finded && this.pscs.cmbConn.getItemCount() > 0) {
            this.pscs.cmbConn.setSelectedIndex(0);
        }
        i = 0;
        while (i < this.pscs.cmbConn.getItemCount()) {
            BeanConnectInfo bci = ((Connect)this.pscs.cmbConn.getItemAt(i)).getConnInfo();
            this.dtm.addRow(new Object[]{bci.getName(), bci.getDescription(), bci.getBeanConnectType() == null ? null : bci.getBeanConnectType().toString(), bci.getRemoteIp() == null || bci.getRemoteIp().equals("null") ? "" : bci.getRemoteIp(), bci.getRemotePort() == 0 ? null : bci.getRemotePort(), bci.getCommPort() == null ? null : bci.getCommPort(), bci.getRs485id() == 0 ? null : Integer.valueOf(bci.getRs485id()), App.getIt().clientModelMap.get(bci.getModel())});
            ++i;
        }
        this.selectRow();
        this.pscs.cmbConn.startRunAll();
    }

    private void selectRow() {
        int row = 0;
        while (row < this.table.getRowCount()) {
            String currName = func.getString(this.table.getValueAt(row, 0));
            if (currName != null && currName.equals(this.currConnName)) {
                this.table.setRowSelectionInterval(row, row);
                break;
            }
            ++row;
        }
    }

    public boolean checkRow(int row) {
        boolean pass = true;
        try {
            if (this.isNull(this.table.getValueAt(row, 0)) || this.isNull(this.table.getValueAt(row, 2))) {
                pass = false;
            } else {
                String connType = this.table.getValueAt(row, 2).toString();
                if (connType.equals("Ethernet")) {
                    if (this.isNull(this.table.getValueAt(row, 3)) || func.getInt(this.table.getValueAt(row, 4)) == 0) {
                        pass = false;
                    }
                } else if (connType.equals("USB")) {
                    if (this.isNull(this.table.getValueAt(row, 5))) {
                        pass = false;
                    }
                } else if (connType.equals("RS485") && (this.isNull(this.table.getValueAt(row, 5)) || func.getInt(this.table.getValueAt(row, 6)) == 0)) {
                    pass = false;
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException e) {
            return false;
        }
        return pass;
    }

    private boolean isNull(Object obj) {
        return obj == null || obj.toString().trim().length() == 0;
    }

    @Override
    public void actionPerformed(ActionEvent arg0) {
        if (arg0.getSource() == this.butExitEdit) {
            this.setVisible(false);
        } else if (arg0.getSource() == this.butAdd) {
            new DlogConnectEdit(null, this.me);
        } else if (arg0.getSource() == this.butEdit) {
            if ((this.currConnName == null || this.currConnName.length() == 0) && this.table.getRowCount() > 0) {
                this.currConnName = (String)this.table.getValueAt(0, 0);
            }
            this.editRowConnect();
        } else if (arg0.getSource() == this.butDelete) {
            if ((this.currConnName == null || this.currConnName.length() == 0) && this.table.getRowCount() > 0) {
                this.currConnName = (String)this.table.getValueAt(0, 0);
            }
            if (this.currConnName != null && this.currConnName.length() > 0) {
                int i = 0;
                while (i < this.pscs.cmbConn.getItemCount()) {
                    Connect idxConn = (Connect)this.pscs.cmbConn.getItemAt(i);
                    if (idxConn.getConnInfo().getName().equals(this.currConnName)) {
                        if (JOptionPane.showConfirmDialog(new JPanel(), String.valueOf(this.pscs.lang.getString("Lang_Connect_Are_You_Delete")) + " '" + idxConn.getConnectName() + "' ?", this.pscs.lang.getString("Lang_Connect_Delete"), 0) != 0) break;
                        idxConn.exit();
                        this.pscs.cmbConn.removeItemAt(i);
                        int r = 0;
                        while (r < this.table.getRowCount()) {
                            if (this.table.getValueAt(r, 0).toString().contentEquals(this.currConnName)) {
                                this.dtm.removeRow(r);
                                break;
                            }
                            ++r;
                        }
                        rw.saveCmbConnToTxt();
                        this.currConnName = null;
                        break;
                    }
                    ++i;
                }
            }
        }
    }

    class ColumnRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;

        ColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            Color fc = PanConnectTableEdit.this.checkRow(row) ? new Color(0, 128, 0) : Color.BLACK;
            this.setForeground(fc);
            table.setSelectionForeground(fc);
            return this;
        }
    }
}

