/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetSSP9xxx
implements CmdIntf {
    _FrmPSCS pscs = _FrmPSCS.getIt();
    Connect conn = null;

    public CmdSetSSP9xxx(Connect connect) {
        this.conn = connect;
    }

    @Override
    public int getABCSelected() {
        String readStr = this.conn.send("GABC");
        if (readStr.length() > 0) {
            return func.getInt(readStr.substring(0, 1));
        }
        return 0;
    }

    @Override
    public String getAll() {
        String readStr = this.conn.send("GALL");
        return readStr;
    }

    @Override
    public PairVC getMax() {
        PairVC vc = new PairVC();
        if (this.conn.ps.getModel().equals("SSP9081")) {
            vc.setVolt(36.4f);
            vc.setCurr(5.1f * (float)this.conn.ps.getMachines());
            this.conn.ps.setMaxPower(80 * this.conn.ps.getMachines());
        }
        return vc;
    }

    @Override
    public String getModel() {
        String line = this.conn.getConnInfo().getModel();
        return line;
    }

    @Override
    public boolean getOutputIsOn() {
        try {
            String str = this.conn.send("GOUT");
            return str.substring(0, 1).equals("1");
        }
        catch (Exception e1) {
            return true;
        }
    }

    @Override
    public Object[][] getPresetMemory() {
        Object[][] arrFloat = new Object[3][3];
        try {
            String readStr = this.conn.send("GETS1");
            String[] arr = readStr.split(";");
            if (arr.length > 1) {
                arrFloat[0][0] = false;
                arrFloat[0][1] = Float.valueOf(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
                arrFloat[0][2] = Float.valueOf(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
            }
            if ((arr = (readStr = this.conn.send("GETS2")).split(";")).length > 1) {
                arrFloat[1][0] = false;
                arrFloat[1][1] = Float.valueOf(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
                arrFloat[1][2] = Float.valueOf(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
            }
            if ((arr = (readStr = this.conn.send("GETS3")).split(";")).length > 1) {
                arrFloat[2][0] = false;
                arrFloat[2][1] = Float.valueOf(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
                arrFloat[2][2] = Float.valueOf(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrFloat;
    }

    @Override
    public PairVC getSetting() {
        PairVC vc = new PairVC();
        this.conn.ps.setABCSelected(this.getABCSelected());
        String readStr = this.conn.send("GETS" + this.conn.ps.getABCSelected());
        if (readStr.indexOf("OK") > 0) {
            String[] arr = readStr.split(";");
            vc.setVolt(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay() * (float)this.conn.ps.getMachines());
        }
        return vc;
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GETS" + abcSelectIndex);
        if (readStr.indexOf("OK") > 0) {
            String[] arr = readStr.split(";");
            vc.setVolt(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
        }
        return vc;
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        PairVCS vcs = new PairVCS();
        String readStr = this.conn.send("GDAT");
        if (readStr.indexOf("OK") < 0) {
            readStr = this.conn.send("GDAT");
        }
        try {
            String[] arr = readStr.split(";");
            if (arr.length > 6) {
                vcs.setVolt(func.getFloat(arr[this.conn.isRunningTableWFG ? 5 : 0]) / (float)this.conn.ps.getVoltFormatDisplay());
                vcs.setCurr(func.getFloat(arr[this.conn.isRunningTableWFG ? 6 : 1]) / (float)this.conn.ps.getCurrFormatDisplay() * (float)this.conn.ps.getMachines());
                EnmCCCV cccv = arr[2].equals("0") ? EnmCCCV.CV : EnmCCCV.CC;
                vcs.setCccv(cccv);
                if (this.conn.isRunningTableWFG && arr[3].equals("0") || !this.conn.isRunningTableWFG && arr[3].equals("1")) {
                    this.conn.isRunningTableWFG = !this.conn.isRunningTableWFG;
                    this.conn.ps.setOutput(false);
                    if (this.pscs.getConnCurr() == this.conn) {
                        this.pscs.refreshButsEnable();
                    }
                }
                int m = func.getInt(arr[4]) + 1;
                if (this.conn.ps.getMachines() != m) {
                    this.conn.ps.setMachines(m);
                }
                return vcs;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public float getCurrentUppeLimit() {
        String str = this.conn.send("GOCP");
        if (str.indexOf("OK") > 0) {
            return func.getFloat(str) / (float)this.conn.ps.getCurrFormatSetting() * (float)this.conn.ps.getMachines();
        }
        return 0.0f;
    }

    @Override
    public float getVoltageUppeLimit() {
        String str = this.conn.send("GOVP");
        if (str.indexOf("OK") > 0) {
            return func.getFloat(str) / (float)this.conn.ps.getVoltFormatSetting();
        }
        return 0.0f;
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        float val2 = val / (float)(this.conn.ps.getMachines() == 0 ? 1 : this.conn.ps.getMachines());
        return this.conn.send("SOCP" + String.format("%04d", (int)(val2 * (float)this.conn.ps.getCurrFormatSetting())));
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        String readStr = this.conn.send("SOVP" + String.format("%04d", (int)(val * (float)this.conn.ps.getVoltFormatSetting())));
        return readStr;
    }

    @Override
    public String setMemoryIndex(int index) {
        return null;
    }

    @Override
    public String setKeyBoard(boolean lock) {
        if (lock) {
            return this.conn.send("SESS");
        }
        return this.conn.send("ENDS");
    }

    @Override
    public String setOutput(boolean outputOn) {
        if (outputOn) {
            return this.conn.send("SOUT1");
        }
        return this.conn.send("SOUT0");
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        String rs = "";
        rs = String.valueOf(rs) + this.conn.send("SETD1" + String.format("%04d", (int)(((Float)arr[0][1]).floatValue() * (float)this.conn.ps.getVoltFormatSetting())) + String.format("%04d", (int)(((Float)arr[0][2]).floatValue() * (float)this.conn.ps.getCurrFormatSetting())));
        rs = String.valueOf(rs) + this.conn.send("SETD2" + String.format("%04d", (int)(((Float)arr[1][1]).floatValue() * (float)this.conn.ps.getVoltFormatSetting())) + String.format("%04d", (int)(((Float)arr[1][2]).floatValue() * (float)this.conn.ps.getCurrFormatSetting())));
        rs = String.valueOf(rs) + this.conn.send("SETD3" + String.format("%04d", (int)(((Float)arr[2][1]).floatValue() * (float)this.conn.ps.getVoltFormatSetting())) + String.format("%04d", (int)(((Float)arr[2][2]).floatValue() * (float)this.conn.ps.getCurrFormatSetting())));
        return rs;
    }

    @Override
    public String setCurrent(float val) {
        float val2 = val / (float)this.conn.ps.getMachines();
        String readStr = this.conn.send("CURR" + this.conn.ps.getABCSelected() + String.format("%04d", (int)(val2 * (float)this.conn.ps.getCurrFormatSetting())));
        return readStr;
    }

    @Override
    public String setVoltage(float val) {
        String cmd = "VOLT" + this.conn.ps.getABCSelected() + String.format("%04d", (int)(val * (float)this.conn.ps.getVoltFormatSetting()));
        this.pscs.panWFG.tableSetting.setValueAt("" + val, 0, this.conn.ps.getABCSelected() + 1);
        return this.conn.send(cmd);
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        float curr2 = curr / (float)this.conn.ps.getMachines();
        if (this.conn.runETP.runAllRowIndex <= 1) {
            this.conn.send("SABC0");
        }
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        int intOutput = output ? 1 : 0;
        String line = this.conn.send("SVCO0" + String.format("%04d", (int)(volt * 100.0f)) + String.format("%04d", (int)(curr2 * 1000.0f)) + intOutput);
        if (line.indexOf("OK") < 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            line = this.conn.send("SVCO0" + String.format("%04d", Float.valueOf(volt)) + String.format("%04d", Float.valueOf(curr2)) + intOutput);
        }
        if (line.indexOf("OK") >= 0) {
            this.conn.ps.setABCSelected(3);
            this.conn.ps.setSetting(new PairVC(volt, curr2));
            return "OK";
        }
        return "";
    }

    @Override
    public String setProgram() {
        return null;
    }

    @Override
    public String getProgram() {
        return null;
    }
}

