/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetSSP8xxx
implements CmdIntf {
    _FrmPSCS pscs = _FrmPSCS.getIt();
    Connect conn = null;

    public CmdSetSSP8xxx(Connect connect) {
        this.conn = connect;
    }

    @Override
    public int getABCSelected() {
        String readStr = this.conn.send("GABC");
        if (readStr.length() > 0) {
            return func.getInt(readStr.substring(0, 1));
        }
        return 0;
    }

    @Override
    public String getAll() {
        String readStr = this.conn.send("GALL");
        return readStr;
    }

    @Override
    public PairVC getMax() {
        PairVC vc = new PairVC();
        if (this.conn.ps.getModel().equals("SSP8160")) {
            vc.setVolt(42.7f);
            vc.setCurr(10.2f);
            this.conn.ps.setMaxPower(160.0f);
        } else if (this.conn.ps.getModel().equals("SSP8162")) {
            vc.setVolt(84.7f);
            vc.setCurr(5.1f);
            this.conn.ps.setMaxPower(160.0f);
        } else if (this.conn.ps.getModel().equals("SSP8320")) {
            vc.setVolt(42.7f);
            vc.setCurr(20.4f);
            this.conn.ps.setMaxPower(320.0f);
        } else if (this.conn.ps.getModel().equals("SSP8322")) {
            vc.setVolt(84.7f);
            vc.setCurr(10.2f);
            this.conn.ps.setMaxPower(320.0f);
        }
        return vc;
    }

    @Override
    public String getModel() {
        return this.conn.getConnInfo().getModel();
    }

    @Override
    public boolean getOutputIsOn() {
        try {
            String str = this.conn.send("GOUT");
            return str.substring(0, 1).equals("1");
        }
        catch (Exception e1) {
            return true;
        }
    }

    @Override
    public Object[][] getPresetMemory() {
        return null;
    }

    @Override
    public PairVC getSetting() {
        PairVC vc = new PairVC();
        this.conn.ps.setABCSelected(this.getABCSelected());
        String readStr = this.conn.send("GETS" + this.conn.ps.getABCSelected());
        if (readStr.indexOf("OK") > 0) {
            if (this.conn.ps.getVoltFormatDisplay() > 0) {
                vc.setVolt(func.getFloat(readStr.substring(0, 4)) / (float)this.conn.ps.getVoltFormatDisplay());
            }
            if (this.conn.ps.getCurrFormatDisplay() > 0) {
                vc.setCurr(func.getFloat(readStr.substring(4, 8)) / (float)this.conn.ps.getCurrFormatDisplay());
            }
        }
        return vc;
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GETS" + abcSelectIndex);
        if (readStr.indexOf("OK") > 0) {
            if (this.conn.ps.getVoltFormatDisplay() > 0) {
                vc.setVolt(func.getFloat(readStr.substring(0, 4)) / (float)this.conn.ps.getVoltFormatDisplay());
            }
            if (this.conn.ps.getCurrFormatDisplay() > 0) {
                vc.setCurr(func.getFloat(readStr.substring(4, 8)) / (float)this.conn.ps.getCurrFormatDisplay());
            }
        }
        return vc;
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        PairVCS vcs = new PairVCS();
        String readStr = this.conn.send("GETD");
        if (readStr.indexOf("OK") < 0) {
            readStr = this.conn.send("GETD");
        }
        try {
            vcs.setVolt(func.getFloat(readStr.substring(0, 4)) / (float)this.conn.ps.getVoltFormatDisplay());
            vcs.setCurr(func.getFloat(readStr.substring(4, 8)) / (float)this.conn.ps.getCurrFormatDisplay());
            EnmCCCV cccv = null;
            if (readStr.substring(8, 9).equals("0")) {
                cccv = EnmCCCV.CV;
            }
            vcs.setCccv(cccv);
        }
        catch (Exception e1) {
            vcs = null;
        }
        return vcs;
    }

    @Override
    public float getCurrentUppeLimit() {
        String str = this.conn.send("GOCP");
        if (str.indexOf("OK") > 0) {
            return func.getFloat(str) / (float)this.conn.ps.getCurrFormatSetting();
        }
        return 0.0f;
    }

    @Override
    public float getVoltageUppeLimit() {
        String str = this.conn.send("GOVP");
        if (str.indexOf("OK") > 0) {
            return func.getFloat(str.substring(0, 4)) / (float)this.conn.ps.getVoltFormatDisplay();
        }
        return 0.0f;
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        return this.conn.send("SOCP" + String.format("%04d", (int)(val * (float)this.conn.ps.getCurrFormatSetting())));
    }

    @Override
    public String setMemoryIndex(int index) {
        return null;
    }

    @Override
    public String setKeyBoard(boolean lock) {
        return null;
    }

    @Override
    public String setOutput(boolean outputOn) {
        if (outputOn) {
            return this.conn.send("SOUT1");
        }
        return this.conn.send("SOUT0");
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        return null;
    }

    @Override
    public String setCurrent(float val) {
        String readStr = this.conn.send("CURR" + this.conn.ps.getABCSelected() + String.format("%04d", (int)(val * (float)this.conn.ps.getCurrFormatSetting())));
        return readStr;
    }

    @Override
    public String setVoltage(float val) {
        String cmd = "VOLT" + this.conn.ps.getABCSelected() + String.format("%04d", (int)(val * (float)this.conn.ps.getVoltFormatSetting()));
        if (this.conn.ps.getModel().equals("8080") && this.conn.ps.getABCSelected() >= 0 && this.conn.ps.getABCSelected() <= 2) {
            this.pscs.panWFG.tableSetting.setValueAt("" + val, 0, this.conn.ps.getABCSelected() + 1);
        }
        return this.conn.send(cmd);
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        if (this.conn.ps.getModel().equals("8080")) {
            String line = this.setVoltage(volt);
            line = String.valueOf(line) + this.setCurrent(curr);
            if ((line = String.valueOf(line) + this.setOutput(output)).length() >= 6) {
                this.conn.ps.setSetting(new PairVC(volt, curr));
                return "OK";
            }
            return "";
        }
        this.conn.send("SABC3");
        this.conn.ps.setABCSelected(3);
        String line = this.setVoltage(volt);
        line = String.valueOf(line) + this.setCurrent(curr);
        line = String.valueOf(line) + this.setOutput(output);
        if (line.length() >= 6) {
            this.conn.ps.setSetting(new PairVC(volt, curr));
            return "OK";
        }
        return "";
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        String readStr = this.conn.send("SOVP" + String.format("%04d", (int)(val * (float)this.conn.ps.getVoltFormatSetting())));
        return readStr;
    }

    @Override
    public String setProgram() {
        return null;
    }

    @Override
    public String getProgram() {
        return null;
    }
}

