/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetSDP3xxx
implements CmdIntf {
    _FrmPSCS pscs = _FrmPSCS.getIt();
    Connect conn = null;

    public CmdSetSDP3xxx(Connect connect) {
        this.conn = connect;
    }

    @Override
    public String getAll() {
        return "";
    }

    @Override
    public PairVC getMax() {
        PairVC vc = null;
        if (this.conn.ps.getModel().startsWith("SDP3618")) {
            vc = new PairVC(18.2f, 21.5f);
        } else if (this.conn.ps.getModel().startsWith("SDP3636")) {
            vc = new PairVC(36.2f, 11.5f);
        } else if (this.conn.ps.getModel().startsWith("SDP3660")) {
            vc = new PairVC(60.5f, 6.5f);
        }
        return vc;
    }

    @Override
    public String getModel() {
        return null;
    }

    @Override
    public boolean getOutputIsOn() {
        try {
            String str = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "OUTP?");
            return str.startsWith("1");
        }
        catch (Exception e1) {
            return true;
        }
    }

    @Override
    public Object[][] getPresetMemory() {
        return null;
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        EnmCCCV cccv;
        float c;
        float v;
        PairVCS vcs;
        block6: {
            vcs = new PairVCS();
            v = 0.0f;
            c = 0.0f;
            cccv = EnmCCCV.CV;
            String str = "";
            try {
                boolean isRefreshBut;
                String line = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "MEAS:VOLT?;CURR?").replace("OK", "");
                String[] vc = line.split(";");
                if (vc.length != 2) break block6;
                v = func.getFloat(vc[0]);
                c = func.getFloat(vc[1]);
                try {
                    Thread.sleep(20L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                str = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "SYST:STAT?").replace("OK", "");
                String sysInfo = Integer.toBinaryString(Integer.valueOf(str, 10));
                boolean isRun = this.getRightStr(sysInfo, 9, 1).equals("1");
                boolean isTxtSame = this.pscs.panITP.butIRun.getText().equals(this.pscs.lang.getString(this.conn != null && !this.conn.isRunningTableITP ? "Lang_Run" : "Lang_Stop"));
                boolean bl = isRefreshBut = this.conn.isCurrConn() && (this.conn.isRunningTableITP != isRun || !isTxtSame);
                if (this.conn.isRunningTableITP != isRun) {
                    this.conn.isRunningTableITP = isRun;
                }
                if (isRefreshBut) {
                    this.pscs.refreshButsEnable();
                }
                cccv = this.getRightStr(sysInfo, 0, 1).equals("0") ? EnmCCCV.CV : EnmCCCV.CC;
                boolean output = this.getRightStr(sysInfo, 2, 1).equals("1");
                this.conn.ps.setOutput(output);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        vcs.setVolt(v);
        vcs.setCurr(c);
        vcs.setCccv(cccv);
        return vcs;
    }

    String getRightStr(String line, int idx, int len) {
        String val = line.substring(line.length() - idx - 1, line.length() - idx - 1 + len);
        return val;
    }

    @Override
    public String setCurrent(float val) {
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CURR " + val + "A");
        return "OK";
    }

    @Override
    public String setMemoryIndex(int index) {
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "RUNM" + index);
        return "OK";
    }

    @Override
    public String setKeyBoard(boolean lock) {
        if (lock) {
            this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "SYST:REM");
        } else {
            this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "SYST:LOC");
        }
        return "OK";
    }

    @Override
    public String setOutput(boolean outputOn) {
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + (outputOn ? "OUTP ON" : "OUTP OFF"));
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "OUTP?");
        return "OK";
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        String writeStr = "";
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[0][1]).floatValue() * 10.0f));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[0][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[1][1]).floatValue() * 10.0f));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[1][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[2][1]).floatValue() * 10.0f));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[2][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROM" + writeStr);
        return "OK";
    }

    @Override
    public String setVoltage(float val) {
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT " + val + "V");
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT?");
        return "OK";
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT " + volt + "V");
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CURR " + curr + "A");
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + (output ? "OUTP ON" : "OUTP OFF"));
        return "OK";
    }

    @Override
    public float getCurrentUppeLimit() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String val = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CURRent:LIMit?");
        return func.getFloat(val);
    }

    @Override
    public float getVoltageUppeLimit() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String val = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLTage:LIMit?").replace("OK", "");
        return func.getFloat(val);
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CURRent:LIMit " + val + "A");
        return "OK";
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLTage:LIMit " + val + "V");
        return "OK";
    }

    @Override
    public PairVC getSetting() {
        float v = 0.0f;
        float c = 0.0f;
        String line = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT?;CURR?");
        String[] vc = (line = line.replace("OK", "")).split(";");
        if (vc.length == 2) {
            v = func.getFloat(vc[0]);
            c = func.getFloat(vc[1]);
        }
        return new PairVC(v, c);
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        String strV = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT?");
        float v = strV.equals("") ? 0.0f : func.getFloat(strV) / 1000.0f;
        String strC = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CURR?");
        float c = strC.equals("") ? 0.0f : func.getFloat(strC) / 1000.0f;
        return new PairVC(v, c);
    }

    @Override
    public int getABCSelected() {
        return 0;
    }

    @Override
    public String setProgram() {
        boolean isITP_Runing = true;
        this.pscs.cpts.butSetVCO.setEnabled(!isITP_Runing);
        this.pscs.cpts.butERun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRead.setEnabled(!isITP_Runing);
        this.pscs.panITP.butISave.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIClear.setEnabled(!isITP_Runing);
        if (this.pscs.panUpdateFirmware != null) {
            this.pscs.panUpdateFirmware.setButUpdateFirmwareEnabled(!isITP_Runing);
        }
        if (this.pscs.panCalibration != null) {
            this.pscs.panCalibration.butPasswdEnter.setEnabled(!isITP_Runing);
        }
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROG:SEC OFF");
        int row = 0;
        while (row < 20) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String volt = this.pscs.panITP.tableITP.getValueAt(row, 1).toString();
            String curr = this.pscs.panITP.tableITP.getValueAt(row, 2).toString();
            String time = this.pscs.panITP.tableITP.getValueAt(row, 3).toString();
            String[] Arr = time.split(":");
            String timeSecond = Arr.length == 3 ? "" + (func.getInt(Arr[0]) * 3600 + func.getInt(Arr[1]) * 60 + func.getInt(Arr[2])) : "5";
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROG:DATA" + (row + 1) + " " + volt + "V," + curr + "A," + timeSecond + "S");
            ++row;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROG:SAV");
        try {
            Thread.sleep(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROG:SEC ON");
        isITP_Runing = false;
        this.pscs.cpts.butSetVCO.setEnabled(!isITP_Runing);
        this.pscs.cpts.butERun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRead.setEnabled(!isITP_Runing);
        this.pscs.panITP.butISave.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIClear.setEnabled(!isITP_Runing);
        if (this.pscs.panUpdateFirmware != null) {
            this.pscs.panUpdateFirmware.setButUpdateFirmwareEnabled(!isITP_Runing);
        }
        if (this.pscs.panCalibration != null) {
            this.pscs.panCalibration.butPasswdEnter.setEnabled(!isITP_Runing);
        }
        return "OK";
    }

    @Override
    public String getProgram() {
        return "";
    }

    public Object[][] getProgramArr() {
        String lineAll1 = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROGram:DATA1?;DATA2?;DATA3?;DATA4?;DATA5?");
        String lineAll2 = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROGram:DATA6?;DATA7?;DATA8?;DATA9?;DATA10?");
        String lineAll3 = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROGram:DATA11?;DATA12?;DATA13?;DATA14?;DATA15?");
        String lineAll4 = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "PROGram:DATA16?;DATA17?;DATA18?;DATA19?;DATA20?");
        String lineAll = String.valueOf(lineAll1) + ";" + lineAll2 + ";" + lineAll3 + ";" + lineAll4;
        lineAll = lineAll.replace("OK", ";");
        lineAll = lineAll.replace(";;", ";");
        Object[][] arr = new Object[20][3];
        String[] arrLine = lineAll.split(";");
        if (arrLine.length == 20) {
            int row = 0;
            while (row < 20) {
                String line = arrLine[row];
                String[] aa = line.split(",");
                if (aa.length >= 3) {
                    float v = func.getFloat((Object)aa[0]) / 1000.0f;
                    float c = func.getFloat((Object)aa[1]) / 1000.0f;
                    int s = func.getInt((Object)aa[2]);
                    int h = s / 3600;
                    int mm = s % 3600 / 60;
                    int ss = s % 3600 % 60;
                    String t = String.valueOf(h) + ":" + String.format("%02d", mm) + ":" + String.format("%02d", ss);
                    arr[row][0] = Float.valueOf(v);
                    arr[row][1] = Float.valueOf(c);
                    arr[row][2] = t;
                }
                ++row;
            }
        }
        return arr;
    }
}

