/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.App;
import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmBeanConnectType;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetSDP2new
implements CmdIntf {
    _FrmPSCS pscs = _FrmPSCS.getIt();
    Connect conn = null;

    public CmdSetSDP2new(Connect connect) {
        this.conn = connect;
    }

    @Override
    public String getAll() {
        String line = this.conn.send("GPAL" + this.conn.getConnInfo().getRs485Str());
        if (line.indexOf("OK") > 0) {
            if (line.length() >= 58) {
                String lineSub = line.toUpperCase().replace("OK", "").replace("\r", "");
                int idx = func.getInt(lineSub.substring(57, 58));
                this.conn.ps.setMemoryIndex(idx);
                this.conn.ps.setMemoryIdx(idx);
                if (this.conn.verMcu >= 1.4) {
                    this.conn.isRunningTableITP = func.getRightStr(lineSub, 9, 1).equals("0");
                    this.conn.ps.setOutput(func.getRightStr(lineSub, 3, 1).equals("0"));
                    this.conn.isFault = func.getRightStr(lineSub, 4, 1).equals("0");
                } else {
                    this.conn.isRunningTableITP = func.getRightStr(lineSub, 9, 1).equals("1");
                    this.conn.ps.setOutput(func.getRightStr(lineSub, 3, 1).equals("1"));
                    this.conn.isFault = func.getRightStr(lineSub, 4, 1).equals("1");
                }
            }
            if (this.conn.getConnInfo().getBeanConnectType() == EnmBeanConnectType.RS485) {
                this.getVoltageUppeLimit();
            }
        }
        return line;
    }

    @Override
    public PairVC getMax() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GMAX" + this.conn.getConnInfo().getRs485Str());
        if (readStr.indexOf("OK") >= 6) {
            vc.setVolt(func.getFloat(readStr.substring(0, 3)) / 10.0f);
            String c = readStr.substring(3, 6);
            vc.setCurr(func.getFloat(c) / 100.0f);
            return vc;
        }
        return null;
    }

    @Override
    public String getModel() {
        return this.conn.send("GMOD" + this.conn.getConnInfo().getRs485Str());
    }

    @Override
    public boolean getOutputIsOn() {
        String line = this.conn.send("GPAL" + this.conn.getConnInfo().getRs485Str());
        if (line.indexOf("OK") > 0 && line.length() >= 58) {
            String lineSub = line.toUpperCase().replace("OK", "").replace("\r", "");
            if (this.conn.verMcu >= 1.4) {
                return func.getRightStr(lineSub, 3, 1).equals("0");
            }
            return func.getRightStr(lineSub, 3, 1).equals("1");
        }
        return false;
    }

    @Override
    public Object[][] getPresetMemory() {
        this.conn.initChangeRowArr();
        Object[][] arr = new Object[9][3];
        String readStr = this.conn.send("GETM" + this.conn.getConnInfo().getRs485Str());
        if (readStr.length() == 56) {
            if (readStr.indexOf("OK") > 0) {
                arr[0][0] = false;
                arr[0][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(0, 3), 10));
                arr[0][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(3, 6), this.conn.ps.getCurrFormatSetting()));
                arr[1][0] = false;
                arr[1][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(6, 9), 10));
                arr[1][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(9, 12), this.conn.ps.getCurrFormatSetting()));
                arr[2][0] = false;
                arr[2][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(12, 15), 10));
                arr[2][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(15, 18), this.conn.ps.getCurrFormatSetting()));
                arr[3][0] = false;
                arr[3][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(18, 21), 10));
                arr[3][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(21, 24), this.conn.ps.getCurrFormatSetting()));
                arr[4][0] = false;
                arr[4][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(24, 27), 10));
                arr[4][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(27, 30), this.conn.ps.getCurrFormatSetting()));
                arr[5][0] = false;
                arr[5][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(30, 33), 10));
                arr[5][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(33, 36), this.conn.ps.getCurrFormatSetting()));
                arr[6][0] = false;
                arr[6][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(36, 39), 10));
                arr[6][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(39, 42), this.conn.ps.getCurrFormatSetting()));
                arr[7][0] = false;
                arr[7][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(42, 45), 10));
                arr[7][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(45, 48), this.conn.ps.getCurrFormatSetting()));
                arr[8][0] = false;
                arr[8][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(48, 51), 10));
                arr[8][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(51, 54), this.conn.ps.getCurrFormatSetting()));
                return arr;
            }
            arr = null;
            return arr;
        }
        if (readStr.length() > 56) {
            if (readStr.indexOf("OK") > 0) {
                arr[0][0] = false;
                arr[0][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(6, 9), 10));
                arr[0][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(9, 12), this.conn.ps.getCurrFormatSetting()));
                arr[1][0] = false;
                arr[1][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(12, 15), 10));
                arr[1][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(15, 18), this.conn.ps.getCurrFormatSetting()));
                arr[2][0] = false;
                arr[2][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(18, 21), 10));
                arr[2][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(21, 24), this.conn.ps.getCurrFormatSetting()));
                arr[3][0] = false;
                arr[3][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(24, 27), 10));
                arr[3][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(27, 30), this.conn.ps.getCurrFormatSetting()));
                arr[4][0] = false;
                arr[4][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(30, 33), 10));
                arr[4][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(33, 36), this.conn.ps.getCurrFormatSetting()));
                arr[5][0] = false;
                arr[5][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(36, 39), 10));
                arr[5][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(39, 42), this.conn.ps.getCurrFormatSetting()));
                arr[6][0] = false;
                arr[6][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(42, 45), 10));
                arr[6][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(45, 48), this.conn.ps.getCurrFormatSetting()));
                arr[7][0] = false;
                arr[7][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(48, 51), 10));
                arr[7][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(51, 54), this.conn.ps.getCurrFormatSetting()));
                arr[8][0] = false;
                arr[8][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(54, 57), 10));
                arr[8][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(57, 60), this.conn.ps.getCurrFormatSetting()));
                return arr;
            }
            arr = null;
            return arr;
        }
        arr = null;
        return arr;
    }

    @Override
    public PairVC getSetting() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GETS" + this.conn.getConnInfo().getRs485Str());
        if (readStr == null || readStr.length() == 0) {
            readStr = this.conn.send("GETS" + this.conn.getConnInfo().getRs485Str());
        }
        if (readStr.indexOf("OK") > 0) {
            vc.setVolt(func.getFloat(readStr.substring(0, 3)) / (float)this.conn.ps.getVoltFormatSetting());
            vc.setCurr(func.getFloat(readStr.substring(3, 6)) / (float)this.conn.ps.getCurrFormatSetting());
            return vc;
        }
        return null;
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        try {
            PairVCS vcs = new PairVCS();
            String readStr = this.conn.send("GETD" + this.conn.getConnInfo().getRs485Str());
            vcs.setVolt(func.getFloat(readStr.substring(0, 4)) / (float)this.conn.ps.getVoltFormatDisplay());
            if (this.conn.ps.getCurrFormatDisplay() == 10) {
                vcs.setCurr(func.getFloat(readStr.substring(4, 7)) / (float)this.conn.ps.getCurrFormatDisplay());
            } else {
                vcs.setCurr(func.getFloat(readStr.substring(4, 8)) / (float)this.conn.ps.getCurrFormatDisplay());
            }
            EnmCCCV cccv = null;
            if (readStr.substring(8, 9).equals("0")) {
                cccv = EnmCCCV.CV;
            }
            vcs.setCccv(cccv);
            return vcs;
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public float getVoltageUppeLimit() {
        String str = this.conn.send("GOVP" + this.conn.getConnInfo().getRs485Str());
        if (str == null || str.length() == 0) {
            str = this.conn.send("GOVP" + this.conn.getConnInfo().getRs485Str());
        }
        if (str.indexOf("OK") > 0) {
            return func.getFloat(str.substring(0, 3)) / 10.0f;
        }
        return -0.1f;
    }

    @Override
    public float getCurrentUppeLimit() {
        return this.conn.ps.getMax().getCurr();
    }

    @Override
    public String setCurrent(float val) {
        return this.conn.send("CURR" + this.conn.getConnInfo().getRs485Str() + String.format("%03d", (int)(val * (float)this.conn.ps.getCurrFormatSetting())));
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        return this.conn.send("SOCP" + this.conn.getConnInfo().getRs485Str() + String.format("%03d", (int)(val * (float)this.conn.ps.getCurrFormatSetting())));
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        return this.conn.send("SOVP" + this.conn.getConnInfo().getRs485Str() + String.format("%03d", (int)(val * 10.0f)));
    }

    @Override
    public String setMemoryIndex(int index) {
        this.conn.ps.setMemoryIndex(index);
        return this.conn.send("RUNM" + this.conn.getConnInfo().getRs485Str() + index);
    }

    public int getMemoryIndex() {
        String line = this.conn.send("GPAL" + this.conn.getConnInfo().getRs485Str());
        if (line.length() > 67) {
            int idx = func.getInt(line.substring(57, 58));
            this.conn.ps.setMemoryIndex(idx);
            return idx;
        }
        return 0;
    }

    @Override
    public String setKeyBoard(boolean lock) {
        if (lock) {
            return this.conn.send("SESS" + this.conn.getConnInfo().getRs485Str());
        }
        return this.conn.send("ENDS" + this.conn.getConnInfo().getRs485Str());
    }

    @Override
    public String setOutput(boolean outputOn) {
        String line = this.conn.send("SOUT" + this.conn.getConnInfo().getRs485Str() + (outputOn ? "0" : "1"));
        if (line.equals("OK")) {
            this.conn.ps.setOutput(outputOn);
        }
        return line;
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        String reStr = "";
        int i = 0;
        while (i < arr.length) {
            if (this.conn.isChangeIpmRowArr[i + 1].booleanValue()) {
                reStr = String.valueOf(reStr) + this.conn.send("PROM" + this.conn.getConnInfo().getRs485Str() + (i + 1) + String.format("%03d", (int)(((Float)arr[i][1]).floatValue() * 10.0f)) + String.format("%03d", (int)(((Float)arr[i][2]).floatValue() * (float)this.conn.ps.getCurrFormatSetting())));
                if (this.conn.getConnInfo().getBeanConnectType() == EnmBeanConnectType.RS485) {
                    func.sleep(1000L);
                } else {
                    func.sleep(500L);
                }
            }
            ++i;
        }
        return reStr;
    }

    @Override
    public String setVoltage(float val) {
        return this.conn.send("VOLT" + this.conn.getConnInfo().getRs485Str() + String.format("%03d", (int)(val * 10.0f)));
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        String line = this.conn.send("SVCO" + this.conn.getConnInfo().getRs485Str() + String.format("%03d", (int)(volt * 10.0f)) + String.format("%03d", (int)(curr * (float)this.conn.ps.getCurrFormatSetting())) + (output ? 0 : 1));
        if (line != null && line.indexOf("OK") >= 0) {
            this.conn.ps.setSetting(new PairVC(volt, curr));
        }
        return line;
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        return null;
    }

    @Override
    public int getABCSelected() {
        return 0;
    }

    @Override
    public String setProgram() {
        String reStr = "";
        int r = 0;
        while (r < this.pscs.panITP.tableITP.getRowCount()) {
            float v = func.getFloat(this.pscs.panITP.tableITP.getValueAt(r, 1));
            float c = func.getFloat(this.pscs.panITP.tableITP.getValueAt(r, 2));
            String line = this.pscs.panITP.tableITP.getValueAt(r, 3).toString();
            String[] arr = line.split(":");
            int h = func.getInt(arr[0]);
            int m = h * 60 + func.getInt(arr[1]);
            int s = func.getInt(arr[2]);
            if (m > 99) {
                m = 99;
            }
            if (s > 59) {
                s = 59;
            }
            String cmd = "PROP" + this.conn.getConnInfo().getRs485Str() + func.getFormatStr(r, 2) + func.getFormatStr((int)(v * 10.0f), 3) + func.getFormatStr((int)(c * 100.0f), 3) + func.getFormatStr(m, 2) + func.getFormatStr(s, 2);
            reStr = String.valueOf(reStr) + this.conn.send(cmd);
            ++r;
        }
        return reStr;
    }

    @Override
    public String getProgram() {
        String readStr = this.conn.send("GETP" + this.conn.getConnInfo().getRs485Str());
        return readStr;
    }
}

