/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetNTP
implements CmdIntf {
    _FrmPSCS pscs = _FrmPSCS.getIt();
    Connect conn = null;

    public CmdSetNTP(Connect connect) {
        this.conn = connect;
    }

    @Override
    public int getABCSelected() {
        String readStr = this.conn.send("GABC");
        if (readStr.length() > 0) {
            return func.getInt(readStr.substring(0, 1));
        }
        return 0;
    }

    @Override
    public String getAll() {
        String readStr = this.conn.send("GALL");
        return readStr;
    }

    @Override
    public PairVC getMax() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GMAX");
        if (readStr.indexOf("OK") > 0) {
            String[] arr = readStr.split(";");
            vc.setVolt(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
        }
        return vc;
    }

    @Override
    public String getModel() {
        String line = this.conn.getConnInfo().getModel();
        return line;
    }

    @Override
    public boolean getOutputIsOn() {
        try {
            String str = this.conn.send("GOUT");
            return str.substring(0, 1).equals("1");
        }
        catch (Exception e1) {
            return true;
        }
    }

    @Override
    public Object[][] getPresetMemory() {
        Object[][] arrFloat = new Object[3][3];
        try {
            String readStr = this.conn.send("GETS1");
            String[] arr = readStr.split(";");
            if (arr.length > 1) {
                arrFloat[0][0] = false;
                arrFloat[0][1] = Float.valueOf(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
                arrFloat[0][2] = Float.valueOf(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
            }
            if ((arr = (readStr = this.conn.send("GETS2")).split(";")).length > 1) {
                arrFloat[1][0] = false;
                arrFloat[1][1] = Float.valueOf(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
                arrFloat[1][2] = Float.valueOf(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
            }
            if ((arr = (readStr = this.conn.send("GETS3")).split(";")).length > 1) {
                arrFloat[2][0] = false;
                arrFloat[2][1] = Float.valueOf(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
                arrFloat[2][2] = Float.valueOf(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return arrFloat;
    }

    @Override
    public PairVC getSetting() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GETS");
        if (readStr.indexOf("OK") > 0) {
            String[] arr = readStr.split(";");
            vc.setVolt(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
        }
        return vc;
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GETS");
        if (readStr.indexOf("OK") > 0) {
            String[] arr = readStr.split(";");
            vc.setVolt(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
        }
        return vc;
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        PairVCS vcs = new PairVCS();
        String readStr = this.conn.send("GETD");
        if (readStr.indexOf("OK") < 0) {
            readStr = this.conn.send("GETD");
        }
        try {
            String[] arr = readStr.split(";");
            if (arr.length > 3) {
                vcs.setVolt(func.getFloat(arr[0]) / (float)this.conn.ps.getVoltFormatDisplay());
                vcs.setCurr(func.getFloat(arr[1]) / (float)this.conn.ps.getCurrFormatDisplay());
                EnmCCCV cccv = arr[2].equals("0") ? EnmCCCV.CV : EnmCCCV.CC;
                vcs.setCccv(cccv);
                return vcs;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Override
    public float getCurrentUppeLimit() {
        return this.conn.ps.getMax().getCurr();
    }

    @Override
    public float getVoltageUppeLimit() {
        return this.conn.ps.getMax().getVolt();
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        return "";
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        return "";
    }

    @Override
    public String setMemoryIndex(int index) {
        return "";
    }

    @Override
    public String setKeyBoard(boolean lock) {
        if (lock) {
            return this.conn.send("SESS");
        }
        return this.conn.send("ENDS");
    }

    @Override
    public String setOutput(boolean outputOn) {
        if (outputOn) {
            return this.conn.send("SOUT1");
        }
        return this.conn.send("SOUT0");
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        String rs = "";
        rs = String.valueOf(rs) + this.conn.send("SETD1" + String.format("%04d", (int)(((Float)arr[0][1]).floatValue() * (float)this.conn.ps.getVoltFormatSetting())) + String.format("%04d", (int)(((Float)arr[0][2]).floatValue() * (float)this.conn.ps.getCurrFormatSetting())));
        rs = String.valueOf(rs) + this.conn.send("SETD2" + String.format("%04d", (int)(((Float)arr[1][1]).floatValue() * (float)this.conn.ps.getVoltFormatSetting())) + String.format("%04d", (int)(((Float)arr[1][2]).floatValue() * (float)this.conn.ps.getCurrFormatSetting())));
        rs = String.valueOf(rs) + this.conn.send("SETD3" + String.format("%04d", (int)(((Float)arr[2][1]).floatValue() * (float)this.conn.ps.getVoltFormatSetting())) + String.format("%04d", (int)(((Float)arr[2][2]).floatValue() * (float)this.conn.ps.getCurrFormatSetting())));
        return rs;
    }

    @Override
    public String setCurrent(float val) {
        float val2 = val;
        String readStr = this.conn.send("CURR" + this.conn.ps.getABCSelected() + String.format("%04d", (int)(val2 * (float)this.conn.ps.getCurrFormatSetting())));
        return readStr;
    }

    @Override
    public String setVoltage(float val) {
        String cmd = "VOLT" + this.conn.ps.getABCSelected() + String.format("%04d", (int)(val * (float)this.conn.ps.getVoltFormatSetting()));
        this.pscs.panWFG.tableSetting.setValueAt("" + val, 0, this.conn.ps.getABCSelected() + 1);
        return this.conn.send(cmd);
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        int intOutput = output ? 1 : 0;
        String line = this.conn.send("SOUT" + intOutput);
        if (line.indexOf("OK") < 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            line = this.conn.send("SOUT" + intOutput);
        }
        if ((line = this.conn.send("SETD" + String.format("%04d", (int)(volt * 100.0f)) + String.format("%04d", (int)(curr * 1000.0f)))).indexOf("OK") < 0) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            line = this.conn.send("SETD" + String.format("%04d", (int)(volt * 100.0f)) + String.format("%04d", (int)(curr * 1000.0f)));
        }
        if ((line = this.conn.send("SETD" + String.format("%04d", (int)(volt * 100.0f)) + String.format("%04d", (int)(curr * 1000.0f)))).indexOf("OK") >= 0) {
            this.conn.ps.setSetting(new PairVC(volt, curr));
            return "OK";
        }
        return "";
    }

    @Override
    public String setProgram() {
        return null;
    }

    @Override
    public String getProgram() {
        return null;
    }
}

