/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetKpsNep
implements CmdIntf {
    private _FrmPSCS pscs = _FrmPSCS.getIt();
    Connect conn = null;

    public CmdSetKpsNep(Connect connect) {
        this.conn = connect;
    }

    @Override
    public String getAll() {
        return "";
    }

    @Override
    public PairVC getMax() {
        PairVC vc = null;
        if (this.conn.ps.getModel().endsWith("6100")) {
            vc = new PairVC(18.5f, 11.0f);
        } else if (this.conn.ps.getModel().endsWith("6102")) {
            vc = new PairVC(36.5f, 5.5f);
        } else if (this.conn.ps.getModel().endsWith("6104")) {
            vc = new PairVC(60.5f, 3.0f);
        } else if (this.conn.ps.getModel().endsWith("6200")) {
            vc = new PairVC(18.5f, 21.0f);
        } else if (this.conn.ps.getModel().endsWith("6202")) {
            vc = new PairVC(36.5f, 11.0f);
        } else if (this.conn.ps.getModel().endsWith("6204")) {
            vc = new PairVC(60.5f, 5.5f);
        } else if (this.conn.ps.getModel().endsWith("6300")) {
            vc = new PairVC(16.5f, 31.0f);
        } else if (this.conn.ps.getModel().endsWith("6302")) {
            vc = new PairVC(32.5f, 16.0f);
        } else if (this.conn.ps.getModel().endsWith("6304")) {
            vc = new PairVC(60.5f, 9.0f);
        } else if (this.conn.ps.getModel().endsWith("6400")) {
            vc = new PairVC(16.5f, 41.0f);
        } else if (this.conn.ps.getModel().endsWith("6402")) {
            vc = new PairVC(32.5f, 21.0f);
        } else if (this.conn.ps.getModel().endsWith("6404")) {
            vc = new PairVC(60.5f, 11.0f);
        } else if (this.conn.ps.getModel().endsWith("6600")) {
            vc = new PairVC(16.5f, 61.0f);
        } else if (this.conn.ps.getModel().endsWith("6602")) {
            vc = new PairVC(32.5f, 31.0f);
        } else if (this.conn.ps.getModel().endsWith("6604")) {
            vc = new PairVC(60.5f, 16.0f);
        } else if (this.conn.ps.getModel().endsWith("8186")) {
            vc = new PairVC(18.5f, 6.1f);
        } else if (this.conn.ps.getModel().endsWith("8323")) {
            vc = new PairVC(32.5f, 3.75f);
        }
        return vc;
    }

    @Override
    public String getModel() {
        return null;
    }

    @Override
    public boolean getOutputIsOn() {
        try {
            String str = this.conn.send("OUTP?", 1);
            return str.startsWith("1");
        }
        catch (Exception e1) {
            return true;
        }
    }

    String getBit(String line, int idx, int len) {
        String val = line.substring(line.length() - idx - 1, line.length() - idx - 1 + len);
        return val;
    }

    @Override
    public String setCurrent(float val) {
        return this.conn.send("CURR " + val + "A");
    }

    @Override
    public String setKeyBoard(boolean lock) {
        if (lock) {
            return this.conn.send("SYST:REM");
        }
        return this.conn.send("SYST:LOC");
    }

    @Override
    public String setOutput(boolean outputOn) {
        this.conn.send(outputOn ? "OUTP ON" : "OUTP OFF");
        return this.conn.send("OUTP?").length() > 0 ? "OK" : "";
    }

    @Override
    public String setVoltage(float val) {
        this.conn.send("VOLT " + val + "V");
        return this.conn.send("VOLT?");
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        PairVCS vcs = new PairVCS();
        float v = 0.0f;
        float c = 0.0f;
        EnmCCCV cccv = EnmCCCV.CV;
        boolean outputOn = true;
        boolean isRun = false;
        String str = this.conn.send("SYST:STAT?", 19);
        try {
            str = str.replace("OK", "");
            String[] arr = str.split(",");
            if (arr.length > 0) {
                v = func.getFloat(arr[0]);
            }
            if (arr.length > 1) {
                c = func.getFloat(arr[1]);
            }
            if (arr.length > 2) {
                EnmCCCV enmCCCV = cccv = func.getInt(arr[2]) == 1 ? EnmCCCV.CC : EnmCCCV.CV;
            }
            if (arr.length > 3) {
                boolean bl = outputOn = func.getInt(arr[3]) == 1;
            }
            if (arr.length > 4) {
                boolean bl = isRun = func.getInt(arr[4]) == 1;
            }
            if (_FrmPSCS.getIt().getConnCurr().isRunningTableWFG != isRun) {
                _FrmPSCS.getIt().getConnCurr().isRunningTableWFG = isRun;
                if (_FrmPSCS.getIt().getConnCurr() == this.conn) {
                    this.pscs.refreshButsEnable();
                }
            }
            this.conn.ps.setOutput(outputOn);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        vcs.setVolt(v);
        vcs.setCurr(c);
        vcs.setCccv(cccv);
        return vcs;
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        this.conn.send("SYSTem:PRESet0 " + volt + "V," + curr + "A");
        if (output != this.conn.ps.getOutput()) {
            this.conn.send(output ? "OUTP ON" : "OUTP OFF");
        }
        this.conn.ps.setOutput(output);
        return "OK";
    }

    @Override
    public float getCurrentUppeLimit() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String val = this.conn.send("CURRent:LIMit?", "A");
        return func.getFloat(val);
    }

    @Override
    public float getVoltageUppeLimit() {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String val = this.conn.send("VOLTage:LIMit?", "V").replace("OK", "");
        return func.getFloat(val);
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send("CURRent:LIMit " + val + "A");
        return "OK";
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        try {
            Thread.sleep(20L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send("VOLTage:LIMit " + val + "V");
        return "OK";
    }

    @Override
    public PairVC getSetting() {
        float v = 0.0f;
        float c = 0.0f;
        String line = this.conn.send("VOLT?;CURR?", "A");
        String[] vc = (line = line.replace("OK", "")).split(";");
        if (vc.length == 2) {
            v = func.getFloat(vc[0]);
            c = func.getFloat(vc[1]);
        }
        return new PairVC(v, c);
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        String strV = this.conn.send("VOLT?");
        float v = strV.equals("") ? 0.0f : func.getFloat(strV) / 1000.0f;
        String strC = this.conn.send("CURR?");
        float c = strC.equals("") ? 0.0f : func.getFloat(strC) / 1000.0f;
        return new PairVC(v, c);
    }

    @Override
    public int getABCSelected() {
        return 0;
    }

    @Override
    public String getProgram() {
        boolean isITP_Runing = true;
        this.pscs.cpts.butSetVCO.setEnabled(!isITP_Runing);
        this.pscs.cpts.butERun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRead.setEnabled(!isITP_Runing);
        this.pscs.panITP.butISave.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIClear.setEnabled(!isITP_Runing);
        if (this.pscs.panUpdateFirmware != null) {
            this.pscs.panUpdateFirmware.setButUpdateFirmwareEnabled(!isITP_Runing);
        }
        if (this.pscs.panCalibration != null) {
            this.pscs.panCalibration.butPasswdEnter.setEnabled(!isITP_Runing);
        }
        Object[][] arr = new Object[3][11];
        arr[0][0] = String.valueOf(this.pscs.lang.getString("Lang_Voltage")) + "(V)";
        arr[1][0] = String.valueOf(this.pscs.lang.getString("Lang_Current")) + "(A)";
        arr[2][0] = String.valueOf(this.pscs.lang.getString("Lang_Time")) + "(S)";
        int intOK = 0;
        String lineAll = "";
        int i = 1;
        while (i <= 10) {
            String line = String.valueOf(this.conn.send("PROGram:DATA" + i + "?", "S")) + ";";
            lineAll = String.valueOf(lineAll) + line;
            ++i;
        }
        String[] arrLine = (lineAll = lineAll.replace(";;", ";")).split(";");
        if (arrLine.length >= 10) {
            int column = 1;
            while (column <= 10) {
                String line = arrLine[column - 1];
                String[] aa = line.split(",");
                if (aa.length >= 3) {
                    ++intOK;
                    float v = func.getFloat(aa[0]);
                    float c = func.getFloat(aa[1]);
                    int t = func.getInt(aa[2].replace("S", ""));
                    arr[0][column] = Float.valueOf(v);
                    arr[1][column] = Float.valueOf(c);
                    arr[2][column] = t;
                }
                ++column;
            }
        }
        this.conn.ps.setDataWfgSetting(arr);
        isITP_Runing = false;
        this.pscs.cpts.butSetVCO.setEnabled(!isITP_Runing);
        this.pscs.cpts.butERun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRead.setEnabled(!isITP_Runing);
        this.pscs.panITP.butISave.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIClear.setEnabled(!isITP_Runing);
        if (this.pscs.panUpdateFirmware != null) {
            this.pscs.panUpdateFirmware.setButUpdateFirmwareEnabled(!isITP_Runing);
        }
        if (this.pscs.panCalibration != null) {
            this.pscs.panCalibration.butPasswdEnter.setEnabled(!isITP_Runing);
        }
        return intOK == 10 ? "OK" : "";
    }

    @Override
    public String setProgram() {
        boolean isITP_Runing = true;
        this.pscs.cpts.butSetVCO.setEnabled(!isITP_Runing);
        this.pscs.cpts.butERun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRead.setEnabled(!isITP_Runing);
        this.pscs.panITP.butISave.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIClear.setEnabled(!isITP_Runing);
        if (this.pscs.panUpdateFirmware != null) {
            this.pscs.panUpdateFirmware.setButUpdateFirmwareEnabled(!isITP_Runing);
        }
        if (this.pscs.panCalibration != null) {
            this.pscs.panCalibration.butPasswdEnter.setEnabled(!isITP_Runing);
        }
        this.conn.send("PROG:SEC OFF");
        int row = 0;
        while (row < 20) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            String volt = this.pscs.panITP.tableITP.getValueAt(row, 1).toString();
            String curr = this.pscs.panITP.tableITP.getValueAt(row, 2).toString();
            String time = this.pscs.panITP.tableITP.getValueAt(row, 3).toString();
            String[] Arr = time.split(":");
            String timeSecond = Arr.length == 3 ? "" + (func.getInt(Arr[0]) * 3600 + func.getInt(Arr[1]) * 60 + func.getInt(Arr[2])) : "5";
            try {
                Thread.sleep(200L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.conn.send("PROG:DATA" + (row + 1) + " " + volt + "V," + curr + "A," + timeSecond + "S");
            ++row;
        }
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send("PROG:SAV");
        try {
            Thread.sleep(800L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.conn.send("PROG:SEC ON");
        isITP_Runing = false;
        this.pscs.cpts.butSetVCO.setEnabled(!isITP_Runing);
        this.pscs.cpts.butERun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRun.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIRead.setEnabled(!isITP_Runing);
        this.pscs.panITP.butISave.setEnabled(!isITP_Runing);
        this.pscs.panITP.butIClear.setEnabled(!isITP_Runing);
        if (this.pscs.panUpdateFirmware != null) {
            this.pscs.panUpdateFirmware.setButUpdateFirmwareEnabled(!isITP_Runing);
        }
        if (this.pscs.panCalibration != null) {
            this.pscs.panCalibration.butPasswdEnter.setEnabled(!isITP_Runing);
        }
        return "OK";
    }

    @Override
    public Object[][] getPresetMemory() {
        Object[][] arr = new Object[3][3];
        String readStr = this.conn.send("SYSTem:PRESet1?;PRESet2?;PRESet3?", 41);
        String[] aa = readStr.replaceAll(";", ",").split(",");
        if (aa.length >= 6) {
            float v = func.getFloat(aa[0]);
            float c = func.getFloat(aa[1]);
            boolean isSelect = this.conn.ps.getSetting().getVolt() == v && this.conn.ps.getSetting().getCurr() == c;
            arr[0][0] = isSelect;
            arr[0][1] = Float.valueOf(v);
            arr[0][2] = Float.valueOf(c);
            v = func.getFloat(aa[2]);
            c = func.getFloat(aa[3]);
            isSelect = this.conn.ps.getSetting().getVolt() == v && this.conn.ps.getSetting().getCurr() == c;
            arr[1][0] = isSelect;
            arr[1][1] = Float.valueOf(v);
            arr[1][2] = Float.valueOf(c);
            v = func.getFloat(aa[4]);
            c = func.getFloat(aa[5]);
            isSelect = this.conn.ps.getSetting().getVolt() == v && this.conn.ps.getSetting().getCurr() == c;
            arr[2][0] = isSelect;
            arr[2][1] = Float.valueOf(v);
            arr[2][2] = Float.valueOf(c);
        }
        this.conn.ps.setDataIPM(arr);
        return arr;
    }

    @Override
    public String setMemoryIndex(int index) {
        this.conn.send("SYSTem:PRESet" + index);
        return "OK";
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        this.conn.send("SYSTem:PRESet1 " + arr[0][1] + "V," + arr[0][2] + "A");
        this.conn.send("SYSTem:PRESet2 " + arr[1][1] + "V," + arr[1][2] + "A");
        this.conn.send("SYSTem:PRESet3 " + arr[2][1] + "V," + arr[2][2] + "A");
        return "OK";
    }
}

