/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.App;
import pscs.PairVC;
import pscs.PairVCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetHCS3xxx
implements CmdIntf {
    Connect conn = null;

    public CmdSetHCS3xxx(Connect connect) {
        this.conn = connect;
    }

    @Override
    public String getAll() {
        return null;
    }

    @Override
    public PairVC getMax() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GMAX");
        if (readStr.indexOf("OK") >= 6) {
            vc.setVolt(func.getFloat(readStr.substring(0, 3)) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(readStr.substring(3, 6)) / (float)this.conn.ps.getCurrFormatDisplay());
        }
        return vc;
    }

    @Override
    public String getModel() {
        return this.conn.send("GMOD");
    }

    @Override
    public boolean getOutputIsOn() {
        try {
            String str = this.conn.send("GOUT");
            return str.substring(0, 1).equals("0");
        }
        catch (Exception e1) {
            return true;
        }
    }

    @Override
    public Object[][] getPresetMemory() {
        Object[][] arr = new Object[3][3];
        String readStr = this.conn.send("GETM");
        if (readStr.length() > 18) {
            if (readStr.indexOf("OK") > 0) {
                arr[0][0] = false;
                arr[0][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(0, 3), this.conn.ps.getVoltFormatDisplay()));
                arr[0][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(3, 6), this.conn.ps.getCurrFormatDisplay()));
                arr[1][0] = false;
                arr[1][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(6, 9), this.conn.ps.getVoltFormatDisplay()));
                arr[1][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(9, 12), this.conn.ps.getCurrFormatDisplay()));
                arr[2][0] = false;
                arr[2][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(12, 15), this.conn.ps.getVoltFormatDisplay()));
                arr[2][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(15, 18), this.conn.ps.getCurrFormatDisplay()));
                return arr;
            }
            arr = null;
            return arr;
        }
        arr = null;
        return arr;
    }

    @Override
    public PairVC getSetting() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GETS");
        if (readStr.indexOf("OK") > 0) {
            try {
                vc.setVolt(App.getIt().futFloat(readStr.substring(0, 3)) / (float)this.conn.ps.getVoltFormatDisplay());
                vc.setCurr(App.getIt().futFloat(readStr.substring(3, 6)) / (float)this.conn.ps.getCurrFormatDisplay());
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return vc;
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        PairVCS vcs = new PairVCS();
        String readStr = this.conn.send("GETD");
        if (readStr.indexOf("OK") < 0) {
            readStr = this.conn.send("GETD");
        }
        try {
            vcs.setVolt(App.getIt().futFloat(readStr.substring(0, 4)) / 100.0f);
            if (this.conn.ps.getCurrFormatDisplay() == 10) {
                vcs.setCurr(App.getIt().futFloat(readStr.substring(4, 8)) / 100.0f);
            } else {
                vcs.setCurr(App.getIt().futFloat(readStr.substring(4, 8)) / 100.0f);
            }
            EnmCCCV cccv = null;
            if (readStr.substring(8, 9).equals("0")) {
                cccv = EnmCCCV.CV;
            }
            vcs.setCccv(cccv);
        }
        catch (Exception e1) {
            vcs = null;
        }
        return vcs;
    }

    @Override
    public float getCurrentUppeLimit() {
        return this.conn.ps.getMax().getCurr();
    }

    @Override
    public float getVoltageUppeLimit() {
        return this.conn.ps.getMax().getVolt();
    }

    @Override
    public String setCurrent(float val) {
        return this.conn.send("CURR" + String.format("%03d", (int)(val * (float)this.conn.ps.getCurrFormatDisplay())));
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        return "OK";
    }

    @Override
    public String setMemoryIndex(int index) {
        return this.conn.send("RUNM" + index);
    }

    @Override
    public String setKeyBoard(boolean lock) {
        if (lock) {
            return this.conn.send("SESS");
        }
        return this.conn.send("ENDS");
    }

    @Override
    public String setOutput(boolean outputOn) {
        if (outputOn) {
            return this.conn.send("SOUT0");
        }
        return this.conn.send("SOUT1");
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        String writeStr = "";
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[0][1]).floatValue() * (float)this.conn.ps.getVoltFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[0][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[1][1]).floatValue() * (float)this.conn.ps.getVoltFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[1][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[2][1]).floatValue() * (float)this.conn.ps.getVoltFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[2][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        return this.conn.send("PROM" + writeStr);
    }

    @Override
    public String setVoltage(float val) {
        return this.conn.send("VOLT" + String.format("%03d", (int)(val * 10.0f)));
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        String cmd = "SEVC" + String.format("%03d", (int)(volt * 10.0f)) + String.format("%03d", (int)(curr * (float)this.conn.ps.getCurrFormatDisplay()));
        cmd = this.conn.ps.getModel().startsWith("HCS") ? String.valueOf(cmd) + (output ? "0" : "1") : String.valueOf(cmd) + (output ? "1" : "0");
        return this.conn.send(cmd);
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        return "OK";
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        return null;
    }

    @Override
    public int getABCSelected() {
        return 0;
    }

    @Override
    public String setProgram() {
        return null;
    }

    @Override
    public String getProgram() {
        return null;
    }
}

