/*
 * Decompiled with CFR 0.152.
 */
package pscs.connect;

import pscs.App;
import pscs.PairVC;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.connect.CmdIntf;
import pscs.connect.Connect;
import pscs.enums.EnmCCCV;
import pscs.func;

public class CmdSetHCS2xxx
implements CmdIntf {
    _FrmPSCS pscs = _FrmPSCS.getIt();
    Connect conn = null;

    public CmdSetHCS2xxx(Connect connect) {
        this.conn = connect;
    }

    @Override
    public String getAll() {
        return null;
    }

    @Override
    public PairVC getMax() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GMAX");
        if (readStr.indexOf("OK") >= 6) {
            vc.setVolt(func.getFloat(readStr.substring(0, 3)) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(readStr.substring(3, 6)) / (float)this.conn.ps.getCurrFormatDisplay());
        }
        return vc;
    }

    @Override
    public String getModel() {
        return this.conn.send("GMOD");
    }

    @Override
    public boolean getOutputIsOn() {
        try {
            String str = this.conn.send("GOUT");
            return str.substring(0, 1).equals("0");
        }
        catch (Exception e1) {
            return true;
        }
    }

    @Override
    public Object[][] getPresetMemory() {
        Object[][] arr = new Object[3][2];
        String readStr = this.conn.send("GETM");
        if (readStr.length() > 18) {
            if (readStr.indexOf("OK") > 0) {
                arr[0][0] = false;
                arr[0][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(0, 3), 10));
                arr[0][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(3, 6), this.conn.ps.getCurrFormatDisplay()));
                arr[1][0] = false;
                arr[1][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(6, 9), 10));
                arr[1][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(9, 12), this.conn.ps.getCurrFormatDisplay()));
                arr[2][0] = false;
                arr[2][1] = Float.valueOf(App.getIt().futFloat(readStr.substring(12, 15), 10));
                arr[2][2] = Float.valueOf(App.getIt().futFloat(readStr.substring(15, 18), this.conn.ps.getCurrFormatDisplay()));
                return arr;
            }
            arr = null;
            return arr;
        }
        arr = null;
        return arr;
    }

    @Override
    public PairVC getSetting() {
        PairVC vc = new PairVC();
        String readStr = this.conn.send("GETS");
        if (readStr.indexOf("OK") > 0) {
            vc.setVolt(func.getFloat(readStr.substring(0, 3)) / (float)this.conn.ps.getVoltFormatDisplay());
            vc.setCurr(func.getFloat(readStr.substring(3, 6)) / (float)this.conn.ps.getCurrFormatDisplay());
        }
        return vc;
    }

    @Override
    public PairVCS getVoltageAndCurrentAndStatus() {
        PairVCS vcs = new PairVCS();
        String readStr = this.conn.send("GETD");
        if (readStr.indexOf("OK") < 0) {
            readStr = this.conn.send("GETD");
        }
        try {
            vcs.setVolt(func.getFloat(readStr.substring(0, 3)) / 10.0f);
            if (this.conn.ps.getCurrFormatDisplay() == 10) {
                vcs.setCurr(func.getFloat(readStr.substring(4, 7)) / (float)this.conn.ps.getCurrFormatDisplay());
            } else {
                vcs.setCurr(func.getFloat(readStr.substring(4, 8)) / (float)this.conn.ps.getCurrFormatDisplay());
            }
            EnmCCCV cccv = null;
            if (readStr.substring(8, 9).equals("0")) {
                cccv = EnmCCCV.CV;
            }
            vcs.setCccv(cccv);
        }
        catch (Exception e1) {
            vcs = null;
        }
        return vcs;
    }

    @Override
    public float getCurrentUppeLimit() {
        String str = this.conn.send("GOCP");
        if (str.indexOf("OK") > 0) {
            return func.getFloat(str.substring(0, 3)) / (float)this.conn.ps.getCurrFormatDisplay();
        }
        return 0.0f;
    }

    @Override
    public float getVoltageUppeLimit() {
        String str = this.conn.send("GOVP");
        if (str.indexOf("OK") > 0) {
            return func.getFloat(str.substring(0, 3)) / 10.0f;
        }
        return 0.0f;
    }

    @Override
    public String setCurrent(float val) {
        return this.conn.send("CURR" + String.format("%03d", (int)(val * (float)this.conn.ps.getCurrFormatDisplay())));
    }

    @Override
    public String setCurrentUppeLimit(float val) {
        return this.conn.send("SOCP" + String.format("%03d", (int)(val * (float)this.conn.ps.getCurrFormatDisplay())));
    }

    @Override
    public String setMemoryIndex(int index) {
        return this.conn.send("RUNM" + index);
    }

    @Override
    public String setKeyBoard(boolean lock) {
        if (lock) {
            return this.conn.send("SESS");
        }
        return this.conn.send("ENDS");
    }

    @Override
    public String setOutput(boolean outputOn) {
        if (outputOn) {
            return this.conn.send("SOUT0");
        }
        return this.conn.send("SOUT1");
    }

    @Override
    public String setPresetMemory(Object[][] arr) {
        String writeStr = "";
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[0][1]).floatValue() * 10.0f));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[0][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[1][1]).floatValue() * 10.0f));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[1][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[2][1]).floatValue() * 10.0f));
        writeStr = String.valueOf(writeStr) + String.format("%03d", (int)(((Float)arr[2][2]).floatValue() * (float)this.conn.ps.getCurrFormatDisplay()));
        return this.conn.send("PROM" + writeStr);
    }

    @Override
    public String setVoltage(float val) {
        return this.conn.send("VOLT" + String.format("%03d", (int)(val * 10.0f)));
    }

    @Override
    public String setVoltageCurrentOutput(float volt, float curr, boolean output) {
        String cmd = "SEVC" + String.format("%03d", (int)(volt * 10.0f)) + String.format("%03d", (int)(curr * (float)this.conn.ps.getCurrFormatDisplay())) + (output ? "1" : "0");
        return this.conn.send(cmd);
    }

    @Override
    public String setVoltageUppeLimit(float val) {
        return this.conn.send("SOVP" + String.format("%03d", (int)(val * 10.0f)));
    }

    @Override
    public PairVC getSetting(int abcSelectIndex) {
        return null;
    }

    @Override
    public int getABCSelected() {
        return 0;
    }

    @Override
    public String setProgram() {
        return null;
    }

    @Override
    public String getProgram() {
        return null;
    }
}

