/*
 * Decompiled with CFR 0.152.
 */
package pscs.calibration;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import pscs.App;
import pscs.MyButton;
import pscs.PairVCS;
import pscs._FrmPSCS;
import pscs.calibration.DialogClear0;
import pscs.calibration.DialogClearAuxNTP8;
import pscs.connect.Connect;
import pscs.enums.EnmSerial;
import pscs.enums.EnmVC;
import pscs.func;
import pscs.rw;

public class PanCalibration
extends JPanel
implements ActionListener {
    private static final long serialVersionUID = 1L;
    public JTable tableV = null;
    public JTable tableC = null;
    public DefaultTableModel dtmV = null;
    public DefaultTableModel dtmC = null;
    JLabel labRebootPress = new JLabel("");
    JTextField txtInput = new JTextField(10);
    private Connect conn = null;
    JLabel labInput;
    public MyButton butNext;
    public MyButton butStartCalibration;
    public MyButton butStartCancel;
    public MyButton butCancel;
    public MyButton butAuxClear0;
    public MyButton butFinish;
    public MyButton butPasswdEnter;
    public MyButton butPasswdChange;
    public MyButton butRecovery;
    int column = 2;
    CardLayout layoutCard = new CardLayout();
    JPanel panCards = new JPanel(this.layoutCard);
    JPanel panCardPage0EnterPasswd = new JPanel();
    JPanel panCardPage1Setting_CSR = new JPanel();
    JPanel panCardPage2Calibration = new JPanel();
    JPanel panCardPage3RebootPress = new JPanel();
    private _FrmPSCS pscs = _FrmPSCS.getIt();

    public PanCalibration() {
        this.setName("CAL");
        this.labInput = new JLabel(this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
        this.butNext = new MyButton(this.pscs.lang.getString("Lang_Next"));
        this.butStartCalibration = new MyButton(this.pscs.lang.getString("Lang_Start_calibration"));
        this.butStartCancel = new MyButton(this.pscs.lang.getString("Lang_Cancel"));
        this.butCancel = new MyButton(this.pscs.lang.getString("Lang_Cancel"));
        this.butAuxClear0 = new MyButton(this.pscs.lang.getString("Lang_Ammeter_Clear"));
        this.butFinish = new MyButton(this.pscs.lang.getString("Lang_Finish"));
        this.butPasswdEnter = new MyButton(this.pscs.lang.getString("Lang_Enter_Password"));
        this.butPasswdChange = new MyButton(this.pscs.lang.getString("Lang_Change_Password"));
        this.butRecovery = new MyButton(this.pscs.lang.getString("Lang_Recovery_Default"));
        this.initUI();
    }

    protected void initUI() {
        this.setLayout(new BorderLayout());
        JPanel panCenter = new JPanel(new BorderLayout());
        JPanel panCenterVC = new JPanel(new GridLayout(1, 2));
        JPanel panTxtBut = new JPanel();
        JPanel panSartFinish = new JPanel();
        Object[] fieldsV = new String[]{this.pscs.lang.getString("Lang_Step"), String.valueOf(this.pscs.lang.getString("Lang_Setting")) + "(V)", this.pscs.lang.getString("Lang_Output")};
        Object[] fieldsC = new String[]{this.pscs.lang.getString("Lang_Step"), String.valueOf(this.pscs.lang.getString("Lang_Setting")) + "(A)", this.pscs.lang.getString("Lang_Output")};
        Object[][] dataV = new Object[][]{{1}, {2}, {3}, {4}};
        Object[][] dataC = new Object[][]{{1}, {2}, {3}, {4}};
        this.panCardPage0EnterPasswd.add(this.butPasswdEnter);
        this.panCardPage1Setting_CSR.add(this.butPasswdChange);
        this.panCardPage1Setting_CSR.add(this.butRecovery);
        this.panCardPage1Setting_CSR.add(this.butAuxClear0);
        this.panCardPage1Setting_CSR.add(this.butStartCalibration);
        this.panCardPage1Setting_CSR.add(this.butStartCancel);
        this.panCardPage2Calibration.add(panSartFinish);
        this.panCardPage3RebootPress.add(this.labRebootPress);
        this.panCards.add((Component)this.panCardPage0EnterPasswd, "page0");
        this.panCards.add((Component)this.panCardPage1Setting_CSR, "page1");
        this.panCards.add((Component)this.panCardPage2Calibration, "page2");
        this.panCards.add((Component)this.panCardPage3RebootPress, "page3");
        this.layoutCard.show(this.panCards, "page0");
        this.dtmV = new DefaultTableModel(dataV, fieldsV);
        this.dtmC = new DefaultTableModel(dataC, fieldsC);
        this.tableV = new JTable(this.dtmV){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        this.tableC = new JTable(this.dtmC){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        DefaultTableCellRenderer r = new DefaultTableCellRenderer();
        r.setHorizontalAlignment(0);
        this.tableV.setDefaultRenderer(Object.class, r);
        this.tableC.setDefaultRenderer(Object.class, r);
        this.tableV.setGridColor(this.pscs.app.gridLineColor);
        this.tableV.setShowGrid(true);
        this.tableC.setGridColor(this.pscs.app.gridLineColor);
        this.tableC.setShowGrid(true);
        panTxtBut.setPreferredSize(new Dimension(40, 40));
        this.labInput.setVisible(false);
        this.txtInput.setVisible(false);
        this.butNext.setVisible(false);
        this.butNext.setEnabled(false);
        this.butCancel.setVisible(false);
        this.butAuxClear0.setVisible(false);
        this.butFinish.setVisible(false);
        panCenterVC.add(new JScrollPane(this.tableV));
        panCenterVC.add(new JScrollPane(this.tableC));
        panTxtBut.add(this.labInput);
        panTxtBut.add(this.txtInput);
        panTxtBut.add(this.butNext);
        panCenter.add(panCenterVC);
        panCenter.add((Component)panTxtBut, "South");
        panSartFinish.add(this.butCancel);
        panSartFinish.add(this.butFinish);
        this.add(panCenter);
        this.add((Component)this.panCards, "South");
        this.listener();
    }

    protected void listener() {
        this.butNext.addActionListener(this);
        this.butStartCalibration.addActionListener(this);
        this.butStartCancel.addActionListener(this);
        this.butCancel.addActionListener(this);
        this.butAuxClear0.addActionListener(this);
        this.butFinish.addActionListener(this);
        this.butPasswdEnter.addActionListener(this);
        this.butPasswdChange.addActionListener(this);
        this.butRecovery.addActionListener(this);
        this.txtInput.getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                PanCalibration.this.butNext.setEnabled(PanCalibration.this.txtInput.getText().trim().length() > 0);
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                PanCalibration.this.butNext.setEnabled(PanCalibration.this.txtInput.getText().trim().length() > 0);
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                PanCalibration.this.butNext.setEnabled(PanCalibration.this.txtInput.getText().trim().length() > 0);
            }
        });
        this.tableV.getColumn(this.tableV.getColumnName(this.column)).setCellRenderer(new ColumnRenderer());
        this.tableC.getColumn(this.tableC.getColumnName(this.column)).setCellRenderer(new ColumnRenderer());
    }

    public Connect getConnect() {
        return this.conn;
    }

    public void setConnect(Connect conn) {
        this.conn = conn;
        if (conn.ps.getSerial() == EnmSerial.KPS) {
            this.setInitTableDataKPS();
        }
    }

    private Float getLevelVC(EnmVC vc) {
        Float pv = null;
        while (true) {
            func.sleep(1000L);
            PairVCS vcs = this.conn.cmdSet.getVoltageAndCurrentAndStatus();
            System.out.println(vcs);
            if (vcs == null) {
                return pv;
            }
            if (pv == null) {
                pv = Float.valueOf(vc == EnmVC.VOLT ? vcs.getVolt() : vcs.getCurr());
                func.sleep(1000L);
                continue;
            }
            if (vc == EnmVC.VOLT) {
                if (pv.floatValue() == vcs.getVolt()) break;
                pv = Float.valueOf(vcs.getVolt());
                continue;
            }
            if (pv.floatValue() == vcs.getCurr()) break;
            pv = Float.valueOf(vcs.getCurr());
        }
        return pv;
    }

    void doStart() {
        if (this.tableV.getRowCount() == 0 || this.tableV.getRowCount() == 0) {
            return;
        }
        int re = JOptionPane.showConfirmDialog(null, this.pscs.lang.getString("Lang_Confirm_Calibration"), null, 0);
        if (re == 1) {
            return;
        }
        this.layoutCard.show(this.panCards, "page2");
        this.conn.isRunerAutoAccess = false;
        this.conn.ps.setCalibration(true);
        this.pscs.lcd.repaint();
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        String line = null;
        if (this.conn.ps.getSerial() == EnmSerial.SDP3) {
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.dtmV.setRowCount(0);
            int rowCountV = func.getInt(this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:VOLT:NUMS?"));
            int row22 = 0;
            while (row22 < rowCountV) {
                Object[] obj = new Object[]{row22 + 1};
                this.dtmV.addRow(obj);
                ++row22;
            }
            try {
                Thread.sleep(50L);
            }
            catch (InterruptedException row22) {
                // empty catch block
            }
            this.dtmC.setRowCount(0);
            int rowCountC = func.getInt(this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:CURR:NUMS?"));
            int row = 0;
            while (row < rowCountC) {
                Object[] obj = new Object[]{row + 1};
                this.dtmC.addRow(obj);
                ++row;
            }
            this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "OUTP ON");
            this.conn.ps.setOutput(true);
            this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:SEC OFF");
            this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:VOLT:LEV P1");
            line = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:VOLT:DATA? 1");
            String[] arr = line.split(",");
            this.tableV.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(arr[0]) / 1000.0f), 0, 1);
            this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT " + func.getFloat(this.tableV.getValueAt(0, 1).toString()) + "V");
            this.butStartCalibration.setVisible(false);
            this.labInput.setVisible(true);
            this.txtInput.setVisible(true);
            this.butNext.setVisible(true);
            this.butCancel.setVisible(true);
            this.tableV.setValueAt("?", 0, this.column);
            this.txtInput.setText(func.getDecimalFormat(1000).format(func.getFloat(arr[1]) / 1000.0f));
            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
            this.txtInput.requestFocus();
        } else if (this.conn.ps.getSerial() == EnmSerial.KPS) {
            this.conn.send("OUTP ON");
            this.conn.ps.setOutput(true);
            this.conn.send("CAL ON");
            this.conn.send("CAL?");
            float f = func.getFloat(this.tableV.getValueAt(0, 1));
            this.conn.send("CAL:VOLT1 " + func.getFormat(f, 3) + "V,0V");
            this.butStartCalibration.setVisible(false);
            this.labInput.setVisible(true);
            this.txtInput.setVisible(true);
            this.butNext.setVisible(true);
            this.butCancel.setVisible(true);
            this.tableV.setValueAt("?", 0, this.column);
            this.txtInput.setText(func.getDecimalFormat(1000).format(f));
            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
            this.txtInput.requestFocus();
        } else if (this.conn.ps.getSerial() == EnmSerial.NTP) {
            func.sleep(100L);
            if (this.conn.ps.getModel().startsWith("NTP5") || this.conn.ps.getModel().startsWith("NTP6")) {
                this.dtmV.setRowCount(2);
                this.dtmC.setRowCount(2);
                this.tableV.setValueAt(null, 0, 1);
                this.tableV.setValueAt(null, 0, 2);
                this.tableV.setValueAt(null, 1, 1);
                this.tableV.setValueAt(null, 1, 2);
                this.tableC.setValueAt(null, 0, 1);
                this.tableC.setValueAt(null, 0, 2);
                this.tableC.setValueAt(null, 1, 1);
                this.tableC.setValueAt(null, 1, 2);
            } else if (this.conn.ps.getModel().startsWith("NTP8")) {
                System.out.println("NTP8xxx model: " + this.conn.ps.getModel());
                if (this.conn.ps.getModel().endsWith("21")) {
                    this.dtmV.setRowCount(3);
                    this.dtmC.setRowCount(5);
                } else if (this.conn.ps.getModel().endsWith("31")) {
                    this.dtmV.setRowCount(5);
                    this.dtmC.setRowCount(4);
                } else if (this.conn.ps.getModel().endsWith("61")) {
                    this.dtmV.setRowCount(5);
                    this.dtmC.setRowCount(3);
                }
                int r = 0;
                while (r < this.tableV.getRowCount()) {
                    this.tableV.setValueAt(r + 1, r, 0);
                    if (this.conn.ps.getModel().endsWith("31") && r == this.tableV.getRowCount() - 1) {
                        this.tableV.setValueAt(35.0, r, 1);
                    } else {
                        this.tableV.setValueAt(r == 0 ? 1.0 : 1.0 * (double)r * 10.0, r, 1);
                    }
                    this.tableV.setValueAt(null, r, 2);
                    ++r;
                }
                r = 0;
                while (r < this.tableC.getRowCount()) {
                    this.tableC.setValueAt(r + 1, r, 0);
                    this.tableC.setValueAt(r == 0 ? 0.1 : 1.0 * (double)r, r, 1);
                    this.tableC.setValueAt(null, r, 2);
                    ++r;
                }
                if (this.conn.ps.getModel().endsWith("61")) {
                    this.tableV.setValueAt(55.0, this.tableV.getRowCount() - 1, 1);
                    this.tableC.setValueAt(1.5, 2, 1);
                }
            }
            if (this.conn.ps.getModel().startsWith("NTP8")) {
                this.conn.send("CANCEL_PRO", "OK");
                func.sleep(100L);
                this.conn.send("CANCEL_SVOC", "OK");
                func.sleep(100L);
                this.conn.send("CANCEL_SCOC", "OK");
                func.sleep(100L);
                this.conn.send("CANCEL_COMP", "OK");
                func.sleep(100L);
                this.labInput.setText("Please connect the load 0.005A CC model and restart the power supply.");
                this.labInput.setVisible(true);
                this.txtInput.setVisible(false);
                this.butNext.setVisible(true);
                this.butNext.setEnabled(true);
                this.butCancel.setVisible(true);
                this.butAuxClear0.setVisible(true);
            } else {
                this.labInput.setText("Please apply loading 0.005A and then click the \"Next\" to calibrate the voltage.");
                this.labInput.setVisible(true);
                this.txtInput.setVisible(false);
                this.butNext.setVisible(true);
                this.butNext.setEnabled(true);
                this.butCancel.setVisible(true);
                this.butAuxClear0.setVisible(true);
            }
        } else if (this.conn.send("ENCC").indexOf("OK") >= 0) {
            this.conn.send("RVCP");
            try {
                Thread.sleep(600L);
            }
            catch (InterruptedException r) {
                // empty catch block
            }
            line = this.conn.send("GEVP");
            if (line.indexOf("OK") >= 16) {
                float f;
                int row = 0;
                while (row < this.tableV.getRowCount()) {
                    f = func.getFloat(line.substring(row * 4, row * 4 + 4)) / 100.0f;
                    this.tableV.setValueAt(this.pscs.df2.format(f), row, 1);
                    this.tableV.setValueAt(null, row, 2);
                    ++row;
                }
                line = this.conn.send("GECP");
                if (line.indexOf("OK") >= 16) {
                    row = 0;
                    while (row < this.tableC.getRowCount()) {
                        f = func.getFloat(line.substring(row * 4, row * 4 + 4)) / 100.0f;
                        this.tableC.setValueAt(this.pscs.df2.format(f), row, 1);
                        this.tableC.setValueAt(null, row, 2);
                        ++row;
                    }
                    line = this.conn.send("SCAL");
                    if (line.indexOf("VOL") >= 0) {
                        this.butStartCalibration.setVisible(false);
                        this.labInput.setVisible(true);
                        this.txtInput.setVisible(true);
                        this.butNext.setVisible(true);
                        this.butCancel.setVisible(true);
                        this.butAuxClear0.setVisible(this.conn.ps.getSerial() == EnmSerial.NTP);
                        this.tableV.setValueAt("?", 0, this.column);
                        this.txtInput.setText(this.tableV.getValueAt(0, 1).toString());
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                        this.txtInput.requestFocus();
                    }
                }
            }
        }
    }

    void doNext() {
        if (this.conn.ps.getModel() == null) {
            return;
        }
        float f = func.getFloat(this.txtInput.getText());
        String strf = String.format("%04d", (int)(f * 100.0f));
        if (this.conn.ps.getSerial() == EnmSerial.NTP) {
            if (this.conn.ps.getModel().startsWith("NTP8")) {
                if (this.tableV.getValueAt(0, 2) == null) {
                    if (this.conn.send("SOUT1", "OK").endsWith("OK")) {
                        float volt = func.getFloat(this.tableV.getValueAt(0, 1));
                        this.conn.send("VOLT" + String.format("%04d", func.getInt(Float.valueOf(volt * 100.0f))));
                        this.butStartCalibration.setVisible(false);
                        this.tableV.setValueAt("?", 0, this.column);
                        this.txtInput.setVisible(true);
                        this.txtInput.setText(func.getDecimalFormat(1000).format(volt));
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                        this.txtInput.requestFocus();
                    }
                    return;
                }
                if (this.tableV.getValueAt(this.tableV.getRowCount() - 1, 2) != null && this.tableV.getValueAt(this.tableV.getRowCount() - 1, 2).equals("?")) {
                    float d = func.getFloat(this.txtInput.getText());
                    String v = func.getFormatStr(func.getInt(Float.valueOf(d * 1000.0f)), 5);
                    String str = this.conn.send("SVOC" + v, "OK");
                    if (str.endsWith("OK")) {
                        this.tableV.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), this.tableV.getRowCount() - 1, this.column);
                        this.conn.send("OVER_SVOC");
                        float curr = func.getFloat(this.tableC.getValueAt(0, 1));
                        this.conn.send("CURR" + String.format("%04d", func.getInt(Float.valueOf(curr * 1000.0f))));
                        this.tableC.setValueAt("?", 0, this.column);
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                        this.txtInput.setText(func.getFormat(this.tableC.getValueAt(0, 1), 3));
                        this.txtInput.setVisible(true);
                    }
                    return;
                }
            } else {
                if (this.tableV.getValueAt(0, 2) == null) {
                    if (this.conn.send("SCALMODE4321", "OK").endsWith("OK") && this.conn.send("SVOC", "OK").startsWith("OK") && this.conn.send("SPRO0", "OK").endsWith("OK")) {
                        float volt = this.getLevelVC(EnmVC.VOLT).floatValue();
                        this.tableV.setValueAt(Float.valueOf(volt), 0, 1);
                        this.tableV.setValueAt("?", 0, 2);
                        this.butStartCalibration.setVisible(false);
                        this.tableV.setValueAt("?", 0, this.column);
                        this.txtInput.setVisible(true);
                        this.txtInput.setText(func.getDecimalFormat(1000).format(volt));
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                        this.txtInput.requestFocus();
                    }
                    return;
                }
                if (this.tableC.getValueAt(0, 1) == null && this.tableV.getValueAt(1, 2) != null && !this.tableV.getValueAt(1, 2).equals("?")) {
                    this.conn.send("SCOC");
                    this.tableC.setValueAt(this.getLevelVC(EnmVC.CURR), 0, 1);
                    this.tableC.setValueAt("?", 0, this.column);
                    this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                    this.txtInput.setText(func.getFormat(this.tableC.getValueAt(0, 1), 3));
                    this.txtInput.setVisible(true);
                    return;
                }
            }
        }
        int row = 0;
        while (row < this.tableV.getRowCount()) {
            if (this.tableV.getValueAt(row, this.column) != null && this.tableV.getValueAt(row, this.column).equals("?")) {
                if (this.conn.ps.getSerial() == EnmSerial.SDP3) {
                    this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:VOLT " + (int)(func.getFloat(this.txtInput.getText()) * 1000.0f) + "mV");
                    this.tableV.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                    if (row < this.tableV.getRowCount() - 1) {
                        this.tableV.setValueAt("?", row + 1, this.column);
                        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:VOLT:LEV P" + (row + 2));
                        String line = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:VOLT:DATA? " + (row + 2));
                        String[] arr = line.split(",");
                        this.tableV.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(arr[0]) / 1000.0f), row + 1, 1);
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                        this.txtInput.setText(func.getDecimalFormat(1000).format(func.getFloat(arr[1]) / 1000.0f));
                        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT " + func.getFloat(this.tableV.getValueAt(row + 1, 1).toString()) + "V");
                    } else {
                        this.tableC.setValueAt("?", 0, this.column);
                        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "VOLT 5V");
                        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:CURR:LEV P1");
                        String line = this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CAL:CURR:DATA? 1");
                        String[] arr = line.split(",");
                        this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(arr[0]) / 1000.0f), 0, 1);
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                        this.txtInput.setText(func.getDecimalFormat(1000).format(func.getFloat(arr[1]) / 1000.0f));
                        this.conn.send(String.valueOf(this.conn.getConnInfo().getRs485StrSDP3()) + "CURR " + func.getFloat(this.tableC.getValueAt(0, 1).toString()) + "A");
                    }
                } else if (this.conn.ps.getSerial() == EnmSerial.KPS) {
                    String line = this.conn.send("CAL?");
                    this.tableV.setValueAt(func.getFormat(this.txtInput.getText(), 3), row, this.column);
                    if (row < this.tableV.getRowCount() - 1) {
                        this.conn.send("CAL:VOLT2 " + this.tableV.getValueAt(row + 1, 1).toString() + "V," + f + "V");
                        this.txtInput.setText(func.getFormat(this.tableV.getValueAt(row + 1, 1), 3));
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                        this.tableV.setValueAt("?", row + 1, this.column);
                    } else {
                        this.conn.send("CAL:VOLT3 0V," + f + "V");
                        this.conn.send("CAL?");
                        this.conn.send("VOLT 5V");
                        this.conn.send("CAL:CURR7 0A,0A");
                        this.conn.send("CAL?");
                        this.conn.send("CAL:CURR4 " + this.tableC.getValueAt(0, 1).toString() + "A,0A");
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                        this.txtInput.setText(func.getFormat(this.tableC.getValueAt(0, 1), 3));
                        this.tableC.setValueAt("?", 0, this.column);
                    }
                } else if (this.conn.ps.getSerial() == EnmSerial.NTP) {
                    if (this.conn.ps.getModel().startsWith("NTP8")) {
                        this.tableV.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                        float d = func.getFloat(this.txtInput.getText());
                        String v = func.getFormatStr(func.getInt(Float.valueOf(d * 1000.0f)), 5);
                        String str = this.conn.send("SVOC" + v, "OK");
                        if (str.endsWith("OK")) {
                            if (row < this.tableV.getRowCount() - 1) {
                                d = func.getFloat(this.txtInput.getText());
                                float volt = func.getFloat(this.tableV.getValueAt(row + 1, 1));
                                this.conn.send("VOLT" + String.format("%04d", func.getInt(Float.valueOf(volt * 100.0f))));
                                this.txtInput.setText(func.getDecimalFormat(1000).format(volt));
                                this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                                this.tableV.setValueAt("?", row + 1, this.column);
                            } else {
                                func.sleep(100L);
                                this.labInput.setText("Please connect the load set voltage of output to 21V and click the Next to calibration current.");
                                this.txtInput.setVisible(false);
                            }
                        }
                    } else {
                        this.tableV.setValueAt(this.txtInput.getText(), row, this.column);
                        float d = func.getFloat(this.txtInput.getText());
                        String v = func.getFormatStr(func.getInt(Float.valueOf(d * 1000.0f)), 5);
                        if (row < this.tableV.getRowCount() - 1) {
                            this.conn.send("SVOL" + v);
                            this.tableV.setValueAt(this.getLevelVC(EnmVC.VOLT), row + 1, 1);
                            this.txtInput.setText(func.getFormat(this.tableV.getValueAt(row + 1, 1), 3));
                            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                            this.tableV.setValueAt("?", row + 1, this.column);
                        } else {
                            this.conn.send("SVOH" + v);
                            func.sleep(100L);
                            this.labInput.setText("Please set Electronic load to C.R. mode and set load to 3\u03a9.");
                            this.txtInput.setVisible(false);
                        }
                    }
                } else {
                    String line = this.conn.send("CALV" + strf);
                    if (line.indexOf("VOL?") >= 0 || line.indexOf("CUR?") >= 0) {
                        this.tableV.setValueAt(this.txtInput.getText(), row, this.column);
                        if (row < this.tableV.getRowCount() - 1) {
                            this.tableV.setValueAt("?", row + 1, this.column);
                            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Voltage(V)"));
                            this.txtInput.setText(this.tableV.getValueAt(row + 1, 1).toString());
                        } else {
                            this.tableC.setValueAt("?", 0, this.column);
                            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + 1 + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                            this.txtInput.setText(this.tableC.getValueAt(0, 1).toString());
                        }
                    }
                }
                this.txtInput.requestFocus();
                return;
            }
            ++row;
        }
        row = 0;
        while (row < this.tableC.getRowCount()) {
            if (this.tableC.getValueAt(row, this.column) != null && this.tableC.getValueAt(row, this.column).equals("?")) {
                if (this.conn.ps.getSerial() == EnmSerial.SDP3) {
                    this.conn.send("CAL:CURR " + (int)(func.getFloat(this.txtInput.getText()) * 1000.0f) + "mA");
                    if (row < this.tableC.getRowCount() - 1) {
                        this.conn.send("CAL:CURR:LEV P" + (row + 2));
                        String line = this.conn.send("CAL:CURR:DATA? " + (row + 2));
                        String[] arr = line.split(",");
                        this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(arr[0]) / 1000.0f), row + 1, 1);
                        this.conn.send("CURR " + func.getFloat(this.tableC.getValueAt(row + 1, 1).toString()) + "A");
                        this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                        this.tableC.setValueAt("?", row + 1, this.column);
                        this.txtInput.setText(func.getDecimalFormat(1000).format(func.getFloat(arr[1]) / 1000.0f));
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                        this.txtInput.requestFocus();
                    } else {
                        this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                        this.labInput.setVisible(false);
                        this.txtInput.setText(null);
                        this.txtInput.setVisible(false);
                        this.butNext.setVisible(false);
                        this.butCancel.setVisible(false);
                        this.butAuxClear0.setVisible(false);
                        this.butFinish.setVisible(true);
                    }
                } else if (this.conn.ps.getSerial() == EnmSerial.KPS) {
                    String line = this.conn.send("CAL?");
                    this.tableC.setValueAt(func.getFormat(this.txtInput.getText(), 3), row, this.column);
                    if (row < this.tableC.getRowCount() - 1) {
                        this.conn.send("CAL:CURR5 " + this.tableC.getValueAt(row + 1, 1).toString() + "A, " + f + "A");
                        this.txtInput.setText(func.getFormat(this.tableC.getValueAt(row + 1, 1), 3));
                        this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                        this.tableC.setValueAt("?", row + 1, this.column);
                        this.txtInput.requestFocus();
                    } else {
                        this.conn.send("CAL:CURR6 0A, " + f + "A");
                        this.conn.send("CAL?");
                        this.conn.send("CAL:CURR7 0A,0A");
                        this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                        this.labInput.setVisible(false);
                        this.txtInput.setText(null);
                        this.txtInput.setVisible(false);
                        this.butNext.setVisible(false);
                        this.butCancel.setVisible(false);
                        this.butAuxClear0.setVisible(false);
                        this.butFinish.setVisible(true);
                    }
                } else if (this.conn.ps.getSerial() == EnmSerial.NTP) {
                    if (this.conn.ps.getModel().startsWith("NTP8")) {
                        this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                        float d = func.getFloat(this.txtInput.getText());
                        String v = func.getFormatStr(func.getInt(Float.valueOf(d * 1000.0f)), 4);
                        this.conn.send("SCOC" + v);
                        if (row < this.tableC.getRowCount() - 1) {
                            d = func.getFloat(this.txtInput.getText());
                            float curr = func.getFloat(this.tableC.getValueAt(row + 1, 1));
                            this.conn.send("CURR" + String.format("%04d", func.getInt(Float.valueOf(curr * 1000.0f))));
                            this.txtInput.setText(func.getDecimalFormat(1000).format(curr));
                            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                            this.tableC.setValueAt("?", row + 1, this.column);
                            this.txtInput.requestFocus();
                        } else {
                            func.sleep(100L);
                            this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                            this.conn.send("OVER_SCOC");
                            this.labInput.setVisible(false);
                            this.txtInput.setText(null);
                            this.txtInput.setVisible(false);
                            this.butNext.setVisible(false);
                            this.butCancel.setVisible(false);
                            this.butAuxClear0.setVisible(false);
                            this.butFinish.setVisible(true);
                        }
                    } else {
                        this.tableC.setValueAt(this.txtInput.getText(), row, this.column);
                        float d = func.getFloat(this.txtInput.getText());
                        String v = func.getFormatStr(func.getInt(Float.valueOf(d * 1000.0f)), 5);
                        if (row < this.tableC.getRowCount() - 1) {
                            this.conn.send("SCOL" + v);
                            this.tableC.setValueAt(this.getLevelVC(EnmVC.CURR), row + 1, 1);
                            this.txtInput.setText(func.getFormat(this.tableC.getValueAt(row + 1, 1), 3));
                            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                            this.tableC.setValueAt("?", row + 1, this.column);
                            this.txtInput.requestFocus();
                        } else {
                            this.conn.send("SCOH" + v);
                            func.sleep(1200L);
                            this.getLevelVC(EnmVC.CURR);
                            this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                            this.labInput.setVisible(false);
                            this.txtInput.setText(null);
                            this.txtInput.setVisible(false);
                            this.butNext.setVisible(false);
                            this.butCancel.setVisible(false);
                            this.butAuxClear0.setVisible(false);
                            this.butFinish.setVisible(true);
                        }
                    }
                } else {
                    String line = this.conn.send("CALC" + strf);
                    if (line.indexOf("CUR?") >= 0 || line.indexOf("DONE") >= 0) {
                        this.tableC.setValueAt(func.getDecimalFormat(1000).format(func.getFloat(this.txtInput.getText())), row, this.column);
                        if (row < this.tableC.getRowCount() - 1) {
                            this.tableC.setValueAt("?", row + 1, this.column);
                            this.txtInput.setText(this.tableC.getValueAt(row + 1, 1).toString());
                            this.labInput.setText(String.valueOf(this.pscs.lang.getString("Lang_Step")) + (row + 2) + ": " + this.pscs.lang.getString("Lang_Input_actual_Current(A)"));
                            this.txtInput.requestFocus();
                        } else {
                            this.labInput.setVisible(false);
                            this.txtInput.setText(null);
                            this.txtInput.setVisible(false);
                            this.butNext.setVisible(false);
                            this.butCancel.setVisible(false);
                            this.butAuxClear0.setVisible(false);
                            this.butFinish.setVisible(true);
                        }
                    }
                }
                return;
            }
            ++row;
        }
    }

    void doFinishOrCancel(Object source) {
        if (this.conn.ps.getSerial() == EnmSerial.SDP3) {
            if (this.butFinish == source) {
                this.conn.send("CAL:SAV");
            }
        } else if (this.conn.ps.getSerial() == EnmSerial.KPS) {
            this.conn.send("CAL OFF");
            func.sleep(1000L);
            func.sleep(1000L);
        } else if (this.conn.ps.getSerial() == EnmSerial.NTP) {
            if (this.conn.ps.getModel().startsWith("NTP8")) {
                if (this.butFinish == source || this.butCancel == source) {
                    if (this.butCancel == source) {
                        this.conn.send("CANCEL_SVOC", "OK");
                        func.sleep(100L);
                        this.conn.send("CANCEL_SCOC", "OK");
                        func.sleep(100L);
                        this.conn.send("CANCEL_COMP", "OK");
                    }
                    this.conn.send("PRO", "OK");
                }
            } else if (this.butFinish == source || this.butCancel == source) {
                this.conn.send("SPRO1");
            }
        } else {
            this.conn.send("RSET");
        }
        this.labInput.setVisible(false);
        this.txtInput.setText(null);
        this.txtInput.setVisible(false);
        this.butNext.setVisible(false);
        this.butStartCalibration.setVisible(true);
        this.butCancel.setVisible(false);
        this.butAuxClear0.setVisible(false);
        this.butFinish.setVisible(false);
        this.conn.isRunerAutoAccess = true;
        this.conn.ps.setCalibration(false);
        this.page3RebootStart("reboot");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.butStartCalibration.equals(e.getSource())) {
            this.doStart();
        } else if (this.butStartCancel.equals(e.getSource())) {
            this.layoutCard.show(this.panCards, "page0");
        } else if (this.butNext.equals(e.getSource())) {
            this.doNext();
        } else if (this.butPasswdEnter.equals(e.getSource())) {
            JPasswordField txtPasswd = new JPasswordField();
            Object[] message = new Object[]{this.pscs.lang.getString("Lang_Enter_Password"), txtPasswd};
            if (JOptionPane.showConfirmDialog(null, message, this.pscs.lang.getString("Lang_Enter_Password"), 2, -1) == 0) {
                String dbPasswd;
                String strPasswd = String.valueOf(txtPasswd.getPassword());
                if (strPasswd.equals(dbPasswd = rw.getPasswd())) {
                    this.setConnect(this.pscs.getConnCurr());
                    this.layoutCard.show(this.panCards, "page1");
                    this.butRecovery.setVisible(this.conn.ps.getSerial() != EnmSerial.KPS);
                    this.butAuxClear0.setVisible(this.conn.ps.getSerial() == EnmSerial.NTP);
                } else {
                    JOptionPane.showMessageDialog(null, this.pscs.lang.getString("Lang_Password_error"), this.pscs.lang.getString("Lang_Enter_Password"), 0);
                }
            }
        } else if (this.butPasswdChange.equals(e.getSource())) {
            JPasswordField txtNewPasswd = new JPasswordField();
            JPasswordField txtReNewPasswd = new JPasswordField();
            Object[] message = new Object[]{this.pscs.lang.getString("Lang_Enter_new_password"), txtNewPasswd, this.pscs.lang.getString("Lang_Re-enter_new_password"), txtReNewPasswd};
            if (JOptionPane.showConfirmDialog(null, message, this.pscs.lang.getString("Lang_Change_Password"), 2, -1) == 0) {
                String strNewPasswd = String.valueOf(txtNewPasswd.getPassword());
                String strReNewPasswd = String.valueOf(txtReNewPasswd.getPassword());
                if (strNewPasswd != null && strNewPasswd.length() > 0 && strNewPasswd.equals(strReNewPasswd)) {
                    rw.setPasswd(strNewPasswd);
                } else {
                    JOptionPane.showMessageDialog(null, this.pscs.lang.getString("Lang_Password_error"), this.pscs.lang.getString("Lang_Change_Password"), 0);
                }
            }
        } else if (this.butRecovery.equals(e.getSource())) {
            this.page3RebootStart("recoveryAndReboot");
        } else if (this.butAuxClear0.equals(e.getSource())) {
            if (this.conn.ps.getModel().startsWith("NTP8")) {
                new DialogClearAuxNTP8(true, this.conn).setVisible(true);
            } else {
                new DialogClear0(true, this.conn).setVisible(true);
            }
        } else if (this.butFinish.equals(e.getSource()) || this.butCancel.equals(e.getSource())) {
            this.doFinishOrCancel(e.getSource());
        }
    }

    private void page3RebootStart(final String p) {
        new Thread(new Runnable(){

            @Override
            public void run() {
                PanCalibration.this.layoutCard.show(PanCalibration.this.panCards, "page3");
                ((PanCalibration)PanCalibration.this).conn.isRunerAutoAccess = false;
                ((PanCalibration)PanCalibration.this).conn.ps.setCalibration(true);
                if (p.equals("recoveryAndReboot")) {
                    PanCalibration.this.labRebootPress.setText(String.valueOf(((PanCalibration)PanCalibration.this).pscs.lang.getString("Lang_Recovery")) + "...");
                    ((PanCalibration)PanCalibration.this).pscs.lcd.repaint();
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (((PanCalibration)PanCalibration.this).conn.ps.getSerial() == EnmSerial.SDP3) {
                        PanCalibration.this.conn.send("CAL:INIT SYSTEM");
                    } else {
                        PanCalibration.this.conn.send("ENCC");
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PanCalibration.this.conn.send("RVCP");
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        PanCalibration.this.conn.send("RSET");
                        try {
                            Thread.sleep(20L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (((PanCalibration)PanCalibration.this).conn.ps.getSerial() != EnmSerial.NTP) {
                    long t = new Date().getTime();
                    long rebootTimeMS = App.getIt().rebootTimeMS;
                    long b = 0L;
                    if (((PanCalibration)PanCalibration.this).conn.ps.getSerial() == EnmSerial.KPS) {
                        rebootTimeMS = 1000L;
                    }
                    while (rebootTimeMS - b > 0L) {
                        int remain = (int)(rebootTimeMS - b) / 1000;
                        PanCalibration.this.labRebootPress.setText(String.valueOf(((PanCalibration)PanCalibration.this).pscs.lang.getString("Lang_The_machine_is_rebooting")) + " (" + remain + "s)");
                        b = new Date().getTime() - t;
                        try {
                            TimeUnit.MILLISECONDS.sleep(200L);
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }
                PanCalibration.this.labRebootPress.setText("");
                ((PanCalibration)PanCalibration.this).conn.isRunerAutoAccess = true;
                ((PanCalibration)PanCalibration.this).conn.ps.setCalibration(false);
                PanCalibration.this.layoutCard.show(PanCalibration.this.panCards, "page0");
            }
        }).start();
    }

    private void setInitTableDataKPS() {
        if (this.tableV.getRowCount() != 6) {
            this.dtmV.setRowCount(6);
            this.dtmC.setRowCount(6);
            int i = 1;
            while (i <= this.dtmV.getRowCount()) {
                this.dtmV.setValueAt(i, i - 1, 0);
                this.dtmC.setValueAt(i, i - 1, 0);
                ++i;
            }
            String t = func.getTitle(this.conn);
            this.dtmV.setValueAt(1.0, 0, 1);
            this.dtmV.setValueAt(3.3, 1, 1);
            if (t.indexOf("16V") > 0) {
                this.dtmV.setValueAt(5.0, 2, 1);
                this.dtmV.setValueAt(8.0, 3, 1);
                this.dtmV.setValueAt(11.0, 4, 1);
                this.dtmV.setValueAt(15.0, 5, 1);
            } else if (t.indexOf("18V") > 0) {
                this.dtmV.setValueAt(5.0, 2, 1);
                this.dtmV.setValueAt(10.0, 3, 1);
                this.dtmV.setValueAt(16.0, 4, 1);
                this.dtmV.setValueAt(17.0, 5, 1);
            } else if (t.indexOf("32V") > 0) {
                this.dtmV.setValueAt(5.0, 2, 1);
                this.dtmV.setValueAt(15.0, 3, 1);
                this.dtmV.setValueAt(22.0, 4, 1);
                this.dtmV.setValueAt(31.0, 5, 1);
            } else if (t.indexOf("36V") > 0) {
                this.dtmV.setValueAt(8.0, 2, 1);
                this.dtmV.setValueAt(15.0, 3, 1);
                this.dtmV.setValueAt(25.0, 4, 1);
                this.dtmV.setValueAt(36.0, 5, 1);
            } else if (t.indexOf("60V") > 0) {
                this.dtmV.setValueAt(10.0, 2, 1);
                this.dtmV.setValueAt(25.0, 3, 1);
                this.dtmV.setValueAt(40.0, 4, 1);
                this.dtmV.setValueAt(60.0, 5, 1);
            }
            if (t.indexOf(" 3A") > 0) {
                this.dtmC.setValueAt(0.5, 0, 1);
                this.dtmC.setValueAt(0.8, 1, 1);
                this.dtmC.setValueAt(1.0, 2, 1);
                this.dtmC.setValueAt(1.5, 3, 1);
                this.dtmC.setValueAt(2.0, 4, 1);
                this.dtmC.setValueAt(2.5, 5, 1);
            } else if (t.indexOf(" 5A") > 0) {
                this.dtmC.setValueAt(0.5, 0, 1);
                this.dtmC.setValueAt(1.0, 1, 1);
                this.dtmC.setValueAt(2.0, 2, 1);
                this.dtmC.setValueAt(3.0, 3, 1);
                this.dtmC.setValueAt(4.0, 4, 1);
                this.dtmC.setValueAt(5.0, 5, 1);
            } else if (t.indexOf(" 8A") > 0) {
                this.dtmC.setValueAt(0.5, 0, 1);
                this.dtmC.setValueAt(1.0, 1, 1);
                this.dtmC.setValueAt(3.0, 2, 1);
                this.dtmC.setValueAt(5.0, 3, 1);
                this.dtmC.setValueAt(7.0, 4, 1);
                this.dtmC.setValueAt(8.5, 5, 1);
            } else if (t.indexOf(" 10A") > 0) {
                this.dtmC.setValueAt(0.5, 0, 1);
                this.dtmC.setValueAt(1.0, 1, 1);
                this.dtmC.setValueAt(3.0, 2, 1);
                this.dtmC.setValueAt(5.0, 3, 1);
                this.dtmC.setValueAt(7.0, 4, 1);
                this.dtmC.setValueAt(9.0, 5, 1);
            } else if (t.indexOf(" 15A") > 0) {
                this.dtmC.setValueAt(0.8, 0, 1);
                this.dtmC.setValueAt(1.6, 1, 1);
                this.dtmC.setValueAt(5.0, 2, 1);
                this.dtmC.setValueAt(8.0, 3, 1);
                this.dtmC.setValueAt(11.0, 4, 1);
                this.dtmC.setValueAt(14.0, 5, 1);
            } else if (t.indexOf(" 20A") > 0) {
                this.dtmC.setValueAt(0.8, 0, 1);
                this.dtmC.setValueAt(1.2, 1, 1);
                this.dtmC.setValueAt(3.0, 2, 1);
                this.dtmC.setValueAt(5.0, 3, 1);
                this.dtmC.setValueAt(15.0, 4, 1);
                this.dtmC.setValueAt(19.0, 5, 1);
            } else if (t.indexOf(" 30A") > 0) {
                this.dtmC.setValueAt(1.0, 0, 1);
                this.dtmC.setValueAt(6.0, 1, 1);
                this.dtmC.setValueAt(12.0, 2, 1);
                this.dtmC.setValueAt(18.0, 3, 1);
                this.dtmC.setValueAt(24.0, 4, 1);
                this.dtmC.setValueAt(29.0, 5, 1);
            } else if (t.indexOf(" 40A") > 0) {
                this.dtmC.setValueAt(2.0, 0, 1);
                this.dtmC.setValueAt(10.0, 1, 1);
                this.dtmC.setValueAt(18.0, 2, 1);
                this.dtmC.setValueAt(26.0, 3, 1);
                this.dtmC.setValueAt(34.0, 4, 1);
                this.dtmC.setValueAt(38.0, 5, 1);
            }
        }
    }

    class ColumnRenderer
    extends DefaultTableCellRenderer {
        float flo1;
        private static final long serialVersionUID = 1L;

        ColumnRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setHorizontalAlignment(0);
            if (value != null) {
                String strVal = value.toString();
                this.setForeground(strVal.equals("?") ? Color.RED : Color.BLACK);
            }
            return super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        }
    }
}

