/*
 * Decompiled with CFR 0.152.
 */
package pscs.bean;

import pscs.enums.EnmBeanConnectType;
import pscs.enums.EnmSerial;
import pscs.func;

public class BeanConnectInfo {
    private String name = null;
    private String model = null;
    private String description = null;
    private EnmBeanConnectType enmBeanConnectType = null;
    private String remoteip = null;
    private Integer remoteport = null;
    private String commPort = null;
    private EnmSerial serial;
    private int rs485id = 0;
    private String rs485Str = "00";

    public BeanConnectInfo() {
    }

    public BeanConnectInfo(String name, String model, String description, EnmBeanConnectType enmBeanConnectType, String remoteip, Integer remoteport, String commPort, Integer rs485id) {
        this.name = name;
        this.setModel(model);
        this.description = description;
        this.enmBeanConnectType = enmBeanConnectType;
        this.remoteip = remoteip;
        this.remoteport = remoteport;
        this.commPort = commPort;
        this.rs485id = rs485id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getModel() {
        return this.model;
    }

    public void setModel(String model) {
        if (model == null) {
            this.serial = null;
        } else {
            String m = model.replace("-", "").toUpperCase();
            if (m.startsWith("HCS2")) {
                this.serial = EnmSerial.HCS2;
            } else if (m.startsWith("HCS3")) {
                this.serial = EnmSerial.HCS3;
            } else if (m.startsWith("KPS")) {
                this.serial = EnmSerial.KPS;
            } else if (m.startsWith("NEP")) {
                this.serial = EnmSerial.NEP;
            } else if (m.startsWith("NTP")) {
                this.serial = EnmSerial.NTP;
            } else if (m.startsWith("SDP2210O") || m.startsWith("SDP2405O") || m.startsWith("SDP2603O")) {
                this.serial = EnmSerial.SDP2old;
            } else if (m.startsWith("SDP2")) {
                this.serial = EnmSerial.SDP2new;
            } else if (m.startsWith("SDP3")) {
                this.serial = EnmSerial.SDP3;
            } else if (m.startsWith("SSP80")) {
                this.serial = EnmSerial.SSP8080;
            } else if (m.startsWith("SSP8")) {
                this.serial = EnmSerial.SSP8XXX;
            } else if (m.startsWith("SSP9")) {
                this.serial = EnmSerial.SSP9;
            }
        }
        this.model = model;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public EnmBeanConnectType getBeanConnectType() {
        return this.enmBeanConnectType;
    }

    public void setBeanConnectType(EnmBeanConnectType enmBeanConnectType) {
        this.enmBeanConnectType = enmBeanConnectType;
        this.setRs485id(this.rs485id);
    }

    public String getRemoteIp() {
        return this.remoteip;
    }

    public void setRemoteIp(String remoteip) {
        this.remoteip = remoteip;
    }

    public Integer getRemotePort() {
        return this.remoteport;
    }

    public void setRemotePort(Integer remoteport) {
        this.remoteport = remoteport;
    }

    public String getCommPort() {
        return this.commPort;
    }

    public void setCommPort(String commPort) {
        this.commPort = commPort;
    }

    public int getRs485id() {
        return this.rs485id;
    }

    public void setRs485id(int rs485id) {
        this.rs485id = rs485id;
        int id = rs485id > 256 ? 256 : rs485id;
        int l = id / 16;
        int r = id % 16;
        String ff = "123456789:;<=>?0";
        String sl = l == 0 ? "0" : ff.substring(l - 1, l);
        String sr = r == 0 ? "0" : ff.substring(r - 1, r);
        this.rs485Str = String.valueOf(sl) + sr;
    }

    public EnmSerial getSerial() {
        return this.serial;
    }

    public String toString() {
        return "Name:" + this.name + "\t" + "Model:" + this.model + "\t" + "ConnectType:" + (Object)((Object)this.enmBeanConnectType) + "\t" + "IP:" + this.remoteip + "\t" + "Port:" + this.remoteport + "\t" + "COMM:" + this.commPort + "\t" + "RS485:" + this.rs485id + "\t" + "Serial";
    }

    public boolean setConnectNew(BeanConnectInfo ci) {
        boolean isNewConn = false;
        if (this.getBeanConnectType() == ci.getBeanConnectType()) {
            if (this.getBeanConnectType() == EnmBeanConnectType.USB) {
                isNewConn = !this.getCommPort().equals(ci.getCommPort());
            } else if (this.getBeanConnectType() == EnmBeanConnectType.Ethernet) {
                isNewConn = !this.getRemoteIp().equals(ci.getRemoteIp()) || this.getRemotePort() != ci.getRemotePort();
            } else if (this.getBeanConnectType() == EnmBeanConnectType.RS485 && this.getCommPort().equals(ci.getCommPort()) && this.getRs485id() == ci.getRs485id()) {
                isNewConn = true;
            }
        } else {
            isNewConn = true;
        }
        this.setName(ci.getName());
        this.setDescription(ci.getDescription());
        this.setBeanConnectType(ci.getBeanConnectType());
        this.setRemoteIp(ci.getRemoteIp());
        this.setRemotePort(ci.getRemotePort());
        this.setCommPort(ci.getCommPort());
        this.setRs485id(ci.getRs485id());
        return isNewConn;
    }

    public String getLineWrite() {
        String line = this.getName();
        line = String.valueOf(line) + "|" + this.getDescription();
        line = String.valueOf(line) + "|" + (Object)((Object)this.getBeanConnectType());
        line = String.valueOf(line) + "|" + (this.getRemoteIp() == null || this.getRemoteIp().equals("null") ? "" : this.getRemoteIp());
        line = String.valueOf(line) + "|" + this.getRemotePort();
        line = String.valueOf(line) + "|" + this.getCommPort();
        line = String.valueOf(line) + "|" + this.rs485id;
        return line;
    }

    public String getRs485Str() {
        return this.rs485Str;
    }

    public String getRs485StrSDP3() {
        if (this.enmBeanConnectType == null) {
            return "";
        }
        if (this.rs485id == 0) {
            return "";
        }
        if (this.enmBeanConnectType == EnmBeanConnectType.RS485) {
            return func.asciiToString("" + this.rs485id);
        }
        return "";
    }
}

