/*
 * Decompiled with CFR 0.152.
 */
package pscs;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.ParseException;
import java.util.Date;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.SpinnerDateModel;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.AbstractTableModel;
import pscs.App;
import pscs.CellEditor_HMS;
import pscs.CellEditor_TxtSli;
import pscs.MyButton;
import pscs._FrmPSCS;
import pscs.func;
import pscs.publics.CellRendererITP;

public class PanInternalTimedProgram
extends JPanel {
    private static final long serialVersionUID = 1L;
    Object[][] tableETP_data = null;
    String[] tableITP_FieldName = new String[]{"Step", "Voltage(V)", "Current(A)", "Time"};
    public JTable tableITP = null;
    public MyButton butIRun = new MyButton("Run");
    public MyButton butIClear = new MyButton("Clear Table");
    public MyButton butIRead = new MyButton("Read From PS");
    public MyButton butISave = new MyButton("Save To PS");
    JSlider sliCell = new JSlider(0, 0, 100, 0);
    JPopupMenu pop = new JPopupMenu();
    JPopupMenu popTime = new JPopupMenu();
    SpinnerDateModel sdmHMS = new SpinnerDateModel();
    JSpinner spnHMS = null;
    JSpinner.DateEditor sjde = null;
    _FrmPSCS pscs = null;
    int hourLast = 0;

    public PanInternalTimedProgram(_FrmPSCS pscs) {
        this.setName("ITP");
        this.pscs = pscs;
        this.tableETP_data = new Object[][]{{"1", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"2", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"3", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"4", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"5", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"6", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"7", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"8", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"9", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"10", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"11", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"12", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"13", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"14", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"15", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"16", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"17", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"18", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"19", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}, {"20", App.getIt().numberFormat1.format(0.0), App.getIt().numberFormat1.format(0.0), "0:00:00"}};
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(10, 10, 10, 10));
        this.initUI();
    }

    protected void initUI() {
        this.sliCell.setOpaque(false);
        this.pop.setBackground(Color.WHITE);
        this.pop.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.pop.add(this.sliCell);
        this.popTime.setBorder(new EmptyBorder(0, 0, 0, 0));
        Date dt = null;
        try {
            dt = this.pscs.timeFormat.parse("0:00:00");
        }
        catch (ParseException e1) {
            e1.printStackTrace();
        }
        this.sdmHMS.setValue(dt);
        this.spnHMS = new JSpinner(this.sdmHMS);
        this.sjde = new JSpinner.DateEditor(this.spnHMS, "H:mm:ss");
        this.spnHMS.setEditor(this.sjde);
        this.spnHMS.setPreferredSize(new Dimension(75, 22));
        this.popTime.add(this.spnHMS);
        TableModelE tableETP_dtm = new TableModelE();
        this.tableITP = new JTable(tableETP_dtm);
        this.tableITP.getColumnModel().getColumn(1).setCellEditor(new CellEditor_TxtSli());
        this.tableITP.getColumnModel().getColumn(2).setCellEditor(new CellEditor_TxtSli());
        this.tableITP.getColumnModel().getColumn(3).setCellEditor(new CellEditor_HMS());
        this.tableITP.getColumnModel().getColumn(0).setMaxWidth(60);
        this.tableITP.getColumnModel().getColumn(3).setMaxWidth(80);
        this.tableITP.setRowSelectionAllowed(false);
        this.tableITP.setRowHeight(20);
        this.tableITP.setGridColor(this.pscs.app.gridLineColor);
        this.tableITP.setShowGrid(true);
        int i = 0;
        while (i < this.tableITP.getColumnCount()) {
            this.tableITP.getColumn(this.tableITP.getColumnName(i)).setCellRenderer(new CellRendererITP());
            ++i;
        }
        JPanel palButtonTab = new JPanel(new BorderLayout());
        palButtonTab.setBorder(new EmptyBorder(10, 30, 0, 30));
        JPanel palButtonTab1R_W = new JPanel(new FlowLayout(0, 0, 0));
        JPanel palButtonTab1R_C = new JPanel(new FlowLayout(0, 20, 0));
        JPanel palButtonTab1R_E = new JPanel(new FlowLayout(2, 0, 0));
        palButtonTab1R_W.add(this.butIRun);
        palButtonTab1R_C.add(this.butIRead);
        palButtonTab1R_C.add(this.butISave);
        palButtonTab1R_E.add((Component)this.butIClear, "East");
        palButtonTab.add((Component)palButtonTab1R_W, "West");
        palButtonTab.add(palButtonTab1R_C);
        palButtonTab.add((Component)palButtonTab1R_E, "East");
        this.refreshLanguage();
        this.add(new JScrollPane(this.tableITP));
        this.add((Component)palButtonTab, "South");
        this.listener();
    }

    protected void listener() {
        this.sliCell.addChangeListener(new MyChangeListener());
        this.spnHMS.addChangeListener(new MyChangeListener());
        this.butIRun.addActionListener(new MyActionListener());
        this.butIRead.addActionListener(new MyActionListener());
        this.butISave.addActionListener(new MyActionListener());
        this.butIClear.addActionListener(new MyActionListener());
        this.tableITP.getModel().addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent e) {
                func.checkValidDataOfTableITP(PanInternalTimedProgram.this.pscs);
                PanInternalTimedProgram.this.pscs.refreshButsEnable();
            }
        });
    }

    public void refreshLanguage() {
        this.tableITP_FieldName[0] = this.pscs.lang.getString("Lang_Step");
        this.tableITP_FieldName[1] = String.valueOf(this.pscs.lang.getString("Lang_Voltage")) + "(V)";
        this.tableITP_FieldName[2] = String.valueOf(this.pscs.lang.getString("Lang_Current")) + "(A)";
        this.tableITP_FieldName[3] = this.pscs.lang.getString("Lang_Time");
        this.tableITP.getColumnModel().getColumn(0).setHeaderValue(this.tableITP_FieldName[0]);
        this.tableITP.getColumnModel().getColumn(1).setHeaderValue(this.tableITP_FieldName[1]);
        this.tableITP.getColumnModel().getColumn(2).setHeaderValue(this.tableITP_FieldName[2]);
        this.tableITP.getColumnModel().getColumn(3).setHeaderValue(this.tableITP_FieldName[3]);
        if (this.pscs.getConnCurr() == null || !this.pscs.getConnCurr().isTableItpValidData) {
            this.butIRun.setText(this.pscs.lang.getString("Lang_Run"));
        } else {
            this.butIRun.setText(this.pscs.lang.getString("Lang_Stop"));
        }
        this.butIRead.setText(this.pscs.lang.getString("Lang_Read_From_PS"));
        this.butISave.setText(this.pscs.lang.getString("Lang_Save_To_PS"));
        this.butIClear.setText(this.pscs.lang.getString("Lang_Clear_Table"));
    }

    class MyActionListener
    implements ActionListener {
        MyActionListener() {
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            if (arg0.getSource().equals(PanInternalTimedProgram.this.butIRun)) {
                PanInternalTimedProgram.this.pscs.getConnCurr().isRunITP = true;
            } else if (arg0.getSource().equals(PanInternalTimedProgram.this.butIRead)) {
                this.clearTable();
                PanInternalTimedProgram.this.pscs.getConnCurr().isReadProgram = true;
                PanInternalTimedProgram.this.pscs.setCptsIPM(PanInternalTimedProgram.this.pscs.getConnCurr());
            } else if (arg0.getSource().equals(PanInternalTimedProgram.this.butISave)) {
                PanInternalTimedProgram.this.pscs.getConnCurr().isSaveProgram = true;
            } else if (arg0.getSource().equals(PanInternalTimedProgram.this.butIClear)) {
                this.clearTable();
                PanInternalTimedProgram.this.pscs.cpts.txtDescI.setText("");
            }
        }

        void clearTable() {
            int i = 0;
            while (i < 20) {
                PanInternalTimedProgram.this.tableITP.setValueAt(Float.valueOf(0.0f), i, 1);
                PanInternalTimedProgram.this.tableITP.setValueAt(Float.valueOf(0.0f), i, 2);
                PanInternalTimedProgram.this.tableITP.setValueAt("0:00:00", i, 3);
                ++i;
            }
            PanInternalTimedProgram.this.tableITP.repaint();
        }
    }

    class MyChangeListener
    implements ChangeListener {
        MyChangeListener() {
        }

        @Override
        public void stateChanged(ChangeEvent arg0) {
            if (arg0.getSource().equals(PanInternalTimedProgram.this.sliCell)) {
                if (PanInternalTimedProgram.this.tableITP.getSelectedColumn() == 1) {
                    float f1 = (float)((JSlider)arg0.getSource()).getValue() / (float)PanInternalTimedProgram.this.pscs.getConnCurr().ps.getVoltFormatSetting();
                    String s = func.getDecimalFormat(PanInternalTimedProgram.this.pscs.getConnCurr().ps.getVoltFormatSetting()).format(f1);
                    PanInternalTimedProgram.this.tableITP.setValueAt(s, PanInternalTimedProgram.this.tableITP.getSelectedRow(), PanInternalTimedProgram.this.tableITP.getSelectedColumn());
                } else if (PanInternalTimedProgram.this.tableITP.getSelectedColumn() == 2) {
                    float f1 = (float)((JSlider)arg0.getSource()).getValue() / (float)PanInternalTimedProgram.this.pscs.getConnCurr().ps.getCurrFormatSetting();
                    String s = func.getDecimalFormat(PanInternalTimedProgram.this.pscs.getConnCurr().ps.getCurrFormatSetting()).format(f1);
                    PanInternalTimedProgram.this.tableITP.setValueAt(s, PanInternalTimedProgram.this.tableITP.getSelectedRow(), PanInternalTimedProgram.this.tableITP.getSelectedColumn());
                }
            } else {
                int r = PanInternalTimedProgram.this.tableITP.getSelectedRow();
                int c = PanInternalTimedProgram.this.tableITP.getSelectedColumn();
                String str1 = "";
                Date date1 = (Date)PanInternalTimedProgram.this.spnHMS.getValue();
                int h = date1.getHours();
                if (h > 9) {
                    str1 = PanInternalTimedProgram.this.hourLast == 0 ? "0:00:00" : "9:59:59";
                } else {
                    str1 = PanInternalTimedProgram.this.pscs.timeFormat.format(date1);
                    if (str1.equals("12:00:00")) {
                        str1 = "0:00:00";
                    }
                }
                PanInternalTimedProgram.this.tableITP.setValueAt(str1, r, c);
                Date date2 = null;
                try {
                    date2 = PanInternalTimedProgram.this.pscs.timeFormat.parse(str1);
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
                PanInternalTimedProgram.this.sdmHMS.setValue(date2);
                PanInternalTimedProgram.this.spnHMS = new JSpinner(PanInternalTimedProgram.this.sdmHMS);
                PanInternalTimedProgram.this.hourLast = func.getInt(str1.substring(0, 1));
            }
        }
    }

    class TableModelE
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;

        TableModelE() {
        }

        @Override
        public int getColumnCount() {
            return PanInternalTimedProgram.this.tableITP_FieldName.length;
        }

        @Override
        public int getRowCount() {
            return PanInternalTimedProgram.this.tableETP_data.length;
        }

        @Override
        public String getColumnName(int col) {
            return PanInternalTimedProgram.this.tableITP_FieldName[col];
        }

        @Override
        public Object getValueAt(int row, int col) {
            return PanInternalTimedProgram.this.tableETP_data[row][col];
        }

        public Class getColumnClass(int c) {
            return this.getValueAt(0, c).getClass();
        }

        @Override
        public boolean isCellEditable(int row, int col) {
            return col > 0;
        }

        @Override
        public void setValueAt(Object value, int row, int col) {
            PanInternalTimedProgram.this.tableETP_data[row][col] = value;
            this.fireTableCellUpdated(row, col);
        }
    }

    class fgMouseListener
    implements MouseListener {
        fgMouseListener() {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
            int i;
            if (arg0.getClickCount() == 2 && (i = PanInternalTimedProgram.this.tableITP.getSelectedColumn()) > 0 && i < PanInternalTimedProgram.this.tableITP.getColumnCount()) {
                if (i == 1 || i == 2) {
                    float val = func.getFloat(PanInternalTimedProgram.this.tableITP.getValueAt(PanInternalTimedProgram.this.tableITP.getSelectedRow(), PanInternalTimedProgram.this.tableITP.getSelectedColumn()).toString());
                    if (i == 1) {
                        PanInternalTimedProgram.this.sliCell.setMaximum((int)(PanInternalTimedProgram.this.pscs.getConnCurr().ps.getUwl().getVolt() * (float)PanInternalTimedProgram.this.pscs.getConnCurr().ps.getVoltFormatDisplay()));
                        PanInternalTimedProgram.this.sliCell.setValue((int)(val * (float)PanInternalTimedProgram.this.pscs.getConnCurr().ps.getVoltFormatDisplay()));
                    } else {
                        PanInternalTimedProgram.this.sliCell.setMaximum((int)(PanInternalTimedProgram.this.pscs.getConnCurr().ps.getUwl().getCurr() * (float)PanInternalTimedProgram.this.pscs.getConnCurr().ps.getCurrFormatDisplay()));
                        PanInternalTimedProgram.this.sliCell.setValue((int)(val * (float)PanInternalTimedProgram.this.pscs.getConnCurr().ps.getCurrFormatDisplay()));
                    }
                    int r = PanInternalTimedProgram.this.tableITP.getSelectedRow();
                    int c = PanInternalTimedProgram.this.tableITP.getSelectedColumn();
                    PanInternalTimedProgram.this.sliCell.setPreferredSize(new Dimension((int)PanInternalTimedProgram.this.tableITP.getCellRect(r, c, true).getWidth() - 41, 16));
                    PanInternalTimedProgram.this.pop.show(PanInternalTimedProgram.this.tableITP, (int)PanInternalTimedProgram.this.tableITP.getCellRect(r, c, true).getX() + 40, (int)PanInternalTimedProgram.this.tableITP.getCellRect(r, c, true).getY() + 1);
                } else if (i == 3) {
                    Date dt = null;
                    int r = PanInternalTimedProgram.this.tableITP.getSelectedRow();
                    int c = PanInternalTimedProgram.this.tableITP.getSelectedColumn();
                    try {
                        dt = PanInternalTimedProgram.this.pscs.timeFormat.parse(PanInternalTimedProgram.this.tableITP.getValueAt(r, c).toString());
                        PanInternalTimedProgram.this.sdmHMS.setValue(dt);
                        PanInternalTimedProgram.this.spnHMS = new JSpinner(PanInternalTimedProgram.this.sdmHMS);
                        PanInternalTimedProgram.this.spnHMS.setEditor(new JSpinner.DateEditor(PanInternalTimedProgram.this.spnHMS, "H:mm:ss"));
                        PanInternalTimedProgram.this.popTime.show(PanInternalTimedProgram.this.tableITP, (int)PanInternalTimedProgram.this.tableITP.getCellRect(r, c, true).getX() + 50, (int)PanInternalTimedProgram.this.tableITP.getCellRect(r, c, true).getY());
                    }
                    catch (ParseException e) {
                        e.printStackTrace();
                    }
                }
            }
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
        }
    }
}

