/*
 * Decompiled with CFR 0.152.
 */
package pscs;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;

public class MyButtonIcon
extends JButton {
    private static final long serialVersionUID = 1L;
    private Border borderOut;
    private Border borderIn;
    private Border borderPressed;
    private Color bc;

    public MyButtonIcon(String pngFile) {
        this.setIcon(new ImageIcon(pngFile));
        this.init();
    }

    public MyButtonIcon(URL url) {
        this.setIcon(new ImageIcon(url));
        this.init();
    }

    private void init() {
        this.setContentAreaFilled(false);
        this.setPreferredSize(new Dimension(22, 22));
        this.borderIn = BorderFactory.createBevelBorder(0, new Color(230, 232, 234), new Color(170, 175, 178), new Color(200, 202, 204), new Color(140, 145, 148));
        this.borderPressed = BorderFactory.createBevelBorder(1, this.getBackground(), Color.WHITE, new Color(98, 101, 103), this.getBackground());
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                MyButtonIcon.this.thisButton_mouseEntered(e);
            }

            @Override
            public void mouseExited(MouseEvent e) {
                MyButtonIcon.this.thisButton_mouseExited(e);
            }

            @Override
            public void mousePressed(MouseEvent e) {
                MyButtonIcon.this.thisButton_mousePressed(e);
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                MyButtonIcon.this.thisButton_mouseReleased(e);
            }
        });
    }

    void thisButton_mouseEntered(MouseEvent e) {
        if (this.isEnabled()) {
            this.setBorder(this.borderIn);
        }
    }

    void thisButton_mouseExited(MouseEvent e) {
        this.setBorder(this.borderOut);
    }

    void thisButton_mousePressed(MouseEvent e) {
        this.bc = this.getForeground();
        this.setForeground(Color.WHITE);
        if (this.isEnabled()) {
            this.setBorder(this.borderPressed);
        }
    }

    void thisButton_mouseReleased(MouseEvent e) {
        this.setForeground(this.bc);
        this.setBorder(this.borderIn);
    }
}

